/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.scenedata;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode;
import com.huawei.ism.tool.framework.pubservice.entity.PriKeyInfo;
import com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.framework.pubservice.scenedata.ToolRunResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SceneXmlData {
    private static final String NO_SNS_NULL = "null";
    private static final String RIGHT = "]";
    private static final String LEFT = "[";
    private static final String EMPTY = "";
    private static final String REGEX = ",";
    private static final String REMOTE_SNS = "remoteSNs";
    private static final char RIGHT_BRACKET = ']';
    private static final char LEFT_BRACKET = '[';
    private static final String IP_LIST = "ipList";
    private static final String HOST_ASSOCIATED_REMOTESN = "hostAssociatedRemoteSN";
    private static final String DEVICE_SERIAL_NUMBER = "deviceSerialNumber";
    private static final String TLV_PORT = "tlvPort";
    private static final String IP_LIST_ARE_INNER_IP = "ipListAreInnerIp";
    private static final String PASSW = "password";
    private static final String ADMIN_NAME = "adminName";
    private static final String ADMIN_PASSWORD = "adminPassword";
    private static final String DOMAIN_NAME = "domainName";
    private static final String USER_NAME = "userName";
    private static final String DEVELOPER_PWD = "developerPwd";
    private static final String SN = "SN";
    private static final String SSH_FORWARDLIST = "sshForwardList";
    private static final String SOCKS5PROXY = "socks5Proxy";
    private static final String DEVICE_NAME = "deviceName";
    private static final String PORT = "port";
    private static final String PRODUCT_VERSION = "productVersion";
    private static final String HOTPATCH_VERSION = "hotpatchversion";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String IT_DEVICE_TYPE = "itDeviceType";
    private static final String DEV_TYPE_LEVEL2 = "devTypeLevel2";
    private static final String DB_NAME = "dbName";
    private static final String USE_JDBC = "useJdbc";
    private static final String IP = "IP";
    private static final String PRI_KEY_INFO = "PriKeyInfo";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneXmlData.class);
    private static final String HOST_ISCSI_LAUN_WWNS = "hostISCSILauncherWwns";
    private static final String HOST_FC_LAUN_WWNS = "hostFCLauncherWwns";
    private static final String HOST_IB_LAUN_WWNS = "hostIbLauncherWwns";
    private static final String HOST_NVME_LAUN_WWNS = "hostNvmeLauncherWwns";
    private static final String IS_SVP_SUPPORT = "isSVPSupport";
    private static final String NODE_ADD_TYPE = "nodeAddType";
    private static final String IS_VERIFY_CERTIFICATE = "isVerifyCertificate";
    private static final String HIGH_DEV_SVP_MODULE_INFO = "highDevSVPModuleInfo";
    private static final String CAN_ENTER_DIAGNOSE = "canEnterDiagnose";
    private static final String CMP_FCV_OPENAPI_USER_NAME = "computeStorageInfoFcvOpenApiUserName";
    private static final String CMP_FCV_OPENAPI_USER_P = "computeStorageInfoFcvOpenApiUserPwd";
    private static final String CMP_FCV_STORAGE_USER_NAME = "computeStorageInfoFcvStorageUserName";
    private static final String CMP_FCV_IP = "computeStorageInfoFcvIp";
    private static final String CMP_STORAGE_IP = "computeStorageIp";
    private static final String STORAGE_DEVICE_TYPE = "storageDeviceType";
    private static final String CMP_FCV_DEVICE_ID = "computeStorageInfoFcvDeviceId";
    private static final String CMP_FCV_STORAGE_INFO_LIST = "computeStorageInfoList";
    private static final String CMP_FCV_STORAGE_INFO_CHASSISNUM = "computeStorageInfoChassisNum";
    private static final String DEVICE_INFO = "deviceInfo";
    private static final String XML_PATH = SceneUtils.getSceneFilePath("sceneDeviceList.xml");
    private static File file = new File(XML_PATH);
    private static DocumentBuilder documentBuilder = null;
    private static SceneXmlData instance = null;

    private SceneXmlData() {
        try {
            SceneXmlData.initBuilder();
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(XmlUtils.class).error("documentBuilder build faild", (Throwable)e);
        }
    }

    private static void initBuilder() throws ParserConfigurationException {
        documentBuilder = XmlUtils.newDocumentBuilder();
    }

    public static synchronized SceneXmlData getInstance() {
        if (instance == null) {
            instance = new SceneXmlData();
        }
        return instance;
    }

    private Document getDoc(String fileName) {
        Document doc = null;
        try {
            if (StringUtils.isNULLStr(fileName)) {
                doc = documentBuilder.parse(file);
            } else {
                String currentFile = SceneUtils.getSceneFilePath(fileName);
                doc = documentBuilder.parse(currentFile);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
        }
        catch (Exception e) {
            LOGGER.error("Could not found the file.", (Throwable)e);
        }
        return doc;
    }

    public TaskResult writeDevData2File(List<DevNode> devs, List<Map<String, String>> listMap) {
        DocumentBuilder builder;
        try {
            builder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("DocumentBuilder builder error.", (Throwable)e);
            return new TaskResult();
        }
        if (null == builder) {
            LOGGER.error("DocumentBuilder builder is null.");
            return new TaskResult();
        }
        Document newdoc = null;
        try {
            newdoc = builder.newDocument();
        }
        catch (Exception e) {
            LOGGER.error("scene xml create failed");
            return new TaskResult();
        }
        Element root = newdoc.createElement("scene");
        newdoc.appendChild(root);
        SceneEnvironmentImpl scene = (SceneEnvironmentImpl)SceneEnvironmentImpl.getInstance();
        return scene.writeDataToStore(newdoc, root, listMap);
    }

    public TaskResult writeDevData2File(List<Map<String, String>> listMap, String indent) {
        DocumentBuilder builder;
        try {
            builder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("DocumentBuilder builder error.", (Throwable)e);
            return new TaskResult();
        }
        if (Objects.isNull(builder)) {
            LOGGER.error("DocumentBuilder builder is null.");
            return new TaskResult();
        }
        Document newdoc = builder.newDocument();
        Element root = newdoc.createElement("scene");
        newdoc.appendChild(root);
        SceneEnvironmentImpl scene = (SceneEnvironmentImpl)SceneEnvironmentImpl.getInstance();
        return scene.writeDataToStore(newdoc, root, listMap, indent);
    }

    public TaskResult writeDevData2File(List<DevNode> devs, List<Map<String, String>> listMap, File aimFile) {
        DocumentBuilder builder;
        try {
            builder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("DocumentBuilder builder error.", (Throwable)e);
            return new TaskResult();
        }
        if (null == builder) {
            LOGGER.error("DocumentBuilder builder is null.");
            return new TaskResult();
        }
        Document newdoc = null;
        try {
            newdoc = builder.newDocument();
        }
        catch (Exception e) {
            LOGGER.error("scene xml create failed");
            return new TaskResult();
        }
        Element root = newdoc.createElement("scene");
        newdoc.appendChild(root);
        SceneEnvironmentImpl scene = (SceneEnvironmentImpl)SceneEnvironmentImpl.getInstance();
        return scene.writeDataToStore(newdoc, root, listMap, aimFile);
    }

    public List<DevNode> loadSceneFromFile() {
        return this.loadSceneFromFile(null);
    }

    public List<DevNode> loadSceneFromFile(String FileName) {
        ArrayList<DevNode> nodeList = new ArrayList<DevNode>();
        Document doc = this.getDoc(FileName);
        if (null == doc) {
            LOGGER.error("Could not found file.");
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList deviceInfoData = root.getElementsByTagName(DEVICE_INFO);
        for (int i = 0; i < deviceInfoData.getLength(); ++i) {
            this.getDeviceInfoChildren(deviceInfoData, nodeList);
        }
        return nodeList;
    }

    public List<DevNode> loadDeviceFromFile(String FileName) {
        ArrayList<DevNode> nodeList = new ArrayList<DevNode>();
        Document doc = null;
        try {
            doc = documentBuilder.parse(FileName);
        }
        catch (Exception e) {
            LOGGER.error("Could not found file.");
        }
        if (null == doc) {
            LOGGER.error("Could not found file.");
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList deviceInfoData = root.getElementsByTagName(DEVICE_INFO);
        for (int i = 0; i < deviceInfoData.getLength(); ++i) {
            this.getDeviceInfoChildren(deviceInfoData, nodeList);
        }
        LOGGER.info("loadDeviceFromFile:{}", nodeList);
        return nodeList;
    }

    public Map<String, List<ToolRunResult>> loadToolResultFromFile() {
        HashMap<String, List<ToolRunResult>> nodeMap = new HashMap<String, List<ToolRunResult>>();
        Document doc = this.getDoc(EMPTY);
        if (null == doc) {
            LOGGER.error("Could not found file.");
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList toolIdData = root.getElementsByTagName("toolId");
        for (int i = 0; i < toolIdData.getLength(); ++i) {
            Node oneToolIdNode = toolIdData.item(i);
            if (!(oneToolIdNode instanceof Element)) continue;
            String toolId = ((Element)oneToolIdNode).getAttribute("toolId");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("parse device data, toolId = " + toolId);
            }
            if (StringUtils.isNULLStr(toolId)) continue;
            List<ToolRunResult> oneToolRunResults = this.getToolInfoChildren(oneToolIdNode);
            nodeMap.put(toolId, oneToolRunResults);
        }
        return nodeMap;
    }

    private List<ToolRunResult> getToolInfoChildren(Node oneToolIdNode) {
        ArrayList<ToolRunResult> results = new ArrayList<ToolRunResult>();
        if (oneToolIdNode instanceof Element) {
            for (Element device : XmlUtils.getChildren((Element)oneToolIdNode)) {
                Map<String, String> deviceDatamap = this.createDeviceDataMap(device);
                if (StringUtils.isNULLStr(deviceDatamap.get(IP)) || StringUtils.isNULLStr(deviceDatamap.get(DEVICE_SERIAL_NUMBER))) {
                    LOGGER.info("the step result is null.");
                    continue;
                }
                ToolRunResult result = this.createDeviceResult(deviceDatamap);
                results.add(result);
            }
        }
        return results;
    }

    private ToolRunResult createDeviceResult(Map<String, String> deviceDatamap) {
        ToolRunResult result = new ToolRunResult();
        result.setIp(deviceDatamap.get(IP));
        result.setSn(deviceDatamap.get(SN));
        if (deviceDatamap.containsKey("status")) {
            result.setStatus(deviceDatamap.get("status"));
        }
        return result;
    }

    public List<DevNode> getDeviceToModify(DevNode devNode) {
        if (devNode == null || !new File(XML_PATH).exists()) {
            return null;
        }
        List<DevNode> devices = this.loadSceneFromFile();
        if (null == devices) {
            throw new NullPointerException();
        }
        int i = 0;
        Iterator<DevNode> devNodeIterator = devices.iterator();
        while (devNodeIterator.hasNext()) {
            DevNode dn = devNodeIterator.next();
            if (!devNode.getDeviceSerialNumber().equals(dn.getDeviceSerialNumber())) continue;
            devNodeIterator.remove();
            devices.add(i, devNode);
            return devices;
        }
        return devices;
    }

    public void doModify(List<DevNode> devices, List<Map<String, String>> listMap) {
        if (devices == null || devices.isEmpty()) {
            return;
        }
        TaskResult tr = this.writeDevData2File(devices, listMap);
        if (!TaskResult.Result.SUCCESS.equals((Object)tr.getResult())) {
            LOGGER.error("update device info to File error!" + tr.getErrorLocaleDescription());
            return;
        }
        LOGGER.info("update device info to File success!");
    }

    private void getDeviceInfoChildren(NodeList deviceInfoData, List<DevNode> nodeList) {
        Node deviceinfoNode = deviceInfoData.item(0);
        if (deviceinfoNode instanceof Element) {
            for (Element device : XmlUtils.getChildren((Element)deviceinfoNode)) {
                Map<String, String> deviceDatamap = this.createDeviceDataMap(device);
                this.createDevice(deviceDatamap, nodeList);
            }
        }
    }

    private Map<String, String> createDeviceDataMap(Element device) {
        HashMap<String, String> deviceDatamap = new HashMap<String, String>();
        String ip = device.getAttribute(IP);
        String deviceSerialNumber = device.getAttribute(SN);
        for (Element deviceData : XmlUtils.getChildren(device)) {
            deviceDatamap.put(deviceData.getTagName(), deviceData.getTextContent());
        }
        deviceDatamap.put(IP, ip);
        deviceDatamap.put(DEVICE_SERIAL_NUMBER, deviceSerialNumber);
        return deviceDatamap;
    }

    private void createDevice(Map<String, String> deviceDatamap, List<DevNode> nodeList) {
        DevNode devNode = new DevNode();
        User user = this.setGeneralParams(deviceDatamap, devNode);
        this.setIndividualParams(deviceDatamap, devNode, user);
        LOGGER.info("highDevSVPModuleInfo:" + deviceDatamap.get(HIGH_DEV_SVP_MODULE_INFO));
        devNode.setHighDevSVPModuleInfo(deviceDatamap.get(HIGH_DEV_SVP_MODULE_INFO));
        nodeList.add(devNode);
    }

    private User setGeneralParams(Map<String, String> deviceDatamap, DevNode devNode) {
        devNode.setIp(deviceDatamap.get(IP));
        devNode.setDeviceType(DeviceType.valueOf(deviceDatamap.get(DEVICE_TYPE)));
        String iTDeviceType = deviceDatamap.get(IT_DEVICE_TYPE);
        LOGGER.info("iTDeviceType:{}", (Object)iTDeviceType);
        if (!StringUtils.isNULLStr(iTDeviceType)) {
            if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)iTDeviceType, (CharSequence[])new CharSequence[]{ItDeviceType.FUSIONCUBE.name(), ItDeviceType.FUSIONCUBE.getName()})) {
                devNode.setItDeviceType(ItDeviceType.FUSIONCUBE);
            } else {
                devNode.setItDeviceType(ItDeviceType.of(iTDeviceType));
            }
        }
        devNode.setDevTypeLevel2(DeviceType.valueOf(deviceDatamap.get(DEV_TYPE_LEVEL2)));
        devNode.setProductVersion(deviceDatamap.get(PRODUCT_VERSION));
        devNode.setHotPatchVersion(deviceDatamap.get(HOTPATCH_VERSION));
        devNode.setPort(Integer.parseInt(deviceDatamap.get(PORT)));
        devNode.setDbName(deviceDatamap.get(DB_NAME));
        devNode.setUseJdbc(Boolean.parseBoolean(deviceDatamap.get(USE_JDBC)));
        devNode.setDeviceName(deviceDatamap.get(DEVICE_NAME));
        devNode.setDeviceSerialNumber(deviceDatamap.get(DEVICE_SERIAL_NUMBER));
        devNode.setDeveloperPwd(AESEncrypt.decrypt(deviceDatamap.get(DEVELOPER_PWD)));
        devNode.setDevInfoPkgPath(deviceDatamap.get("devInfoPkgPath"));
        devNode.setHyperMetroHost(Boolean.parseBoolean(deviceDatamap.get("isHyperMetroHost")));
        devNode.setCanEnterDiagnose(Boolean.parseBoolean(deviceDatamap.get(CAN_ENTER_DIAGNOSE)));
        devNode.setSelectedNodeIps(Arrays.asList(deviceDatamap.getOrDefault("selectNodeIps", EMPTY).split(REGEX)));
        if (!StringUtils.isNULLObjectOrNullStr(deviceDatamap.get(NODE_ADD_TYPE))) {
            devNode.setNodeAddType(NodeAddEnum.valueOf(deviceDatamap.get(NODE_ADD_TYPE)));
        }
        if (!StringUtils.isNULLObjectOrNullStr(deviceDatamap.get(IS_VERIFY_CERTIFICATE))) {
            devNode.setVerifyCertificate(Boolean.parseBoolean(deviceDatamap.get(IS_VERIFY_CERTIFICATE)));
        }
        List<String> iscsiList = this.handleHostWWN(deviceDatamap, HOST_ISCSI_LAUN_WWNS);
        devNode.setHostISCSILauncherWwns(iscsiList);
        List<String> fcList = this.handleHostWWN(deviceDatamap, HOST_FC_LAUN_WWNS);
        devNode.setHostFCLauncherWwns(fcList);
        List<String> ibList = this.handleHostWWN(deviceDatamap, HOST_IB_LAUN_WWNS);
        devNode.setHostIbLauncherWwns(ibList);
        List<String> nvmeList = this.handleHostWWN(deviceDatamap, HOST_NVME_LAUN_WWNS);
        devNode.setHostNvmeLauncherWwns(nvmeList);
        devNode.setStorageDeviceType(ItDeviceType.valueOf(deviceDatamap.getOrDefault(STORAGE_DEVICE_TYPE, ItDeviceType.Storage.getName())));
        this.setComputeDevInfo(deviceDatamap, devNode);
        return new User(deviceDatamap.get(USER_NAME), AESEncrypt.decrypt(deviceDatamap.get(PASSW)));
    }

    private void setComputeDevInfo(Map<String, String> deviceDataMap, DevNode devNode) {
        String fcvIp = deviceDataMap.getOrDefault(CMP_FCV_IP, EMPTY);
        if (devNode.getStorageDeviceType().equals((Object)ItDeviceType.COMPUTE_STORAGE) && !StringUtils.isNULLStr(fcvIp) && !NO_SNS_NULL.equalsIgnoreCase(fcvIp)) {
            User user = new User(deviceDataMap.getOrDefault(CMP_FCV_OPENAPI_USER_NAME, EMPTY), AESEncrypt.decrypt(deviceDataMap.getOrDefault(CMP_FCV_OPENAPI_USER_P, EMPTY)));
            ComputeStorageDevNode csDevNode = new ComputeStorageDevNode();
            csDevNode.setOpenapiUser(user);
            csDevNode.setFcvIp(deviceDataMap.getOrDefault(CMP_FCV_IP, EMPTY));
            csDevNode.setComputeStorageFcvDeviceId(deviceDataMap.getOrDefault(CMP_FCV_DEVICE_ID, EMPTY));
            csDevNode.setChassisNum(deviceDataMap.getOrDefault(CMP_FCV_STORAGE_INFO_CHASSISNUM, "1"));
            String storageJson = deviceDataMap.getOrDefault(CMP_FCV_STORAGE_INFO_LIST, EMPTY);
            if (!StringUtils.isNULLStr(storageJson) && !NO_SNS_NULL.equalsIgnoreCase(storageJson)) {
                csDevNode.setStorageNodesInfo(SceneXmlData.jsonToListHashMap(new JSONArray(storageJson)));
            }
            devNode.setComputeStorageDevNode(csDevNode);
        }
    }

    public static List<Map<String, String>> jsonToListHashMap(JSONArray jsonArray) {
        ArrayList<Map<String, String>> objlist = new ArrayList<Map<String, String>>();
        IntStream.range(0, jsonArray.length()).mapToObj(jsonArray::getJSONObject).forEach(obj -> {
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator keys = obj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)obj.get(key);
                map.put(key, value);
            }
            objlist.add(map);
        });
        return objlist;
    }

    private void setIndividualParams(Map<String, String> deviceDatamap, DevNode devNode, User user) {
        if (!StringUtils.isNULLObjectOrNullStr(deviceDatamap.get(ADMIN_NAME)) && !StringUtils.isNULLObjectOrNullStr(deviceDatamap.get(ADMIN_PASSWORD))) {
            User adminUser = new User(deviceDatamap.get(ADMIN_NAME), AESEncrypt.decrypt(deviceDatamap.get(ADMIN_PASSWORD)));
            devNode.setAdminUser(adminUser);
        }
        if (!StringUtils.isNULLObjectOrNullStr(deviceDatamap.get(DOMAIN_NAME))) {
            user.setDomainName(deviceDatamap.get(DOMAIN_NAME));
        }
        devNode.setLoginUser(user);
        this.setFusionCubeInfo(deviceDatamap, devNode);
        String rootPassword = deviceDatamap.get("rootPassword");
        if (!StringUtils.isNULLObjectOrNullStr(rootPassword)) {
            User rootUser = new User("root", AESEncrypt.decrypt(rootPassword));
            devNode.setRootUser(rootUser);
        }
        devNode.setIpListAreInnerIp(Boolean.valueOf(deviceDatamap.get(IP_LIST_ARE_INNER_IP)));
        devNode.setTlvPort(Integer.parseInt(deviceDatamap.get(TLV_PORT)));
        this.handleSNS(deviceDatamap, devNode);
        String ipListStr = deviceDatamap.get(IP_LIST);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Dev iplist" + ipListStr);
        }
        this.fillIpList(devNode, ipListStr);
        String hostAssociatedRemoteSNStr = deviceDatamap.get(HOST_ASSOCIATED_REMOTESN);
        this.fillhostAssociatedRemoteSNList(devNode, hostAssociatedRemoteSNStr);
        if (deviceDatamap.containsKey(SSH_FORWARDLIST) && !StringUtils.isNULLStr(deviceDatamap.get(SSH_FORWARDLIST))) {
            this.handleDevSshForward(deviceDatamap.get(SSH_FORWARDLIST), devNode);
        }
        if (deviceDatamap.containsKey(SOCKS5PROXY) && !StringUtils.isNULLStr(deviceDatamap.get(SOCKS5PROXY))) {
            this.handleDevSocks5(deviceDatamap.get(SOCKS5PROXY), devNode);
        }
        if (deviceDatamap.containsKey(PRI_KEY_INFO) && !StringUtils.isNULLStr(deviceDatamap.get(PRI_KEY_INFO))) {
            this.handleDevPublicKey(deviceDatamap.get(PRI_KEY_INFO), devNode);
        }
    }

    private void setFusionCubeInfo(Map<String, String> deviceDatamap, DevNode devNode) {
        if (devNode.isFusionCube()) {
            String scenarioInfo;
            String sshUsername = deviceDatamap.get("sshUsername");
            String sshPassword = deviceDatamap.get("sshPassword");
            if (!StringUtils.isNULLObjectOrNullStr(sshUsername) && !StringUtils.isNULLObjectOrNullStr(sshPassword)) {
                User fusionCubeUser = new User(sshUsername, AESEncrypt.decrypt(sshPassword));
                devNode.setFusionCubeLoginUser(fusionCubeUser);
            }
            if (!StringUtils.isNULLObjectOrNullStr(scenarioInfo = deviceDatamap.get("scenarioInfo"))) {
                devNode.setScenarioInfo(scenarioInfo);
            }
        }
    }

    public List<String> handleHostWWN(Map<String, String> deviceDatamap, String key) {
        ArrayList<String> resList = new ArrayList<String>();
        String tmpString = deviceDatamap.get(key);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(key + tmpString);
        }
        if (!StringUtils.isNULLStr(tmpString) && !NO_SNS_NULL.equalsIgnoreCase(tmpString)) {
            String[] strList = tmpString.replace(LEFT, EMPTY).replace(RIGHT, EMPTY).split(REGEX);
            for (int i = 0; i < strList.length; ++i) {
                if (StringUtils.isNULLStr(strList[i].trim())) continue;
                resList.add(strList[i].trim());
            }
        }
        return resList;
    }

    public void handleSNS(Map<String, String> deviceDatamap, DevNode devNode) {
        String remoteSNs = deviceDatamap.get(REMOTE_SNS);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(REMOTE_SNS + remoteSNs);
        }
        if (!StringUtils.isNULLStr(remoteSNs) && !NO_SNS_NULL.equalsIgnoreCase(remoteSNs)) {
            String[] sns = remoteSNs.replace(LEFT, EMPTY).replace(RIGHT, EMPTY).split(REGEX);
            ArrayList<String> snsList = new ArrayList<String>();
            for (int i = 0; i < sns.length; ++i) {
                if (StringUtils.isNULLStr(sns[i].trim())) continue;
                snsList.add(sns[i].trim());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("snsList" + snsList);
            }
            devNode.setRemoteSNs(snsList);
        }
    }

    private void fillhostAssociatedRemoteSNList(DevNode devNode, String hostAssociatedRemoteSNStr) {
        if (!StringUtils.isNULLStr(hostAssociatedRemoteSNStr)) {
            String[] hostAssociatedRemoteSNArr;
            String hostAssociatedRemoteSNS = hostAssociatedRemoteSNStr.replace(String.valueOf('['), EMPTY).replace(String.valueOf(']'), EMPTY);
            for (String hostAssociatedRemoteSN : hostAssociatedRemoteSNArr = hostAssociatedRemoteSNS.split(REGEX)) {
                if (StringUtils.isNULLStr(hostAssociatedRemoteSN)) continue;
                devNode.getHostAssociatedRemoteSN().add(hostAssociatedRemoteSN.trim());
            }
        }
    }

    private void fillIpList(DevNode devNode, String ipListStr) {
        if (!StringUtils.isNULLStr(ipListStr)) {
            String[] ipArr;
            String ips = ipListStr.replace(String.valueOf('['), EMPTY).replace(String.valueOf(']'), EMPTY);
            for (String ip : ipArr = ips.split(REGEX)) {
                devNode.addIp(ip.trim());
            }
        }
    }

    private void handleDevSshForward(String jsonObject, DevNode devNode) {
        try {
            JSONArray jsonArraySsh = new JSONArray(jsonObject);
            ArrayList<MultiRouteNode> muList = new ArrayList<MultiRouteNode>();
            for (int k = 0; k < jsonArraySsh.length(); ++k) {
                JSONObject jsonSsh = jsonArraySsh.getJSONObject(k);
                MultiRouteNode multiRouteNode = new MultiRouteNode(jsonSsh.getString("host"), jsonSsh.getInt(PORT), jsonSsh.getString("uname"), AESEncrypt.decrypt(jsonSsh.getString("pwd")));
                muList.add(multiRouteNode);
            }
            devNode.setSshForwardList(muList);
        }
        catch (Exception e) {
            LOGGER.error("SSH does not exist on the device", (Throwable)e);
            devNode.setSshForwardList(null);
        }
    }

    private void handleDevSocks5(String jsonObject, DevNode devNode) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("get para in handleDevSocks5 : " + StringUtils.maskPassword(jsonObject));
            }
            JSONObject jsonDevSocks5 = new JSONObject(jsonObject);
            Socks5Proxy socks5Proxy = this.toDevNodeSocks5(jsonDevSocks5);
            devNode.setSocks5Proxy(socks5Proxy);
        }
        catch (Exception e) {
            LOGGER.error("Socks5 does not exist on the device", (Throwable)e);
            devNode.setSocks5Proxy(null);
        }
    }

    private Socks5Proxy toDevNodeSocks5(JSONObject jsonSocks5) throws JSONException {
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.setPort(jsonSocks5.getString(PORT));
        socks5Proxy.setName(jsonSocks5.getString("name"));
        socks5Proxy.setServerIp(jsonSocks5.getString("serverIp"));
        socks5Proxy.setUuid(jsonSocks5.getString("uuid"));
        socks5Proxy.setUser(jsonSocks5.getString("user"));
        socks5Proxy.setPass(AESEncrypt.decrypt(jsonSocks5.getString("pass")));
        socks5Proxy.setAuthentic(jsonSocks5.getBoolean("authentic"));
        return socks5Proxy;
    }

    private void handleDevPublicKey(String jsonObject, DevNode devNode) {
        try {
            LOGGER.info("get para in handleDevPublicKey success.");
            JSONObject jsonDevPublicKey = new JSONObject(jsonObject);
            PriKeyInfo publicKeyInfo = this.toDevPublicKey(jsonDevPublicKey);
            devNode.setPriKey(publicKeyInfo);
        }
        catch (Exception e) {
            LOGGER.error("PublicKey does not exist on the device", (Throwable)e);
            devNode.setPriKey(null);
        }
    }

    private PriKeyInfo toDevPublicKey(JSONObject jsonPublicKey) throws JSONException {
        PriKeyInfo publicKeyInfo = new PriKeyInfo();
        publicKeyInfo.setKeyPath(jsonPublicKey.getString("keyPath"));
        publicKeyInfo.setKeyPwd(AESEncrypt.decrypt(jsonPublicKey.getString("keyPwd")));
        publicKeyInfo.setKeyName(jsonPublicKey.getString("keyName"));
        return publicKeyInfo;
    }
}

