/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class FileChooseUtils {
    private static final String DEFAULT_PATH_FILE = "file_choose_default.properties";
    private static final FileChooseUtils INSTANCE = new FileChooseUtils();
    private Properties pro = null;
    private String tmpPath = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private FileChooseUtils() {
        String tmpPstr = FilePathUtils.getSafePath(System.getProperty("tool.tempPath"));
        this.tmpPath = StringUtils.isNULLStr(tmpPstr) ? ApplicationContext.getInstance().getWorkPath() + File.separator + ApplicationContext.getInstance().getTmpPath() : tmpPstr;
        this.pro = new Properties();
        FileInputStream is = null;
        try {
            File file = this.getChooseDefaultFile();
            is = new FileInputStream(file);
            this.pro.load(is);
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property load error. file {} not found.", (Object)DEFAULT_PATH_FILE);
            StreamUtils.closeStream(null, is);
        }
        catch (IOException e2) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property load error.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, is);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, is);
        }
        StreamUtils.closeStream(null, is);
    }

    private File getChooseDefaultFile() throws IOException {
        File file;
        File tmpPFile = new File(this.tmpPath);
        if (!tmpPFile.exists() && !tmpPFile.mkdir()) {
            ToolLoggerFactory.getLogger(this.getClass()).error("mkdir error.");
        }
        if (!(file = new File(this.tmpPath, DEFAULT_PATH_FILE)).exists() && !file.createNewFile()) {
            ToolLoggerFactory.getLogger(this.getClass()).error("create file error.");
        }
        return file;
    }

    public static FileChooseUtils getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String put(String key, String value) {
        Enumeration<?> enumeration = this.pro.propertyNames();
        if (!enumeration.hasMoreElements()) {
            this.pro.setProperty(key, value);
        } else {
            Enumeration<?> e = this.pro.propertyNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.equals(key)) continue;
                this.pro.setProperty(s, this.pro.getProperty(s));
            }
            this.pro.setProperty(key, value);
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(this.tmpPath, DEFAULT_PATH_FILE));
            this.pro.store(os, "test");
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property store error.file {} not found.", (Object)DEFAULT_PATH_FILE);
            StreamUtils.closeStream(os, null);
        }
        catch (IOException e2) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property store error.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(os, null);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(os, null);
        }
        StreamUtils.closeStream(os, null);
        return value;
    }

    public String get(String key) {
        return this.pro.getProperty(key);
    }

    public Map<String, String> getMapData() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> e = this.pro.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, this.pro.getProperty(key));
        }
        return map;
    }
}

