/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubui.entity;

import java.util.ArrayList;
import java.util.List;

public enum UpdateStatus {
    updateOneHour("normal", 0, "update", 60),
    updateFourHour("updateFourHour", 1, "update", 240),
    updateOneDay("updateOneDay", 2, "update", 1440),
    updateOneWeek("updateOneWeek", 3, "update", 10080),
    never("never", 4, "update", 2000000000),
    remindOneHour("oneHour", 0, "remind", 60),
    remindFourHour("remindFourHour", 1, "remind", 240),
    startBox("startBox", 2, "remind", 2000000000);

    private String desc;
    private int index;
    private String type;
    private int period;

    private UpdateStatus(String desc, int index, String type, int period) {
        this.desc = desc;
        this.index = index;
        this.type = type;
        this.period = period;
    }

    public static List<UpdateStatus> getUpdateStatusListByType(String type) {
        UpdateStatus[] updateStatusList = UpdateStatus.values();
        ArrayList<UpdateStatus> neededUpdateStatusList = new ArrayList<UpdateStatus>();
        for (UpdateStatus u : updateStatusList) {
            if (!u.type.equals(type)) continue;
            neededUpdateStatusList.add(u);
        }
        return neededUpdateStatusList;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLangResource() {
        return "systemconfig.update.config.update." + this.desc;
    }

    public static UpdateStatus findUpdateStatusByIndex(int strIndex, String type) {
        UpdateStatus[] updateList;
        for (UpdateStatus u : updateList = UpdateStatus.values()) {
            if (u.index != strIndex || !u.type.equals(type)) continue;
            return u;
        }
        return null;
    }

    public static UpdateStatus findUpdateStatusByDesc(String strDesc) {
        UpdateStatus[] updateList;
        for (UpdateStatus u : updateList = UpdateStatus.values()) {
            if (!u.desc.equals(strDesc)) continue;
            return u;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public int getPeriod() {
        return this.period;
    }
}

