/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ProperUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.common.tool.IDuplicationHandler;
import com.huawei.ism.tool.framework.platform.common.tool.ITool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.singletoolbox.utils.DefaultDuplicationHandler;
import com.huawei.ism.tool.singletoolbox.utils.SingletoolBoxContext;
import com.huawei.ism.tool.singletoolbox.utils.UserDataRefresher;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class SingletoolBox
extends AbstractToolBox {
    private static final String CONFIGURATION = "configuration";
    private static final String RELEASE_TIME_MARK = "20190712000000";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SingletoolBox.class);
    private static final int SLEEP_TIME = 300000;
    private static final int GET_LOCK_SLEAP_TIME = 100;
    private static final int TIME_OUT = 2000;
    private static final Object lock = new Object();
    private static Map<String, String> iniCache = new HashMap<String, String>();
    private ITool curTool = null;
    private boolean lockedSuccess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockedSuccess() {
        Object object = lock;
        synchronized (object) {
            return this.lockedSuccess;
        }
    }

    public String getName() {
        return "Single-Tool Box";
    }

    public boolean init() {
        String refreshPath = System.getenv("refreshDataPath");
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        UserDataRefresher refresh = null;
        if (null != devMng && null != refreshPath) {
            refresh = new UserDataRefresher(refreshPath);
            devMng.addNodeObservers((INodeObserver)refresh);
        }
        return true;
    }

    public boolean containsTool(String name) {
        return false;
    }

    public boolean addTool(ITool tool) {
        if (null == tool) {
            LOGGER.error("Tool is null , cannot add into the single-tool box due to lack of StartItem");
            return false;
        }
        if (null == tool.getStartItem()) {
            LOGGER.error("Tool " + tool.getId() + " cannot add into the single-tool box due to lack of StartItem");
            return false;
        }
        try {
            this.initEnvIfNeeded();
        }
        catch (Error e) {
            LOGGER.error("scene init failed!!!", (Throwable)e);
        }
        if (!this.setCurTool(tool)) {
            LOGGER.error("Tool " + tool.getId() + " cannot add into the single-tool box which already contained tool.");
            return false;
        }
        this.requestFileLock(this.getLockFilePath());
        int time = 0;
        while (!this.isLockedSuccess()) {
            this.sleepTime(100);
            if (2000 > (time += 100)) continue;
        }
        if (!this.isLockedSuccess()) {
            String msg;
            IDuplicationHandler duHandler;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Tool " + tool.getId() + " is already running.");
            }
            if (null == (duHandler = tool.getDuplicationHandler())) {
                duHandler = new DefaultDuplicationHandler();
            }
            if (!duHandler.handleDuplicatedStarting(msg = ResourceUtil.getStringWithParams((String)"tool.already.running", (Object[])new Object[]{tool.getStartItem().getName()}))) {
                Runtime.getRuntime().halt(0);
            }
        }
        StartToolItemTask thread = new StartToolItemTask(tool);
        thread.setUncaughtExceptionHandler((thd, throwable) -> LOGGER.error("thread {} execute error.", (Object)thread.getName(), (Object)throwable));
        thread.start();
        return true;
    }

    private void initEnvIfNeeded() {
        boolean notNeedInitScene;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("is scene :" + SceneUtils.isScene());
        }
        if (notNeedInitScene = UserOpDataSaveUtil.getToolIniBoolProp((String)"tool.notNeedInitScene")) {
            return;
        }
        ISceneEnvironment scene = SceneEnvironmentImpl.getInstance();
        try {
            if (!this.isSingleToolBuildSceneToolBoxDataRight() && !SceneUtils.isScene()) {
                return;
            }
            scene.initSceneEnvir();
        }
        catch (Exception e) {
            LOGGER.error("scene init failed !!!", (Throwable)e);
        }
    }

    private boolean isSingleToolBuildSceneToolBoxDataRight() {
        String tolBoxSysProp = UserOpDataSaveUtil.getToolBoxPath() + File.separator + CONFIGURATION + File.separator + "system.properties";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("system config properties = " + tolBoxSysProp);
        }
        String releaseData = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), "app.release.date");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("releaseData = " + releaseData);
        }
        return releaseData.compareTo(RELEASE_TIME_MARK) > 0;
    }

    private void sleepTime(int times) {
        try {
            Thread.sleep(times);
        }
        catch (InterruptedException e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("sleep error!", (Throwable)e);
        }
    }

    private String getLockFilePath() {
        String toolRunningFlag = "runningFlag";
        String lockFolder = "lockfolder";
        String toolRunningFolderFlag = lockFolder + File.separator + toolRunningFlag;
        if (ApplicationContext.getInstance().isSpecificDeviceModeConfigured()) {
            FileUtils.createDir((String)lockFolder);
            return toolRunningFolderFlag;
        }
        return toolRunningFlag;
    }

    public synchronized void removeTool(String name) {
        this.curTool = null;
    }

    public void fireToolStarted(String toolId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Tool " + toolId + " started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireToolStopped(String toolId) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Tool " + toolId + " stopped, program exit now.");
            }
            iniCache.clear();
            this.getFileMessage();
            if (iniCache.isEmpty()) {
                LOGGER.error("iniCache is null");
            } else {
                String toolNameZH = iniCache.get("tool.title.zh");
                String toolNameEN = iniCache.get("tool.title.en");
                this.addOperationLog(toolNameZH, toolNameEN);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Exit Tool >> " + toolId + "][Success]");
            }
        }
        finally {
            Runtime.getRuntime().halt(0);
        }
    }

    private synchronized boolean setCurTool(ITool tool) {
        if (null != this.curTool) {
            return false;
        }
        this.curTool = tool;
        return true;
    }

    private synchronized void requestFileLock(String id) {
        new Thread(new ReqFileLockTask(id, this)).start();
    }

    protected AbstractContext getContext() {
        return SingletoolBoxContext.getInstance();
    }

    public void registerFailed(String id) {
    }

    public void registerSuccess(String id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getFileMessage() {
        StringBuffer buffer;
        block8: {
            String workPath = ApplicationContext.getInstance().getWorkPath() + File.separator + "tool.ini";
            File file = new File(workPath);
            FileInputStream input = null;
            BufferedReader reader = null;
            buffer = new StringBuffer();
            String line = null;
            try {
                input = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)input, Charset.forName("utf-8")));
                while (null != (line = reader.readLine())) {
                    buffer.append(line);
                    buffer.append(System.getProperty("line.separator"));
                }
                StreamUtils.closeResource(null, (Closeable)reader);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("file not found:{}", (Object)file.getName());
                break block8;
            }
            catch (IOException e2) {
                LOGGER.error("reader ini file filed or readLine filed", (Throwable)e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, (Closeable)input);
            }
            StreamUtils.closeResource(null, (Closeable)input);
        }
        this.analyzeInfo(buffer.toString());
    }

    private void analyzeInfo(String iniOriginalInfo) {
        String[] lines;
        if (null == iniOriginalInfo) {
            throw new NullPointerException();
        }
        for (String line : lines = iniOriginalInfo.split("\n")) {
            if (";".startsWith(line = line.trim()) || !line.contains("=")) continue;
            String[] kv = line.split("=");
            String k = this.safetyGetStr(kv, 0);
            String v = this.safetyGetStr(kv, 1);
            iniCache.put(k.trim(), v.trim());
        }
    }

    private String safetyGetStr(String[] arr, int index) {
        if (arr.length > index) {
            return arr[index].trim();
        }
        return "";
    }

    private void addOperationLog(String nameZh, String nameEn) {
        OperaLog log = new OperaLog();
        log.setOperaName("operalog.name.tool.close");
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName(nameZh);
        log.setDeviceNameEn(nameEn);
        log.setOperateType("operalog.type.system");
        try {
            ILogSupportService logService = (ILogSupportService)PublicServiceManage.getInstance().getService(ILogSupportService.class);
            if (null != logService) {
                logService.addOperaLog(log);
            }
        }
        catch (Exception e) {
            LOGGER.error("Add operation log error.", (Throwable)e);
        }
    }

    public boolean containsIndependentTool(String toolId) {
        File file = new File(new File(ApplicationContext.getInstance().getWorkPath()).getParent());
        File[] files = file.listFiles();
        if (null == files) {
            throw new NullPointerException();
        }
        for (File f : files) {
            String fileName = f.getName();
            if (!toolId.equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public void removeOneTool(String name) {
    }

    private static final class StartToolItemTask
    extends Thread {
        private final ITool tool;

        private StartToolItemTask(ITool tool) {
            this.tool = tool;
        }

        @Override
        public void run() {
            try {
                this.tool.getStartItem().getAction().actionPerformed(null, null);
            }
            catch (Error e) {
                LOGGER.error("scene init failed!!!", (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("scene init failed!!!", e);
            }
        }
    }

    private static final class ReqFileLockTask
    implements Runnable {
        private final String id;
        private final SingletoolBox toolBox;

        private ReqFileLockTask(String id, SingletoolBox toolBox) {
            this.id = id;
            this.toolBox = toolBox;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLockedSuccess(boolean lockedSuccess) {
            SingletoolBox singletoolBox = this.toolBox;
            synchronized (singletoolBox) {
                this.toolBox.lockedSuccess = lockedSuccess;
            }
        }

        private void sleepForever() throws InterruptedException {
            while (ApplicationContext.getInstance().isBlockLcokRealese()) {
                Thread.sleep(300000L);
            }
        }

        private void handleException(String lockFile, FileOutputStream fos, FileLock lock) {
            if (null != lock) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    LOGGER.error("Release file lock " + lockFile + " failed.", (Throwable)e);
                }
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOGGER.error("Release file lock " + lockFile + " failed.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            String lockFile = this.id;
            FileOutputStream fos = null;
            FileLock fileLock = null;
            try {
                fos = new FileOutputStream(lockFile);
                fileLock = fos.getChannel().tryLock();
                if (null != fileLock) {
                    ApplicationContext.getInstance().setToolLockStream(fos);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Obtained file fileLock " + lockFile + " success: " + fileLock);
                    }
                    this.setLockedSuccess(true);
                }
                this.sleepForever();
                LOGGER.error("Cannot obtain file fileLock " + lockFile + ".");
            }
            catch (RuntimeException e) {
                LOGGER.error("Obtain file fileLock " + lockFile + " failed.", (Throwable)e);
                this.handleException(lockFile, fos, fileLock);
            }
            catch (Exception e2) {
                LOGGER.error("Obtain file fileLock " + lockFile + " failed.", (Throwable)e2);
                this.handleException(lockFile, fos, fileLock);
                {
                    catch (Throwable throwable) {
                        this.handleException(lockFile, fos, fileLock);
                        throw throwable;
                    }
                }
            }
            this.handleException(lockFile, fos, fileLock);
        }
    }
}

