/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox.utils;

import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import org.slf4j.Logger;

public class VerifyFilesService
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(VerifyFilesService.class);
    private static final String PYFRAME_JAR = "pyframe.jar";
    private static final String PYFRAME_DIRECTOR = "pyframe_temp";
    private static final String PLUGIN_DIRECTOR_NAME = "plugins";
    private String tempDirectory = "";
    private String pyframeJarPath = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ApplicationContext.getInstance().setValidSign(true);
        try {
            LOGGER.info("start verify files");
            String currentPluginPath = SystemEnvUtil.getDefaultUserDir() + File.separator + PLUGIN_DIRECTOR_NAME + File.separator;
            File pluginDic = new File(currentPluginPath);
            if (!pluginDic.exists()) {
                LOGGER.info("no plugins directory");
                return;
            }
            this.tempDirectory = currentPluginPath + PYFRAME_DIRECTOR + File.separator;
            this.deleteTempDirectory();
            this.pyframeJarPath = currentPluginPath + PYFRAME_JAR;
            File pyframeJarFile = new File(this.pyframeJarPath);
            if (!pyframeJarFile.exists()) {
                LOGGER.info("no pyframe.jar in the folder which singleToolBox.jar exists, end check");
                return;
            }
            FileUtils.createDir(this.tempDirectory);
            FileUtils.unZip(this.tempDirectory, this.pyframeJarPath);
            try {
                SHAAndRSAVerifyUtils.getInstance().verifyDirectoryFiles(this.tempDirectory);
            }
            catch (ToolException e) {
                ApplicationContext.getInstance().setValidSign(false);
            }
        }
        catch (Exception e) {
            LOGGER.error("verify files error:{}", (Object)e.toString());
        }
        finally {
            this.deleteTempDirectory();
            LOGGER.info("end verify files,verify result:{}", (Object)ApplicationContext.getInstance().isValidSign());
        }
    }

    private void deleteTempDirectory() {
        File file = new File(this.tempDirectory);
        if (!file.exists()) {
            LOGGER.info("no temp directory,return");
            return;
        }
        File dirFile = new File(this.tempDirectory);
        FileUtils.deleteFile(dirFile);
        LOGGER.info("delete temp directory successfully");
    }
}

