/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.filter.route;

import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.client.filter.route.AbstractFilter;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericableIdFilter
extends AbstractFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericableIdFilter.class);
    private final String genericableId;

    public GenericableIdFilter(String genericableId) {
        this.genericableId = Validation.notBlank((String)genericableId, (String)"No genericable id to instantiate GenericableIdFilter.", (Object[])new Object[0]);
    }

    @Override
    protected List<Fitable> route(List<Fitable> toFilterFitables, Object[] args) {
        log.debug("Prepare to route by genericable id. [genericableId={}, toFilterFitables={}]", (Object)this.genericableId, toFilterFitables);
        List<Fitable> filteredFitables = toFilterFitables.stream().filter(fitable -> Objects.equals(fitable.getGenericableId(), this.genericableId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredFitables)) {
            log.warn("Fail to route by genericable id. [genericableId={}, toFilterFitables={}]", (Object)this.genericableId, toFilterFitables);
        } else {
            log.debug("Route by genericable id successfully. [genericableId={}, targetFitables={}]", (Object)this.genericableId, filteredFitables);
        }
        return filteredFitables;
    }
}

