/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.common;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.ResourceBoundEnum;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.IDeployTaskInitService;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.DeployTaskInitService;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.FitDeployTaskInitService;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.distributeddeploy.ui.dialog.MainFrame;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
extends AbstractContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    public static final Context INS = new Context();
    private IDeployTaskInitService deployTaskInitService = new DeployTaskInitService();
    private Card.CardScene currentScene = Card.CardScene.MAIN;
    public final DeployNode defaultNode = new DeployNode(this.deployTaskInitService, this.currentScene);
    private MainFrame main = null;
    private ResourceBundle businessRes = null;
    private String currentMappingVersion = "";
    private String armIsoPath = "";
    private String x86IsoPath = "";
    private final Map<Card.CardScene, List<DeployNode>> nodeContext = new ConcurrentHashMap<Card.CardScene, List<DeployNode>>();
    private Set<String> matchCheckStrategy = new HashSet<String>();
    private ResourceBoundEnum scene = ResourceBoundEnum.DEFAULT_FIX;

    private Context() {
        this.initBusinessRes();
        this.initDeployTaskInitService();
    }

    private void initDeployTaskInitService() {
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            this.deployTaskInitService = new FitDeployTaskInitService();
        }
    }

    private void initBusinessRes() {
        String curLang = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        String resFile = String.format(Locale.ENGLISH, "resource_%s.properties", curLang);
        String resPath = Constants.PYTHON_BUSINESS_RES_DIR + File.separator + resFile;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resPath));){
            this.businessRes = new PropertyResourceBundle(bis);
        }
        catch (Exception e) {
            LOGGER.error("Init business resource failed.");
        }
    }

    public String getTaskResString(String key) {
        if (this.businessRes == null || !this.businessRes.containsKey(key)) {
            return "--";
        }
        return this.businessRes.getString(key);
    }

    public MainFrame getMain() {
        return this.main;
    }

    public IUIObserver getUIObs() {
        return this.main.getObs();
    }

    public void setMain(MainFrame main) {
        this.main = main;
    }

    public DeployNode getCurrentSelectNode() {
        return this.main.getCurrentShowNode();
    }

    public String getCurrentMappingVersion() {
        return this.currentMappingVersion;
    }

    public void setCurrentMappingVersion(String currentMappingVersion) {
        this.currentMappingVersion = currentMappingVersion;
    }

    public List<DeployNode> getAllNodes() {
        return this.nodeContext.getOrDefault((Object)this.currentScene, new ArrayList());
    }

    public void clearNodes() {
        ((List)this.nodeContext.getOrDefault((Object)this.currentScene, new ArrayList())).clear();
    }

    public void addNodes(List<DeployNode> nodes) {
        if (this.nodeContext.containsKey((Object)this.currentScene)) {
            this.nodeContext.get((Object)this.currentScene).addAll(nodes);
            return;
        }
        this.nodeContext.putIfAbsent(this.currentScene, nodes);
    }

    public String getReportDir() {
        try {
            return HibernateContainer.getInstance().getOrDefault((Object)"export.report.path", (Object)FileUtils.getDefaultDirectory().getCanonicalPath()).toString();
        }
        catch (IOException e) {
            LOGGER.error("Get report dir error.");
            return "";
        }
    }

    public void setReportDir(String targetDir) {
        LOGGER.info("Modify report dir 2 {}", (Object)targetDir);
        HibernateContainer.getInstance().put("export.report.path", (Object)targetDir);
    }

    public boolean isExpansionScene() {
        String toolEnv = System.getenv("jsonScene");
        return !StringUtils.isNULLStr((String)toolEnv) && toolEnv.contains("Fusionstorage Expansion Evaluation");
    }

    public boolean isFitDeployScene() {
        String toolEnv = System.getenv("jsonScene");
        return !StringUtils.isNULLStr((String)toolEnv) && toolEnv.contains("Distributed Deploy");
    }

    public void setDeployTaskInitService(IDeployTaskInitService deployTaskInitService) {
        this.deployTaskInitService = deployTaskInitService;
    }

    public IDeployTaskInitService getDeployTaskInitService() {
        return this.deployTaskInitService;
    }

    public void setCurrentScene(Card.CardScene currentScene) {
        this.currentScene = currentScene;
    }

    public Card.CardScene getCurrentScene() {
        return this.currentScene;
    }

    public void setArmIsoPath(String armIsoPath) {
        this.armIsoPath = armIsoPath;
    }

    public String getArmIsoPath() {
        return this.armIsoPath;
    }

    public void setX86IsoPath(String x86IsoPath) {
        this.x86IsoPath = x86IsoPath;
    }

    public String getX86IsoPath() {
        return this.x86IsoPath;
    }

    public Set<String> getMatchCheckStrategy() {
        return this.matchCheckStrategy;
    }

    public void setMatchCheckStrategy(Set<String> matchCheckStrategy) {
        this.matchCheckStrategy = matchCheckStrategy;
    }

    public ResourceBoundEnum getScene() {
        return this.scene;
    }

    public void setScene(ResourceBoundEnum scene) {
        this.scene = scene;
    }
}

