/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.common;

import java.util.Arrays;

public enum ResourceBoundEnum {
    DEPLOYMENT_QUALITY_CHECK("quality_check", "config/resource/languages/quality_check_html_res", "VersionMappingCheckReport_%s.zip"),
    BMC_CONFIG("bmc_config", "config/resource/languages/bmc_config_res", "HardwareConfigReport_%s.zip"),
    HARDWARE_CONFIG("hardware_config", "config/resource/languages/bmc_config_res", "HardwareConfigReport_%s.zip"),
    BMC_IP_CONFIG("bmc_ip_config", "config/resource/languages/html_res", "DeployReport_%s.zip"),
    OS_INSTALLATION("os_installation", "config/resource/languages/os_installation_res", "OsInstallation_%s.zip"),
    DEFAULT_FIX("default", "config/resource/languages/html_res", "DeployReport_%s.zip");

    private final String scene;
    private final String resourceBundle;
    private final String reportName;

    public static ResourceBoundEnum of(String scene) {
        return Arrays.stream(ResourceBoundEnum.values()).filter(sceneEnum -> sceneEnum.getScene().equals(scene)).findFirst().orElse(DEFAULT_FIX);
    }

    public static boolean involveMatchVersion(ResourceBoundEnum scene) {
        return !BMC_IP_CONFIG.equals((Object)scene) && !OS_INSTALLATION.equals((Object)scene);
    }

    private ResourceBoundEnum(String scene, String resourceBundle, String reportName) {
        this.scene = scene;
        this.resourceBundle = resourceBundle;
        this.reportName = reportName;
    }

    public String getScene() {
        return this.scene;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public String getReportName() {
        return this.reportName;
    }
}

