/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.common;

import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ToolConfig {
    private static final Logger log = LoggerFactory.getLogger(ToolConfig.class);
    private static final String CONCURRENT_THREAD_NUM_KEY = "concurrent.thread.num";
    private static final String CONCURRENT_MAX_THREAD_NUM_KEY = "concurrent.max.thread.num";
    private static final String SSH_END_STR = "ssh.end.judge";
    private static final String TOOL_MODEL_KEY = "tool.model";
    private static final String MAX_DEV_NUM_KEY = "tool.dev.max.num";
    private static final String MAX_DEPLOY_FILE_SIZE_KEY = "tool.import.file.maxSize";
    private static final String BMC_DEFAULT_IP_KEY = "bmc.default.ip";
    private static final String VLAN_NAME_VERIFY_REG = "vlan.name.verify.reg";
    private static final String VLAN_NAME_MAX_LEN = "vlan.name.max.len";
    private static int threadNum = 20;
    private static int maxThreadNum = 100;
    private static String sshJudge = "iBMC:/->";
    private static boolean debugModel = false;
    private static int maxNodeNum = 256;
    private static String bmcDefaultIp;
    private static final Map<String, Map<String, String>> DEFAULT_IP_MAP;
    private static final List<String> NEED_COMBINE_SN_WITH_SLOT_MODEL;
    private static String vlanNameVerifyReg;
    private static int vlanNameMaxLen;
    private static int maxDeployFileSize;
    private static final ResourceBundle SYS_BUNDLE;

    private static int initNumericValue(String key, int defaultValue) {
        try {
            return Integer.parseInt(SYS_BUNDLE.getString(key));
        }
        catch (NumberFormatException e) {
            log.error("init tool config numeric error, use default value.", (Throwable)e);
            return defaultValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Map<String, String>> initDefaultIp() {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        try (InputStream yamlStream = ToolConfig.getYamlStream();){
            if (Objects.isNull(yamlStream)) {
                log.warn("defaultBmcIpConfig config not found");
                Map<String, Map<String, String>> map = Collections.emptyMap();
                return map;
            }
            Map ipMap = (Map)yaml.load(yamlStream);
            Map needSlot = (Map)ipMap.get("slot");
            NEED_COMBINE_SN_WITH_SLOT_MODEL.addAll(needSlot.keySet());
            DEFAULT_IP_MAP.putAll(needSlot);
            if (!Objects.nonNull(ipMap.get("noSlot"))) return Collections.emptyMap();
            DEFAULT_IP_MAP.putAll((Map)ipMap.get("noSlot"));
            return Collections.emptyMap();
        }
        catch (FileNotFoundException exception) {
            log.error("load defaultBmcIpConfig failed");
            return Collections.emptyMap();
        }
        catch (IOException exception) {
            log.error("load defaultBmcIpConfig failed", (Throwable)exception);
        }
        return Collections.emptyMap();
    }

    private static InputStream getYamlStream() {
        return ToolConfig.class.getClassLoader().getResourceAsStream("config/defaultBmcIpConfig.yaml");
    }

    public static String getResource(String resourceKey) {
        String resource = SYS_BUNDLE.getString(resourceKey);
        log.info("get {} resource {}", (Object)resourceKey, (Object)resource);
        return resource;
    }

    public static String printAttr() {
        return "ThreadNum : " + threadNum + " MaxThreadNum : " + maxThreadNum + " isDebugModel : " + debugModel + " MaxNodeNum : " + maxNodeNum + " MaxDeployFileSize : " + maxDeployFileSize;
    }

    public static String getBmcDefaultIpByType(String devType, String slotId) {
        if (StringUtils.isNULLStr((String)devType) || StringUtils.isNULLStr((String)slotId)) {
            return bmcDefaultIp;
        }
        return DEFAULT_IP_MAP.keySet().stream().filter(devType::contains).map(DEFAULT_IP_MAP::get).map(slotMap -> (String)slotMap.get(slotId)).findFirst().orElse(bmcDefaultIp);
    }

    public static Map<String, Map<String, String>> getDefaultIpMap() {
        return new HashMap<String, Map<String, String>>(DEFAULT_IP_MAP);
    }

    public static boolean isNeedCombineSnWithSlot(String devType) {
        return NEED_COMBINE_SN_WITH_SLOT_MODEL.stream().anyMatch(devType::contains);
    }

    public static int getThreadNum() {
        return threadNum;
    }

    public static int getMaxThreadNum() {
        return maxThreadNum;
    }

    public static String getSshJudge() {
        return sshJudge;
    }

    public static boolean isDebugModel() {
        return debugModel;
    }

    public static int getMaxNodeNum() {
        return maxNodeNum;
    }

    public static String getBmcDefaultIp() {
        return bmcDefaultIp;
    }

    public static String getVlanNameVerifyReg() {
        return vlanNameVerifyReg;
    }

    public static int getVlanNameMaxLen() {
        return vlanNameMaxLen;
    }

    public static int getMaxDeployFileSize() {
        return maxDeployFileSize;
    }

    static {
        DEFAULT_IP_MAP = new HashMap<String, Map<String, String>>();
        NEED_COMBINE_SN_WITH_SLOT_MODEL = new ArrayList<String>();
        vlanNameVerifyReg = "^[A-Za-z][A-Za-z0-9_]*\\.";
        vlanNameMaxLen = 13;
        maxDeployFileSize = 5;
        SYS_BUNDLE = ResourceBundle.getBundle("config.DistributeDeployHelper");
        try {
            threadNum = ToolConfig.initNumericValue(CONCURRENT_THREAD_NUM_KEY, threadNum);
            maxThreadNum = ToolConfig.initNumericValue(CONCURRENT_MAX_THREAD_NUM_KEY, maxThreadNum);
            sshJudge = SYS_BUNDLE.getString(SSH_END_STR);
            debugModel = "debug".equalsIgnoreCase(SYS_BUNDLE.getString(TOOL_MODEL_KEY));
            maxNodeNum = ToolConfig.initNumericValue(MAX_DEV_NUM_KEY, maxNodeNum);
            maxDeployFileSize = ToolConfig.initNumericValue(MAX_DEPLOY_FILE_SIZE_KEY, maxDeployFileSize);
            bmcDefaultIp = SYS_BUNDLE.getString(BMC_DEFAULT_IP_KEY);
            vlanNameVerifyReg = SYS_BUNDLE.getString(VLAN_NAME_VERIFY_REG);
            vlanNameMaxLen = ToolConfig.initNumericValue(VLAN_NAME_MAX_LEN, vlanNameMaxLen);
            ToolConfig.initDefaultIp();
        }
        catch (Exception e) {
            log.error("init tool config error, use default value.", (Throwable)e);
        }
        log.info("Init attr {}", (Object)ToolConfig.printAttr());
    }
}

