/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.entity.SsdpResult;
import com.huawei.ism.tool.distributeddeploy.entity.User;
import com.huawei.ism.tool.distributeddeploy.entity.VersionKeyEnum;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.ism.tool.distributeddeploy.logic.config.PlatformStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.Task;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.IDeployTaskInitService;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployNode
implements Comparable<DeployNode> {
    protected DeployTask deployTask;
    private String devType;
    private User bmcUser;
    private User osUser;
    private User osRootUser;
    private IpAddress ipAddress;
    private IpAddress ipAddressDS;
    private String sn;
    private String nodeName;
    private String clusterName;
    private String frontIp;
    private String backIp;
    private String cabinetId;
    private String subrackId;
    private String slotId;
    private List<ConfigStrategy> osNetworkStrategys = new ArrayList<ConfigStrategy>();
    private String nowBmcIp = ToolConfig.getBmcDefaultIpByType(this.devType, this.slotId);
    private Status indicatorStatus = Status.CONFIRMING;
    private String parentId;
    private boolean isNeedDeploy = true;
    private IDeployTaskInitService initDeployTaskService;
    private Object configParam;
    private String osIp;
    private String cpuArchitecture;
    private Object server;
    private SsdpResult ssdpMatchResult = new SsdpResult();
    private final Map<String, String> versionMaps = new HashMap<String, String>();

    public void putResult(String key, String value) {
        String matchKey = VersionKeyEnum.findMatchKey(key);
        if (ResultStatus.NOT_PASS.getKey().equals(value)) {
            this.versionMaps.put(String.join((CharSequence)"_", matchKey, VersionKeyEnum.RESULT_KEY.getKey()), value);
        } else {
            this.versionMaps.put(String.join((CharSequence)"_", matchKey, VersionKeyEnum.RESULT_KEY.getKey()), ResultStatus.PASS.getKey());
        }
    }

    public void putVersion(String key, String value) {
        String matchKey = VersionKeyEnum.findMatchKey(key);
        this.versionMaps.put(String.join((CharSequence)"_", matchKey, VersionKeyEnum.VERSION_KEY.getKey()), !StringUtils.isNULLStr(value) ? value : ResultStatus.NOT_SUPPORT.getKey());
    }

    public String getVersionFromMap(String key) {
        return this.versionMaps.get(String.join((CharSequence)"_", key, VersionKeyEnum.VERSION_KEY.getKey()));
    }

    public boolean getResultFromMap(String key) {
        String result = this.versionMaps.get(String.join((CharSequence)"_", key, VersionKeyEnum.RESULT_KEY.getKey()));
        return !ResultStatus.NOT_PASS.getKey().equals(result);
    }

    public void addOsNetworkStrategy(ConfigStrategy osNetworkStrategy) {
        this.osNetworkStrategys.add(osNetworkStrategy);
    }

    public DeployNode(IDeployTaskInitService initDeployTaskService) {
        this.initDeployTaskService = initDeployTaskService;
        this.initDeployTask();
    }

    public DeployNode(IDeployTaskInitService initDeployTaskService, Card.CardScene scene) {
        this.initDeployTaskService = initDeployTaskService;
        this.deployTask = this.initDeployTaskService.initDeployTask(this, scene);
    }

    public String getMask() {
        return this.ipAddress.getNetMaskOrPrefix();
    }

    public String getGateway() {
        return this.ipAddress.getGateway();
    }

    public boolean canRedeploy() {
        return this.deployTask.isAbnormal();
    }

    public boolean canDeploy() {
        return this.deployTask.isFinish();
    }

    public String getIp() {
        return this.ipAddress.getIp();
    }

    public String getId() {
        return this.getIp();
    }

    public void retryDeployInit() {
        this.deployTask.retry();
    }

    public void retryDeployAll() {
        this.deployTask.retryAll();
    }

    private void initDeployTask() {
        this.deployTask = this.initDeployTaskService.initDeployTask(this, Context.INS.getCurrentScene());
    }

    public void initDeployTask(List<String> subTaskIds, IUIObserver obs) {
        this.deployTask.init();
        this.deployTask.setDeployHelperServerObserver(obs);
        this.deployTask.setFitSteps(subTaskIds);
        this.deployTask.getSubTasks().forEach(stepTask -> stepTask.initStepTask(obs));
        this.deployTask.updateUI();
    }

    public void initDeployTask(List<String> subTaskIds, IUIObserver obs, Map<String, Map<String, PlatformStrategy>> strategy) {
        this.initDeployTask(subTaskIds, obs);
        this.deployTask.setStrategyMap(strategy);
    }

    public void startInit() {
        Context.INS.getUIObs().addRunningDevNum();
        if (this.deployTask.isFinish()) {
            this.initDeployTask();
            Context.INS.getUIObs().initDevUIData(Collections.singletonList(this));
            if (this.equals(Context.INS.getCurrentSelectNode())) {
                Context.INS.getUIObs().updateWhenDevChange();
            }
        }
    }

    @Override
    public int compareTo(DeployNode otherNode) {
        return this.getIp().compareTo(otherNode.getIp());
    }

    public String toString() {
        return this.getIp();
    }

    public String getHtmlIndex() {
        return this.getIp() + " " + (this.sn == null ? "" : this.sn);
    }

    public String getIpPath() {
        return this.getIp().replace(":", "_");
    }

    public String getHtmlStatus() {
        if (this.deployTask.isNormal()) {
            return "finished";
        }
        return "notFinished";
    }

    public Status getStatus() {
        return this.deployTask.getStatus();
    }

    public List<ItemTask> getAllItemTasks() {
        ArrayList<ItemTask> itemTasks = new ArrayList<ItemTask>();
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            this.deployTask.getAllSubTasks().stream().filter(Task::isAlreadyStarted).forEachOrdered(stepTask -> stepTask.getSubTasks().stream().forEachOrdered(itemTask -> itemTasks.add((ItemTask)itemTask)));
        } else {
            this.deployTask.getAllSubTasks().stream().forEachOrdered(stepTask -> stepTask.getSubTasks().stream().forEachOrdered(itemTask -> itemTasks.add((ItemTask)itemTask)));
        }
        return itemTasks;
    }

    public void setUserInfo(Map<String, Attribute> nodeData) {
        this.setOsUser(new User(nodeData.get("osUserName").getValue(), nodeData.get("osUserOriginPassword").getValue(), nodeData.get("osUserNewPassword").getValue()));
        this.setOsRootUser(new User("root", nodeData.get("rootUserOriginPassword").getValue(), nodeData.get("rootUserNewPassword").getValue()));
        this.setBmcUser(new User(nodeData.get("bmcUserName").getValue(), nodeData.get("bmcUserOriginPassword").getValue(), nodeData.get("bmcUserNewPassword").getValue()));
    }

    public void setUserInfoForAddServer(Map<String, Attribute> nodeData) {
        this.setOsUser(new User(nodeData.get("osUserName").getValue(), nodeData.get("osUserOriginPassword").getValue(), ""));
        this.setOsRootUser(new User("root", nodeData.get("rootUserOriginPassword").getValue(), ""));
        this.setBmcUser(new User(nodeData.get("bmcUserName").getValue(), nodeData.get("bmcUserOriginPassword").getValue(), ""));
    }

    public DevNode createDevNodeInfo() {
        DevNode devNode = new DevNode();
        devNode.setIp(this.getIp());
        devNode.setDeviceSerialNumber(this.getSn());
        devNode.setDeviceType(DeviceType.ALL);
        com.huawei.ism.tool.obase.entity.User loginUser = new com.huawei.ism.tool.obase.entity.User(this.getBmcUser().getUserName(), this.getBmcUser().getOriginPassword());
        devNode.setLoginUser(loginUser);
        return devNode;
    }

    public void updateDeployTask(IDeployTaskInitService taskInitService) {
        this.initDeployTaskService = taskInitService;
        this.initDeployTask();
    }

    public DeployTask getDeployTask() {
        return this.deployTask;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public String getDevType() {
        return this.devType;
    }

    public void setBmcUser(User bmcUser) {
        this.bmcUser = bmcUser;
    }

    public User getBmcUser() {
        return this.bmcUser;
    }

    public void setOsUser(User osUser) {
        this.osUser = osUser;
    }

    public User getOsUser() {
        return this.osUser;
    }

    public void setOsRootUser(User osRootUser) {
        this.osRootUser = osRootUser;
    }

    public User getOsRootUser() {
        return this.osRootUser;
    }

    public void setIpAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public IpAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddressDS(IpAddress ipAddressDS) {
        this.ipAddressDS = ipAddressDS;
    }

    public IpAddress getIpAddressDS() {
        return this.ipAddressDS;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getSn() {
        return this.sn;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setFrontIp(String frontIp) {
        this.frontIp = frontIp;
    }

    public String getFrontIp() {
        return this.frontIp;
    }

    public void setBackIp(String backIp) {
        this.backIp = backIp;
    }

    public String getBackIp() {
        return this.backIp;
    }

    public void setCabinetId(String cabinetId) {
        this.cabinetId = cabinetId;
    }

    public String getCabinetId() {
        return this.cabinetId;
    }

    public void setSubrackId(String subrackId) {
        this.subrackId = subrackId;
    }

    public String getSubrackId() {
        return this.subrackId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public void setOsNetworkStrategys(List<ConfigStrategy> osNetworkStrategys) {
        this.osNetworkStrategys = osNetworkStrategys;
    }

    public List<ConfigStrategy> getOsNetworkStrategys() {
        return this.osNetworkStrategys;
    }

    public void setNowBmcIp(String nowBmcIp) {
        this.nowBmcIp = nowBmcIp;
    }

    public String getNowBmcIp() {
        return this.nowBmcIp;
    }

    public Status getIndicatorStatus() {
        return this.indicatorStatus;
    }

    public void setIndicatorStatus(Status indicatorStatus) {
        this.indicatorStatus = indicatorStatus;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setNeedDeploy(boolean isNeedDeploy) {
        this.isNeedDeploy = isNeedDeploy;
    }

    public boolean isNeedDeploy() {
        return this.isNeedDeploy;
    }

    public Object getConfigParam() {
        return this.configParam;
    }

    public void setConfigParam(Object configParam) {
        this.configParam = configParam;
    }

    public String getOsIp() {
        return this.osIp;
    }

    public void setOsIp(String osIp) {
        this.osIp = osIp;
    }

    public void setCpuArchitecture(String cpuArchitecture) {
        this.cpuArchitecture = cpuArchitecture;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public void setServer(Object server) {
        this.server = server;
    }

    public Object getServer() {
        return this.server;
    }

    public SsdpResult getSsdpMatchResult() {
        return this.ssdpMatchResult;
    }

    public void setSsdpMatchResult(SsdpResult ssdpMatchResult) {
        this.ssdpMatchResult = ssdpMatchResult;
    }
}

