/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.entity;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import java.io.File;

public class ItemInfo {
    private StepInfo.Item item;
    private Type type;

    public String getId() {
        return this.item.id;
    }

    public String getName() {
        return Context.INS.getTaskResString(this.item.id + ".name");
    }

    public boolean isCheckItem() {
        return this.item.id.startsWith("check");
    }

    public String getScriptPath() {
        return Constants.PYTHON_BUSINESS_SCRIPT_DIR + File.separator + this.item.id + ".py";
    }

    public boolean isFailedContinue() {
        if (Context.INS.getCurrentScene() == Card.CardScene.MATCH_CHECK && !this.canJudgeInvolveAfter()) {
            return true;
        }
        return this.item.failedContinue;
    }

    public boolean isInvolve(String involveKey) {
        return this.item.involves.isEmpty() || this.item.involves.contains(involveKey);
    }

    public boolean canJudgeInvolveAfter() {
        return this.item.canJudgeInvolveAfter;
    }

    public int getFailedRetryTimes() {
        return this.item.failedRetryTimes;
    }

    public ItemInfo(StepInfo.Item item, Type type) {
        this.item = item;
        this.type = type;
    }

    public StepInfo.Item getItem() {
        return this.item;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        SINGLE,
        MULTI;

    }
}

