/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.entity;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.stream.Collectors;

public class StepInfo {
    String id;
    List<Item> items;

    public String getName() {
        return Context.INS.getTaskResString(this.id);
    }

    public boolean needShowStep(String sceneId) {
        return this.items.stream().anyMatch(item -> item.supportScene.contains(sceneId));
    }

    public List<Item> getItemsByScene(String sceneId) {
        if (StringUtils.isNULLStr((String)sceneId)) {
            return this.items;
        }
        return this.items.stream().filter(item -> item.getSupportScene().contains(sceneId)).collect(Collectors.toList());
    }

    public StepInfo(String id, List<Item> items) {
        this.id = id;
        this.items = items;
    }

    public String getId() {
        return this.id;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public static class Item {
        String id;
        boolean failedContinue;
        List<String> involves;
        boolean canJudgeInvolveAfter;
        int failedRetryTimes;
        String supportScene;
        boolean canRetry;
        boolean canIgnore;
        boolean isCheckSupportAlone;

        public String getId() {
            return this.id;
        }

        public boolean isFailedContinue() {
            return this.failedContinue;
        }

        public List<String> getInvolves() {
            return this.involves;
        }

        public boolean isCanJudgeInvolveAfter() {
            return this.canJudgeInvolveAfter;
        }

        public int getFailedRetryTimes() {
            return this.failedRetryTimes;
        }

        public String getSupportScene() {
            return this.supportScene;
        }

        public boolean isCanRetry() {
            return this.canRetry;
        }

        public boolean isCanIgnore() {
            return this.canIgnore;
        }

        public boolean isCheckSupportAlone() {
            return this.isCheckSupportAlone;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setFailedContinue(boolean failedContinue) {
            this.failedContinue = failedContinue;
        }

        public void setInvolves(List<String> involves) {
            this.involves = involves;
        }

        public void setCanJudgeInvolveAfter(boolean canJudgeInvolveAfter) {
            this.canJudgeInvolveAfter = canJudgeInvolveAfter;
        }

        public void setFailedRetryTimes(int failedRetryTimes) {
            this.failedRetryTimes = failedRetryTimes;
        }

        public void setSupportScene(String supportScene) {
            this.supportScene = supportScene;
        }

        public void setCanRetry(boolean canRetry) {
            this.canRetry = canRetry;
        }

        public void setCanIgnore(boolean canIgnore) {
            this.canIgnore = canIgnore;
        }

        public void setCheckSupportAlone(boolean isCheckSupportAlone) {
            this.isCheckSupportAlone = isCheckSupportAlone;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFailedContinue() != other.isFailedContinue()) {
                return false;
            }
            if (this.isCanJudgeInvolveAfter() != other.isCanJudgeInvolveAfter()) {
                return false;
            }
            if (this.getFailedRetryTimes() != other.getFailedRetryTimes()) {
                return false;
            }
            if (this.isCanRetry() != other.isCanRetry()) {
                return false;
            }
            if (this.isCanIgnore() != other.isCanIgnore()) {
                return false;
            }
            if (this.isCheckSupportAlone() != other.isCheckSupportAlone()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            List<String> this$involves = this.getInvolves();
            List<String> other$involves = other.getInvolves();
            if (this$involves == null ? other$involves != null : !((Object)this$involves).equals(other$involves)) {
                return false;
            }
            String this$supportScene = this.getSupportScene();
            String other$supportScene = other.getSupportScene();
            return !(this$supportScene == null ? other$supportScene != null : !this$supportScene.equals(other$supportScene));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFailedContinue() ? 79 : 97);
            result = result * 59 + (this.isCanJudgeInvolveAfter() ? 79 : 97);
            result = result * 59 + this.getFailedRetryTimes();
            result = result * 59 + (this.isCanRetry() ? 79 : 97);
            result = result * 59 + (this.isCanIgnore() ? 79 : 97);
            result = result * 59 + (this.isCheckSupportAlone() ? 79 : 97);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            List<String> $involves = this.getInvolves();
            result = result * 59 + ($involves == null ? 43 : ((Object)$involves).hashCode());
            String $supportScene = this.getSupportScene();
            result = result * 59 + ($supportScene == null ? 43 : $supportScene.hashCode());
            return result;
        }

        public String toString() {
            return "StepInfo.Item(id=" + this.getId() + ", failedContinue=" + this.isFailedContinue() + ", involves=" + this.getInvolves() + ", canJudgeInvolveAfter=" + this.isCanJudgeInvolveAfter() + ", failedRetryTimes=" + this.getFailedRetryTimes() + ", supportScene=" + this.getSupportScene() + ", canRetry=" + this.isCanRetry() + ", canIgnore=" + this.isCanIgnore() + ", isCheckSupportAlone=" + this.isCheckSupportAlone() + ")";
        }
    }
}

