/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.runtime.PluginActivator;
import com.huawei.ism.tool.distributeddeploy.common.UserOperationDataContext;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.operation.DeployUserOperationData;
import com.huawei.ism.tool.distributeddeploy.service.report.ReportBuilder;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.sdk.unified.log.UnifiedLogConfigurator;
import com.huawei.ism.tool.sdk.unified.log.exception.UnifiedLogException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class PluginActivatorImpl
implements PluginActivator {
    private static final Logger log = LoggerFactory.getLogger(PluginActivatorImpl.class);
    private static final String PLUGIN_ID = "DistributeDeployHelper";
    @Fit
    PluginManager manager;

    public void start() {
        try {
            UnifiedLogConfigurator.initializeWithDefaultConfig();
        }
        catch (UnifiedLogException exception) {
            log.error("initialize unified log config failed", (Throwable)exception);
        }
        Optional opt = this.manager.get(PLUGIN_ID);
        if (!opt.isPresent()) {
            throw new FitException("can not find plugin DistributeDeployHelper");
        }
        File file = ((Plugin)opt.get()).getBaseDirectory();
        try {
            FrameworkInitiator.init(file.getCanonicalPath());
            LanguageManager.getInstance().setCurrentLanguage(PluginActivatorImpl.getLan(System.getenv("language")));
        }
        catch (IOException e) {
            throw new FitException("DistributeDeployHelper init failed.", (Throwable)e);
        }
        ObserverManager.getInstance().setDeployHelperServerScene(true);
    }

    private static Locale getLan(String language) {
        Locale lan = Locale.ENGLISH;
        if (!StringUtils.isNULLStr((String)language) && language.startsWith("zh")) {
            lan = Locale.SIMPLIFIED_CHINESE;
        }
        return lan;
    }

    public void stop() {
        log.info("Exit plugin {}", (Object)PLUGIN_ID);
        FileUtils.clearDir((String)ReportBuilder.REPORT_TEMP);
        FileUtils.clearDir((String)(ApplicationContext.getInstance().getTmpPath() + File.separator + "ISO"));
        List<DeployUserOperationData> opData = UserOperationDataContext.getInstance().getDeployUserOperationDatas();
        if (CollectionUtil.isEmpty(opData)) {
            return;
        }
        UserOpDataSaveUtil.batchSaveUserOpdata(opData);
    }
}

