/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.common;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class ExpansionManager {
    private static final Logger log = LoggerFactory.getLogger(ExpansionManager.class);
    private Map<String, List<ExpansionConfig>> expansionInformation = new ConcurrentHashMap<String, List<ExpansionConfig>>();
    private Map<String, ResultStatus> expansionVersion = new ConcurrentHashMap<String, ResultStatus>();

    public void refreshExpansionByDevId(String devId, List<ExpansionConfig> expansionConfigs) {
        if (this.expansionInformation.containsKey(devId)) {
            log.info("Clear and coverage old expansions information, devId  [{}]", (Object)devId);
        }
        this.expansionInformation.put(devId, new ArrayList<ExpansionConfig>(expansionConfigs));
    }

    public List<ExpansionConfig> queryExpansionByDevId(String devId) {
        return this.expansionInformation.getOrDefault(devId, Collections.emptyList());
    }

    public boolean hasConfigVersion(String devId) {
        return this.expansionVersion.getOrDefault(devId, ResultStatus.NOT_CONFIGURED) == ResultStatus.CONFIGURED;
    }

    public void updateConfigVersion(String devId) {
        this.expansionVersion.put(devId, ResultStatus.CONFIGURED);
    }
}

