/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.common;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNodeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class NodeManager {
    private static final Logger log = LoggerFactory.getLogger(NodeManager.class);
    private final Map<String, ClusterNodeMap> deployHelperServerNodes = new HashMap<String, ClusterNodeMap>();

    public void refreshNodesByTaskId(String taskId, ClusterNode clusterNode) {
        if (!this.deployHelperServerNodes.containsKey(taskId)) {
            log.info("Clear and coverage old nodes, task id [{}]", (Object)taskId);
        }
        ClusterNodeMap clusterNodeMap = this.deployHelperServerNodes.getOrDefault(taskId, this.initClusterNodeMap());
        clusterNodeMap.addClusterNode(clusterNode);
        this.deployHelperServerNodes.put(taskId, clusterNodeMap);
    }

    private ClusterNodeMap initClusterNodeMap() {
        return ClusterNodeMap.builder().clusterNodeMap(Collections.synchronizedMap(new LinkedHashMap())).build();
    }

    public List<DeployNode> queryNodesByTaskId(String taskId, String clusterId) {
        return this.queryClusterNodes(taskId).stream().filter(clusterNode -> this.isSameCluster((ClusterNode)clusterNode, clusterId)).findFirst().orElseGet(this::buildEmptyNode).getDeployNodes();
    }

    private ClusterNode buildEmptyNode() {
        ClusterNode clusterNode = new ClusterNode();
        clusterNode.setDeployNodes(Collections.emptyList());
        return clusterNode;
    }

    private boolean isSameCluster(ClusterNode clusterNode, String clusterId) {
        return clusterId.equals(clusterNode.getIp()) || clusterId.equals(clusterNode.getId());
    }

    public Optional<ClusterNode> queryClusterNodeById(String taskId, String clusterId) {
        return this.queryClusterNodes(taskId).stream().filter(clusterNode -> this.isSameCluster((ClusterNode)clusterNode, clusterId)).findFirst();
    }

    public List<ClusterNode> queryClusterNodes(String taskId) {
        return this.deployHelperServerNodes.getOrDefault(taskId, this.initClusterNodeMap()).getClusterNodes();
    }

    public List<DeployNode> queryAllRegisteredNodes() {
        return this.deployHelperServerNodes.values().stream().map(ClusterNodeMap::getClusterNodes).flatMap(Collection::stream).map(ClusterNode::getDeployNodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<DeployNode> queryNodesByTaskId(String taskId) {
        return this.queryClusterNodes(taskId).stream().map(ClusterNode::getDeployNodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<DeployNode> querySelectNodes(String taskId, List<String> selectDevs) {
        String[] split = taskId.split("_");
        Optional<ClusterNode> clusterNodeOptional = this.queryClusterNodeById(split[0], split[1]);
        return clusterNodeOptional.map(clusterNode -> clusterNode.getDeployNodes().stream().filter(deployNode -> selectDevs.contains(deployNode.getIp())).filter(DeployNode::isNeedDeploy).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

