/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.common;

import com.huawei.ism.tool.distributeddeploy.fit.common.SceneConstants;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ObserverManager {
    private static ObserverManager instance;
    private boolean isDeployHelperServerScene = false;
    private String currentScene = "full";
    private String templateScene = "Deployment";
    private Map<String, String> deployVersionMap = new ConcurrentHashMap<String, String>();

    private ObserverManager() {
    }

    public static synchronized ObserverManager getInstance() {
        if (instance == null) {
            instance = new ObserverManager();
        }
        return instance;
    }

    public void saveDeployVersion(String clusterId, String deployVersion) {
        this.deployVersionMap.put(clusterId, deployVersion);
    }

    public String getDeployVersion(String clusterId) {
        return this.deployVersionMap.get(clusterId);
    }

    public boolean isExpansionScene() {
        return SceneConstants.CAPACITY_EXPANSION.contains(this.templateScene);
    }

    public void cacheVersionMapping(@NotNull ClusterNode clusterNode, String deployVersion) {
        clusterNode.setMappingVersion(deployVersion);
        this.saveDeployVersion(clusterNode.getIp(), deployVersion);
    }

    public void setDeployHelperServerScene(boolean isDeployHelperServerScene) {
        this.isDeployHelperServerScene = isDeployHelperServerScene;
    }

    public boolean isDeployHelperServerScene() {
        return this.isDeployHelperServerScene;
    }

    public String getCurrentScene() {
        return this.currentScene;
    }

    public void setCurrentScene(String currentScene) {
        this.currentScene = currentScene;
    }

    public void setTemplateScene(String templateScene) {
        this.templateScene = templateScene;
    }
}

