/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.common;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployHelperServerObserver;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class TaskContext {
    private static final Logger log = LoggerFactory.getLogger(TaskContext.class);
    private Map<String, DeployTaskManager> taskManagerMap = new HashMap<String, DeployTaskManager>();
    private final Map<String, List<String>> currentRunNode = new ConcurrentHashMap<String, List<String>>();

    public synchronized DeployTaskManager getDeployTaskManager(String taskId) {
        return this.taskManagerMap.computeIfAbsent(taskId, key -> new DeployTaskManager(new DeployHelperServerObserver(), true));
    }

    public DeployTaskManager queryDeployTaskManager(String taskId) {
        return this.taskManagerMap.get(taskId);
    }

    public boolean nodeStarted(String taskId, DeployNode deployNode) {
        List<String> startedNode = this.currentRunNode.get(taskId);
        return CollectionUtils.isEmpty(startedNode) || startedNode.contains(deployNode.getIp());
    }

    public void cacheCurrentRunNode(String taskId, List<String> devUids) {
        this.currentRunNode.put(taskId, devUids);
    }
}

