/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ItemRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.ism.tool.distributeddeploy.fit.entity.RunningMessage;
import com.huawei.ism.tool.distributeddeploy.fit.entity.StepRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.TaskRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.util.TaskSumUtil;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.operation.DeployUserOperationData;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.yinglong.drop.entity.item.entity.RunningDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.ItemParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployHelperServerObserver
implements IUIObserver {
    private static final Logger log = LoggerFactory.getLogger(DeployHelperServerObserver.class);
    private TaskRunningDetail taskRunningDetail;
    private final AtomicInteger runningDevNum = new AtomicInteger();
    private DeployUserOperationData userOperationData;

    @Override
    public void initDevUIData(String taskId, ClusterNode clusterNode, List<String> devIds) {
        if (this.taskRunningDetail == null) {
            this.taskRunningDetail = TaskRunningDetail.builder().taskId(taskId).runningMessage(RunningMessage.builder().build()).clusterRunningDetailMap(Collections.synchronizedMap(new LinkedHashMap())).build();
        }
        this.taskRunningDetail.addClusterRunningDetail(this.initClusterDetail(clusterNode, false, devIds));
    }

    @Override
    public void resetDevUIData(String taskId, ClusterNode clusterNode) {
        if (this.taskRunningDetail == null) {
            this.taskRunningDetail = TaskRunningDetail.builder().taskId(taskId).runningMessage(RunningMessage.builder().build()).clusterRunningDetailMap(Collections.synchronizedMap(new LinkedHashMap())).build();
        }
        this.taskRunningDetail.addClusterRunningDetail(this.initClusterDetail(clusterNode, true, Collections.emptyList()));
    }

    private ClusterRunningDetail initClusterDetail(ClusterNode clusterNode, boolean isNeedReset, List<String> devIds) {
        ClusterRunningDetail clusterRunningDetail = isNeedReset ? this.initClusterRunningDetail(clusterNode) : this.taskRunningDetail.getClusterRunningDetail(clusterNode.getId()).orElseGet(() -> this.initClusterRunningDetail(clusterNode));
        List<DeployRunningDetail> deployRunningDetails = clusterNode.getNeedDeployNodes().stream().filter(deployNode -> CollectionUtils.isEmpty((Collection)devIds) || devIds.contains(deployNode.getIp())).map(deployNode -> this.initDeployTaskDetail((DeployNode)deployNode, isNeedReset)).collect(Collectors.toList());
        clusterRunningDetail.addDeployRunningDetails(deployRunningDetails);
        return clusterRunningDetail;
    }

    private ClusterRunningDetail initClusterRunningDetail(ClusterNode clusterNode) {
        return ClusterRunningDetail.builder().clusterNode(clusterNode).runningMessage(RunningMessage.builder().build()).deployRunningDetailMap(Collections.synchronizedMap(new LinkedHashMap())).build();
    }

    private DeployRunningDetail initDeployTaskDetail(DeployNode deployNode, boolean isNeedReset) {
        DeployRunningDetail deployRunningDetail = isNeedReset ? this.initDeployRunningDetail(deployNode) : this.taskRunningDetail.getDeployRunningDetailById(deployNode.getParentId(), deployNode.getId()).orElseGet(() -> this.initDeployRunningDetail(deployNode));
        RunningMessage runningMessage = RunningMessage.builder().progress(deployNode.getDeployTask().getProgress()).status(deployNode.getStatus()).build();
        deployRunningDetail.setRunningMessage(runningMessage);
        this.refreshStepDetails(deployNode, deployRunningDetail, isNeedReset);
        return deployRunningDetail;
    }

    private void refreshStepDetails(DeployNode deployNode, DeployRunningDetail deployRunningDetail, boolean isNeedReset) {
        List<StepTask> stepTasks = isNeedReset ? deployNode.getDeployTask().getSubTaskWithBmcConfig() : deployNode.getDeployTask().getSubTasks();
        List<StepRunningDetail> stepRunningDetails = stepTasks.stream().map(this::initStepTaskDetail).collect(Collectors.toList());
        deployRunningDetail.addStepRunningDetails(stepRunningDetails);
    }

    private DeployRunningDetail initDeployRunningDetail(DeployNode deployNode) {
        return DeployRunningDetail.builder().node(deployNode).stepRunningDetailMap(Collections.synchronizedMap(new LinkedHashMap())).build();
    }

    private StepRunningDetail initStepTaskDetail(StepTask stepTask) {
        ArrayList<ItemRunningDetail> itemDetailList = DeployHelperServerObserver.isBmcConfigStep(stepTask) ? stepTask.getSubTasks().stream().map(this::initItemDetail).collect(Collectors.toList()) : new ArrayList<ItemRunningDetail>();
        RunningMessage runningMessage = RunningMessage.builder().progress(stepTask.getProgress()).status(stepTask.getStatus()).build();
        return StepRunningDetail.builder().stepInfo(stepTask.getStepInfo()).runningMessage(runningMessage).itemRunningDetails(itemDetailList).build();
    }

    private static boolean isBmcConfigStep(StepTask stepTask) {
        return Arrays.asList("lit_indicator", "off_indicator", "bmc_ip_config_by_input").contains(stepTask.getStepInfo().getId());
    }

    private ItemRunningDetail initItemDetail(ItemTask itemTask) {
        RunningDetail runningDetail = RunningDetail.builder().progress(Double.valueOf(itemTask.getProgress())).status(ResultStatus.of(itemTask.getStatus().toString(), ResultStatus.NO_CHECK)).build();
        return ItemRunningDetail.builder().itemInfo(itemTask.getItemInfo()).runningDetail(runningDetail).build();
    }

    @Override
    public void resetItemDetail(ItemParams params) {
        String[] split = params.getTaskId().split("_");
        if (!this.taskRunningDetail.getTaskId().equals(split[0])) {
            return;
        }
        this.findDeployRunningDetail(split[1], params.getDevId()).ifPresent(deployRunningDetail -> this.resetItemDetailById((DeployRunningDetail)deployRunningDetail, params.getSubTaskId(), params.getItemId()));
    }

    private void resetItemDetailById(DeployRunningDetail deployRunningDetail, String stepId, String itemId) {
        RunningMessage runningMessage = deployRunningDetail.getRunningMessage();
        runningMessage.setStatus(Status.WAITING_EXEC);
        runningMessage.setEndTime(null);
        this.findStepRunningDetail(deployRunningDetail, stepId).ifPresent(stepRunningDetail -> this.findAndResetItemRunningDetail((StepRunningDetail)stepRunningDetail, itemId));
    }

    private void findAndResetItemRunningDetail(StepRunningDetail stepRunningDetail, String itemId) {
        RunningMessage runningMessage = stepRunningDetail.getRunningMessage();
        runningMessage.setStatus(Status.WAITING_EXEC);
        runningMessage.setEndTime(null);
        stepRunningDetail.getItemRunningDetails().stream().filter(itemRunningDetail -> itemRunningDetail.getItemInfo().getId().equals(itemId)).findFirst().ifPresent(this::resetRunningDetail);
    }

    private void resetRunningDetail(ItemRunningDetail itemRunningDetail) {
        itemRunningDetail.setRunningDetail(RunningDetail.builder().progress(Double.valueOf(0.0)).status(ResultStatus.WAITED.getKey()).build());
    }

    @Override
    public void resetStepDetail(String taskId, String clusterId, String devId, List<String> stepIdList) {
        if (!this.taskRunningDetail.getTaskId().equals(taskId)) {
            return;
        }
        this.findDeployRunningDetail(clusterId, devId).ifPresent(deployRunningDetail -> this.resetAllStepDetails((DeployRunningDetail)deployRunningDetail, stepIdList));
    }

    private void resetAllStepDetails(DeployRunningDetail deployRunningDetail, List<String> stepIdList) {
        RunningMessage runningMessage = deployRunningDetail.getRunningMessage();
        runningMessage.setStatus(Status.WAITING_EXEC);
        runningMessage.setEndTime(null);
        stepIdList.forEach(stepId -> this.resetStepDetailById(deployRunningDetail, (String)stepId));
    }

    private void resetStepDetailById(DeployRunningDetail deployRunningDetail, String stepId) {
        deployRunningDetail.getStepRunningDetails().stream().filter(stepRunningDetail -> stepRunningDetail.getStepInfo().getId().equals(stepId)).forEach(stepRunningDetail -> {
            stepRunningDetail.setRunningMessage(RunningMessage.builder().progress(0).status(Status.WAITING_EXEC).build());
            this.resetAllItemDetailsOfStep((StepRunningDetail)stepRunningDetail);
        });
    }

    private void resetAllItemDetailsOfStep(StepRunningDetail stepRunningDetail) {
        stepRunningDetail.getItemRunningDetails().forEach(this::resetRunningDetail);
    }

    @Override
    public void finish(DeployNode node) {
        this.findDeployRunningDetail(node.getParentId(), node.getIp()).ifPresent(this::setEndTimeWhenFinish);
        if (this.runningDevNum.decrementAndGet() == 0) {
            this.setUserOpData();
            this.finishAll();
        }
    }

    private void setUserOpData() {
        if (Objects.nonNull(this.userOperationData) && this.userOperationData.getTaskEndTime() == 0L) {
            this.userOperationData.setTaskEndTime(System.currentTimeMillis());
        }
    }

    private void setEndTimeWhenFinish(DeployRunningDetail deployRunningDetail) {
        deployRunningDetail.getRunningMessage().setEndTime(TaskSumUtil.getCurrentDate());
        this.setNodeTimeConsumption(deployRunningDetail);
    }

    private void setNodeTimeConsumption(DeployRunningDetail deployRunningDetail) {
        if (Objects.isNull(this.userOperationData)) {
            return;
        }
        String nodeName = deployRunningDetail.getNode().getNodeName();
        if (StringUtils.isNULLStr(nodeName)) {
            nodeName = "Node";
        }
        List consumption = this.userOperationData.getDynamicAttr().getOrDefault("nodeTimeConsumption", new ArrayList());
        consumption.add(String.join((CharSequence)"->", nodeName, this.buildTimeDesc(deployRunningDetail)));
        this.userOperationData.getDynamicAttr().put("nodeTimeConsumption", consumption);
    }

    private String buildTimeDesc(DeployRunningDetail deployRunningDetail) {
        return String.format(Locale.ROOT, "startTime: %s; endTime: %s", deployRunningDetail.getRunningMessage().getStartTime(), deployRunningDetail.getRunningMessage().getEndTime());
    }

    @Override
    public void finishAll() {
        this.taskRunningDetail.getRunningMessage().setEndTime(TaskSumUtil.getCurrentDate());
    }

    @Override
    public void addRunningDevNum() {
        this.runningDevNum.incrementAndGet();
    }

    @Override
    public boolean hasRunningDev() {
        return this.runningDevNum.get() != 0;
    }

    @Override
    public TaskRunningDetail getTaskRunningDetail(String taskId) throws ToolException {
        if (!this.taskRunningDetail.getTaskId().equals(taskId)) {
            throw new ToolException("fit.task.query.detail.not.found");
        }
        return this.taskRunningDetail;
    }

    @Override
    public DeployRunningDetail getDeployNodeRunningDetail(String taskId, String clusterId, String devId) throws ToolException {
        if (!this.taskRunningDetail.getTaskId().equals(taskId)) {
            log.warn("not find task detail by task id {}", (Object)taskId);
            throw new ToolException("fit.task.query.detail.not.found");
        }
        Optional<DeployRunningDetail> optionalDeployRunningDetail = this.taskRunningDetail.getDeployRunningDetailById(clusterId, devId);
        if (!optionalDeployRunningDetail.isPresent()) {
            log.warn("not find deploy node detail by devId {}", (Object)devId);
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{devId});
        }
        return optionalDeployRunningDetail.get();
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable instanceof ItemTask) {
            ItemTask itemTask = (ItemTask)observable;
            this.findDeployRunningDetail(itemTask.getNode().getParentId(), itemTask.getNode().getIp()).ifPresent(deployRunningDetail -> this.setDeployStartAndFindStep((DeployRunningDetail)deployRunningDetail, itemTask));
        } else if (observable instanceof StepTask) {
            StepTask stepTask = (StepTask)observable;
            this.findDeployRunningDetail(stepTask.getNode().getParentId(), stepTask.getNode().getIp()).ifPresent(deployRunningDetail -> this.findAndUpdateStepMessage((DeployRunningDetail)deployRunningDetail, stepTask));
        } else if (observable instanceof DeployTask) {
            DeployTask deployTask = (DeployTask)observable;
            RunningMessage runningMessage = this.taskRunningDetail.getRunningMessage();
            if (StringUtils.isNULLStr(runningMessage.getStartTime())) {
                runningMessage.setStartTime(TaskSumUtil.getCurrentDate());
            }
            String clusterIp = deployTask.getNode().getParentId();
            ClusterRunningDetail clusterRunningDetail = this.taskRunningDetail.getClusterRunningDetail(clusterIp).orElseGet(() -> this.initClusterRunningDetail(new ClusterNode(clusterIp)));
            RunningMessage clusterRunningMessage = clusterRunningDetail.getRunningMessage();
            if (StringUtils.isNULLStr(runningMessage.getStartTime())) {
                clusterRunningMessage.setStartTime(TaskSumUtil.getCurrentDate());
            }
            this.findDeployRunningDetail(clusterIp, deployTask.getNode().getIp()).ifPresent(deployRunningDetail -> this.updateDeployRunningMessage((DeployRunningDetail)deployRunningDetail, deployTask));
            List<RunningMessage> deployRunningMessages = clusterRunningDetail.getDeployRunningDetails().stream().map(DeployRunningDetail::getRunningMessage).collect(Collectors.toList());
            clusterRunningMessage.setProgress(TaskSumUtil.calculateProgress(deployRunningMessages));
            clusterRunningMessage.setStatus(TaskSumUtil.sumTaskStatus(deployRunningMessages));
            if (clusterRunningMessage.getProgress() == 100) {
                clusterRunningMessage.setEndTime(TaskSumUtil.getCurrentDate());
            }
            List<RunningMessage> clusterRunningMessages = this.taskRunningDetail.getClusterRunningDetails().stream().map(ClusterRunningDetail::getRunningMessage).collect(Collectors.toList());
            runningMessage.setProgress(TaskSumUtil.calculateProgress(clusterRunningMessages));
            Status status = TaskSumUtil.sumTaskStatus(clusterRunningMessages);
            if (this.isStepTaskFinish(status)) {
                this.findDeployRunningDetail(deployTask.getNode().getParentId(), deployTask.getNode().getIp()).ifPresent(this::setEndTimeWhenFinish);
            }
            runningMessage.setStatus(status);
        } else {
            log.warn("The observer is not task observer.");
        }
    }

    private boolean isStepTaskFinish(Status status) {
        return Arrays.asList(Status.SUCCESSFUL, Status.PARTIALLY_SUCCEED, Status.FAILED).contains((Object)status);
    }

    private void setDeployStartAndFindStep(DeployRunningDetail deployRunningDetail, ItemTask itemTask) {
        this.findStepRunningDetail(deployRunningDetail, itemTask.getParentTask().getStepInfo().getId()).ifPresent(stepRunningDetail -> this.setStepStartAndFindItem((StepRunningDetail)stepRunningDetail, itemTask));
    }

    private void setStepStartAndFindItem(StepRunningDetail stepRunningDetail, ItemTask itemTask) {
        this.findItemRunningMessage(stepRunningDetail, itemTask).ifPresent(itemRunningDetail -> this.updateItemRunningMessage((ItemRunningDetail)itemRunningDetail, itemTask));
    }

    private Optional<ItemRunningDetail> findItemRunningMessage(StepRunningDetail stepRunningDetail, ItemTask itemTask) {
        if (Status.NOT_INVOLVE.equals((Object)itemTask.getStatus())) {
            return Optional.empty();
        }
        Optional<ItemRunningDetail> itemDetail = stepRunningDetail.getItemRunningDetails().stream().filter(itemRunningDetail -> Objects.equals(itemRunningDetail.getItemInfo().getId(), itemTask.getId())).findFirst();
        if (!itemDetail.isPresent()) {
            ItemRunningDetail itemRunningDetail2 = this.initItemDetail(itemTask);
            stepRunningDetail.getItemRunningDetails().add(itemRunningDetail2);
            itemDetail = Optional.of(itemRunningDetail2);
        }
        return itemDetail;
    }

    private void updateItemRunningMessage(ItemRunningDetail itemRunningDetail, ItemTask itemTask) {
        RunningDetail runningDetail = itemRunningDetail.getRunningDetail();
        runningDetail.setOriginInfo(itemTask.getOriginalInfo());
        runningDetail.setErrorMsg(itemTask.getErrMsg());
        runningDetail.setProgress(Double.valueOf(itemTask.getProgress()));
        runningDetail.setStartTime(itemTask.getStartDate());
        runningDetail.setStatus(ResultStatus.of(itemTask.getStatus().toString(), ResultStatus.NO_CHECK));
        if (itemTask.getProgress() == 100) {
            runningDetail.setEndTime(itemTask.getEndDateStr());
        }
    }

    private void findAndUpdateStepMessage(DeployRunningDetail deployRunningDetail, StepTask stepTask) {
        this.findStepRunningDetail(deployRunningDetail, stepTask.getStepInfo().getId()).ifPresent(stepRunningDetail -> this.updateStepRunningMessage((StepRunningDetail)stepRunningDetail, stepTask));
    }

    private Optional<StepRunningDetail> findStepRunningDetail(DeployRunningDetail deployRunningDetail, String stepId) {
        return Optional.ofNullable(deployRunningDetail.getStepRunningDetailById(stepId));
    }

    private void updateStepRunningMessage(StepRunningDetail stepRunningDetail, StepTask stepTask) {
        RunningMessage stepRunningMessage = stepRunningDetail.getRunningMessage();
        stepRunningMessage.setStatus(stepTask.getStatus());
        stepRunningMessage.setProgress(stepTask.getProgress());
        if (StringUtils.isNULLStr(stepRunningDetail.getRunningMessage().getStartTime())) {
            stepRunningDetail.getRunningMessage().setStartTime(TaskSumUtil.getCurrentDate());
        }
        if (TaskSumUtil.isStepTaskFinish(stepTask.getStatus())) {
            stepRunningMessage.setEndTime(TaskSumUtil.getCurrentDate());
            stepTask.getNotInvolveSubTasks().forEach(itemTask -> this.updateInvolveItemMessage(stepRunningDetail, (ItemTask)itemTask));
        }
    }

    private void updateInvolveItemMessage(StepRunningDetail stepRunningDetail, ItemTask itemTask) {
        this.findItemRunningMessage(stepRunningDetail, itemTask).ifPresent(itemRunningDetail -> {
            RunningDetail runningDetail = itemRunningDetail.getRunningDetail();
            runningDetail.setStatus(ResultStatus.of(Status.NOT_INVOLVE.toString(), ResultStatus.NOT_SUPPORT));
            runningDetail.setProgress(Double.valueOf(itemTask.getProgress()));
            runningDetail.setErrorMsg(Status.NOT_INVOLVE.getDesc());
        });
    }

    private Optional<DeployRunningDetail> findDeployRunningDetail(String clusterId, String devId) {
        return this.taskRunningDetail.getDeployRunningDetailById(clusterId, devId);
    }

    private void updateDeployRunningMessage(DeployRunningDetail deployRunningDetail, DeployTask deployTask) {
        RunningMessage deployRunningMessage = deployRunningDetail.getRunningMessage();
        deployRunningMessage.setProgress(deployTask.getProgress());
        deployRunningMessage.setStatus(deployTask.getStatus());
        if (StringUtils.isNULLStr(deployRunningDetail.getRunningMessage().getStartTime())) {
            deployRunningDetail.getRunningMessage().setStartTime(TaskSumUtil.getCurrentDate());
        }
        if (TaskSumUtil.isStepTaskFinish(deployTask.getStatus())) {
            deployRunningMessage.setEndTime(TaskSumUtil.getCurrentDate());
        }
    }

    @Override
    public void setUserOpData(DeployUserOperationData opData) {
        this.userOperationData = opData;
    }

    public TaskRunningDetail getTaskRunningDetail() {
        return this.taskRunningDetail;
    }
}

