/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.entity;

import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ResultStatus {
    WAITED("waited"),
    RUNNING("running"),
    SUCCESS("success"),
    PART_SUCCESS("part_success"),
    FAILED("failed"),
    INFO("info"),
    IGNORED("ignored"),
    PAUSE("pause"),
    PASS("pass"),
    NOT_PASS("not_pass"),
    NOT_SUPPORT("not_support"),
    NO_CHECK("no_check"),
    WARING("warning"),
    MANUAL_CONFIRM("manual_confirm"),
    CONFIGURED("configured"),
    NOT_CONFIGURED("not_configured"),
    CONFIRM_TRUE("confirm_true"),
    CONFIRM_FALSE("confirm_false");

    private static final EnumSet<ResultStatus> FINISHED_STATUS;
    private static final EnumSet<ResultStatus> RUNNING_STATUS;
    private static final Map<String, ResultStatus> STATUS_COVER;
    private static final Map<String, Status> DEPLOY_STATUS_MAP;
    private final String key;

    private ResultStatus(String status) {
        this.key = status;
    }

    public static String of(String statusKey, ResultStatus defaultStatus) {
        return STATUS_COVER.getOrDefault(statusKey, defaultStatus).getKey();
    }

    public static boolean isAllowedStatus(String statusStr) {
        return DEPLOY_STATUS_MAP.keySet().contains(statusStr);
    }

    public static Status transferToStatus(String statusStr) throws ToolException {
        if (!ResultStatus.isAllowedStatus(statusStr)) {
            throw new ToolException("fit.modify.item.check.status.not.define", (Object[])new String[]{statusStr});
        }
        return DEPLOY_STATUS_MAP.get(statusStr);
    }

    public boolean isFinished() {
        return FINISHED_STATUS.contains((Object)this);
    }

    public boolean isRunning() {
        return RUNNING_STATUS.contains((Object)this);
    }

    public String getKey() {
        return this.key;
    }

    static {
        FINISHED_STATUS = EnumSet.of(SUCCESS, new ResultStatus[]{FAILED, INFO, PASS, NOT_PASS, NOT_SUPPORT, NO_CHECK, WARING, MANUAL_CONFIRM, PART_SUCCESS});
        RUNNING_STATUS = EnumSet.of(RUNNING);
        ConcurrentHashMap<String, ResultStatus> temp = new ConcurrentHashMap<String, ResultStatus>();
        temp.put(Status.WAITING.toString(), WAITED);
        temp.put(Status.WAITING_EXEC.toString(), WAITED);
        temp.put(Status.PASS.toString(), PASS);
        temp.put(Status.NOT_PASS.toString(), NOT_PASS);
        temp.put(Status.NOT_INVOLVE.toString(), NOT_SUPPORT);
        temp.put(Status.IGNORED.toString(), IGNORED);
        temp.put(Status.NO_CHECK.toString(), NO_CHECK);
        temp.put(Status.ITEM_RUNNING.toString(), RUNNING);
        temp.put(Status.TASK_RUNNING.toString(), RUNNING);
        temp.put(Status.PAUSE.toString(), FAILED);
        temp.put(Status.SUCCESSFUL.toString(), SUCCESS);
        temp.put(Status.FAILED.toString(), FAILED);
        temp.put(Status.CONFIRMING.toString(), MANUAL_CONFIRM);
        temp.put(Status.CONFIRM_TRUE.toString(), CONFIRM_TRUE);
        temp.put(Status.CONFIRM_FALSE.toString(), CONFIRM_FALSE);
        temp.put(Status.UNACKNOWLEDGED.toString(), MANUAL_CONFIRM);
        temp.put(Status.LIGHTING_LIT_ERROR.toString(), FAILED);
        temp.put(Status.PARTIALLY_SUCCEED.toString(), PART_SUCCESS);
        temp.put(Status.PAUSE.toString(), PAUSE);
        STATUS_COVER = Collections.unmodifiableMap(temp);
        ConcurrentHashMap<String, Status> deployTemp = new ConcurrentHashMap<String, Status>();
        deployTemp.put(CONFIRM_TRUE.getKey(), Status.CONFIRM_TRUE);
        deployTemp.put(CONFIRM_FALSE.getKey(), Status.CONFIRM_FALSE);
        deployTemp.put(FAILED.getKey(), Status.FAILED);
        deployTemp.put(SUCCESS.getKey(), Status.SUCCESSFUL);
        deployTemp.put(PASS.getKey(), Status.PASS);
        deployTemp.put(NOT_PASS.getKey(), Status.NOT_PASS);
        deployTemp.put(IGNORED.getKey(), Status.IGNORED);
        DEPLOY_STATUS_MAP = Collections.unmodifiableMap(deployTemp);
    }
}

