/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.entity;

import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.RunningMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TaskRunningDetail {
    private String taskId;
    private RunningMessage runningMessage;
    private Map<String, ClusterRunningDetail> clusterRunningDetailMap;

    public void addClusterRunningDetail(ClusterRunningDetail clusterRunningDetail) {
        if ("default".equals(clusterRunningDetail.getClusterNode().getId())) {
            this.clusterRunningDetailMap.clear();
        } else {
            this.clusterRunningDetailMap.remove("default");
        }
        this.clusterRunningDetailMap.put(clusterRunningDetail.getClusterNode().getId(), clusterRunningDetail);
    }

    public List<DeployRunningDetail> getDeployRunningDetails() {
        return this.clusterRunningDetailMap.values().stream().map(ClusterRunningDetail::getDeployRunningDetails).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<DeployRunningDetail> getDeployRunningDetailById(String clusterId, String devId) {
        Optional<ClusterRunningDetail> clusterRunningDetailOptional = this.getClusterRunningDetail(clusterId);
        return clusterRunningDetailOptional.map(clusterRunningDetail -> clusterRunningDetail.getDeployRunningDetailById(devId));
    }

    public Optional<ClusterRunningDetail> getClusterRunningDetail(String clusterId) {
        return this.getClusterRunningDetails().stream().filter(clusterRunningDetail -> this.isSameCluster((ClusterRunningDetail)clusterRunningDetail, clusterId)).findFirst();
    }

    private boolean isSameCluster(ClusterRunningDetail clusterRunningDetail, String clusterId) {
        return clusterRunningDetail.getClusterNode().getIp().equals(clusterId) || clusterRunningDetail.getClusterNode().getId().equals(clusterId);
    }

    public List<ClusterRunningDetail> getClusterRunningDetails() {
        return this.clusterRunningDetailMap.values().stream().collect(Collectors.toList());
    }

    TaskRunningDetail(String taskId, RunningMessage runningMessage, Map<String, ClusterRunningDetail> clusterRunningDetailMap) {
        this.taskId = taskId;
        this.runningMessage = runningMessage;
        this.clusterRunningDetailMap = clusterRunningDetailMap;
    }

    public static TaskRunningDetailBuilder builder() {
        return new TaskRunningDetailBuilder();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public RunningMessage getRunningMessage() {
        return this.runningMessage;
    }

    public Map<String, ClusterRunningDetail> getClusterRunningDetailMap() {
        return this.clusterRunningDetailMap;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setRunningMessage(RunningMessage runningMessage) {
        this.runningMessage = runningMessage;
    }

    public void setClusterRunningDetailMap(Map<String, ClusterRunningDetail> clusterRunningDetailMap) {
        this.clusterRunningDetailMap = clusterRunningDetailMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRunningDetail)) {
            return false;
        }
        TaskRunningDetail other = (TaskRunningDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        RunningMessage this$runningMessage = this.getRunningMessage();
        RunningMessage other$runningMessage = other.getRunningMessage();
        if (this$runningMessage == null ? other$runningMessage != null : !((Object)this$runningMessage).equals(other$runningMessage)) {
            return false;
        }
        Map<String, ClusterRunningDetail> this$clusterRunningDetailMap = this.getClusterRunningDetailMap();
        Map<String, ClusterRunningDetail> other$clusterRunningDetailMap = other.getClusterRunningDetailMap();
        return !(this$clusterRunningDetailMap == null ? other$clusterRunningDetailMap != null : !((Object)this$clusterRunningDetailMap).equals(other$clusterRunningDetailMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskRunningDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        RunningMessage $runningMessage = this.getRunningMessage();
        result = result * 59 + ($runningMessage == null ? 43 : ((Object)$runningMessage).hashCode());
        Map<String, ClusterRunningDetail> $clusterRunningDetailMap = this.getClusterRunningDetailMap();
        result = result * 59 + ($clusterRunningDetailMap == null ? 43 : ((Object)$clusterRunningDetailMap).hashCode());
        return result;
    }

    public String toString() {
        return "TaskRunningDetail(taskId=" + this.getTaskId() + ", runningMessage=" + this.getRunningMessage() + ", clusterRunningDetailMap=" + this.getClusterRunningDetailMap() + ")";
    }

    public static class TaskRunningDetailBuilder {
        private String taskId;
        private RunningMessage runningMessage;
        private Map<String, ClusterRunningDetail> clusterRunningDetailMap;

        TaskRunningDetailBuilder() {
        }

        public TaskRunningDetailBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskRunningDetailBuilder runningMessage(RunningMessage runningMessage) {
            this.runningMessage = runningMessage;
            return this;
        }

        public TaskRunningDetailBuilder clusterRunningDetailMap(Map<String, ClusterRunningDetail> clusterRunningDetailMap) {
            this.clusterRunningDetailMap = clusterRunningDetailMap;
            return this;
        }

        public TaskRunningDetail build() {
            return new TaskRunningDetail(this.taskId, this.runningMessage, this.clusterRunningDetailMap);
        }

        public String toString() {
            return "TaskRunningDetail.TaskRunningDetailBuilder(taskId=" + this.taskId + ", runningMessage=" + this.runningMessage + ", clusterRunningDetailMap=" + this.clusterRunningDetailMap + ")";
        }
    }
}

