/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.factory;

import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.factory.FullSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.AddServerStrategyTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AddServerDriverSceneParser
extends FullSceneParser {
    @Override
    public ClusterNode buildDevNode(@NotNull Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        if (fileDatas.containsKey("storageNode")) {
            ClusterNode clusterNode = super.buildDevNode(fileDatas);
            CollectionUtils.emptyIfNull(clusterNode.getDeployNodes()).stream().filter(deployNode -> StringUtils.isEmpty((CharSequence)deployNode.getOsIp())).forEach(this::updateOsIp);
            return clusterNode;
        }
        if (fileDatas.containsKey("serverNode")) {
            List deployNodes = (List)new AddServerStrategyTask(fileDatas.get("serverNode")).run();
            ClusterNode clusterNode = new ClusterNode();
            deployNodes.forEach(deployNode -> deployNode.setParentId("default"));
            clusterNode.setIp("default");
            clusterNode.setId("default");
            clusterNode.setDeployNodes(deployNodes);
            return clusterNode;
        }
        return ParseLldUtil.parseClusterInfo(fileDatas, Collections.emptyList());
    }

    private void updateOsIp(DeployNode deployNode) {
        CollectionUtils.emptyIfNull(deployNode.getOsNetworkStrategys()).stream().filter(strategy -> strategy.containsIpv4() || strategy.containsIpv6()).sorted(Comparator.comparing(ConfigStrategy::getPlane)).flatMap(configStrategy -> Stream.of(configStrategy.getIpv4Address(), configStrategy.getIpv6Address())).filter(Objects::nonNull).findFirst().ifPresent(address -> deployNode.setOsIp(address.getIp()));
    }
}

