/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.factory;

import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParser;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.BmcIpDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.DirectPlaneNodesStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.SimplifyBmcIpConfigStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.FitDeployTaskInitService;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.FitDirectPlaneDeployTaskInitService;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BmcIpSceneParser
extends LldParser {
    @Override
    public ClusterNode buildDevNode(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        if (fileDatas.containsKey("bmcIpConfig")) {
            return this.simplifyBuildDevNode(fileDatas);
        }
        List deployNodes = (List)new BmcIpDeploySceneDevsStrategyTask(ParseLldUtil.integrateNodes(fileDatas), fileDatas.get(ObserverManager.getInstance().isExpansionScene() ? "addNodeDS" : "storageNodeDS")).run();
        deployNodes.forEach(deployNode -> deployNode.updateDeployTask(new FitDeployTaskInitService()));
        if (fileDatas.containsKey("directPlane")) {
            List directNodes = (List)new DirectPlaneNodesStrategyTask(fileDatas.get("directPlane"), fileDatas.getOrDefault("directPlaneDS", Collections.emptyList())).run();
            directNodes.forEach(node -> node.updateDeployTask(new FitDirectPlaneDeployTaskInitService()));
            deployNodes.addAll(directNodes);
        }
        return ParseLldUtil.parseClusterInfo(fileDatas, deployNodes);
    }

    private ClusterNode simplifyBuildDevNode(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        List deployNodes = (List)new SimplifyBmcIpConfigStrategyTask(fileDatas.get("bmcIpConfig")).run();
        deployNodes.forEach(deployNode -> deployNode.updateDeployTask(new FitDeployTaskInitService()));
        return ParseLldUtil.buildEmptyClusterInfo(deployNodes);
    }
}

