/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.factory;

import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParser;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.ClusterInfo;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.ClusterInfoStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.FullDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.OsNetworkStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.PolicyRouteStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.StaticRouteStrategyTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullSceneParser
extends LldParser {
    private static final Logger log = LoggerFactory.getLogger(FullSceneParser.class);

    @Override
    public ClusterNode buildDevNode(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        ClusterInfo clusterInfo = this.parsedClusterInfo(fileDatas);
        List devices = (List)new FullDeploySceneDevsStrategyTask(ParseLldUtil.integrateNodes(fileDatas), fileDatas.get(ObserverManager.getInstance().isExpansionScene() ? "addNodeDS" : "storageNodeDS")).run();
        this.parsedNetworkConfigStrategy(devices, fileDatas, clusterInfo);
        for (DeployNode deployNode : devices) {
            deployNode.setClusterName(clusterInfo.getClusterName());
            deployNode.setParentId(clusterInfo.getClusterIp());
        }
        return this.buildClusterNode(clusterInfo, devices);
    }

    private ClusterNode buildClusterNode(ClusterInfo clusterInfo, List<DeployNode> devices) {
        ClusterNode clusterNode = new ClusterNode();
        clusterNode.setIp(clusterInfo.getClusterIp());
        clusterNode.setId(clusterInfo.getClusterIp());
        clusterNode.setName(clusterInfo.getClusterName());
        clusterNode.setDeployNodes(devices);
        return clusterNode;
    }

    protected ClusterInfo parsedClusterInfo(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        Map<String, Attribute> clusterInfoData = fileDatas.get("clusterInfo").get(0);
        Map<String, Attribute> networkPlanData = fileDatas.get("networkPlan").get(0);
        List<Map<String, Attribute>> bondPlanData = fileDatas.get("bondPlan");
        List<Map<String, Attribute>> vlanPlanData = fileDatas.get("vlanPlan");
        return (ClusterInfo)new ClusterInfoStrategyTask(clusterInfoData, networkPlanData, bondPlanData, vlanPlanData).run();
    }

    protected void parsedNetworkConfigStrategy(List<DeployNode> devs, Map<String, List<Map<String, Attribute>>> fileDatas, ClusterInfo clusterInfo) throws ImportFileException, ToolException {
        Set<String> bmcIps = devs.stream().map(DeployNode::getIpAddress).map(IpAddress::getIp).collect(Collectors.toSet());
        Map ip2ConfigStrategies = (Map)new OsNetworkStrategyTask(fileDatas, clusterInfo, bmcIps).run();
        new StaticRouteStrategyTask(fileDatas.get("staticRoutePlan"), ip2ConfigStrategies).run();
        new PolicyRouteStrategyTask(fileDatas.get("strategyRoutePlan"), ip2ConfigStrategies).run();
        this.addStrategyToDev(devs, ip2ConfigStrategies);
    }

    protected void addStrategyToDev(List<DeployNode> devs, Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        log.info("ip2ConfigStrategies: {}", ip2ConfigStrategies);
        devs.forEach(dev -> dev.setOsNetworkStrategys((List)ip2ConfigStrategies.get(dev.getIpAddress().getIp())));
    }
}

