/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.factory;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParser;
import com.huawei.ism.tool.distributeddeploy.fit.service.lld.SceneEnum;
import com.huawei.ism.tool.obase.exception.ToolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class LldParseFactory {
    private static final Logger log = LoggerFactory.getLogger(LldParseFactory.class);

    public LldParser getLldParser(String scene) throws ToolException {
        return SceneEnum.of(scene).map(this::createParser).orElseThrow(() -> new ToolException("fit.importfile.verify.scene.illegal"));
    }

    private LldParser createParser(SceneEnum sceneEnum) {
        try {
            return sceneEnum.getLldParserClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("new lldparser error", (Throwable)e);
            return null;
        }
    }
}

