/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.factory;

import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParser;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.DirectPlaneNodesStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.MatchCheckDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.VersionMappingCheckStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.FitDirectPlaneDeployTaskInitService;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class VersionMappingCheckParser
extends LldParser {
    @Override
    public ClusterNode buildDevNode(Map<String, List<Map<String, Attribute>>> fileDatas) throws ImportFileException, ToolException {
        if (fileDatas.containsKey("versionMappingCheck")) {
            List deployNodes = (List)new VersionMappingCheckStrategyTask(fileDatas.get("versionMappingCheck")).run();
            return ParseLldUtil.buildEmptyClusterInfo(deployNodes);
        }
        List deployNodes = (List)new MatchCheckDeploySceneDevsStrategyTask(ParseLldUtil.integrateNodes(fileDatas)).run();
        if (fileDatas.containsKey("directPlane")) {
            List directNodes = (List)new DirectPlaneNodesStrategyTask(fileDatas.get("directPlane"), Collections.emptyList()).run();
            directNodes.forEach(node -> node.updateDeployTask(new FitDirectPlaneDeployTaskInitService()));
            deployNodes.addAll(directNodes);
        }
        ClusterNode clusterNode = ParseLldUtil.parseClusterInfo(fileDatas, deployNodes);
        deployNodes.forEach(deployNode -> deployNode.setClusterName(clusterNode.getName()));
        return clusterNode;
    }
}

