/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateConcurrentNumber;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ConcurrentNumberImpl {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentNumberImpl.class);
    private static final int MIN_CONCURRENT_NUMBER = 20;
    private static final int MAX_CONCURRENT_NUMBER = 100;
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=UpdateConcurrentNumber.class, id="5b97a568565b53eb10c8d21abf879cf6")
    public Response<String> updateCurrentNumber(Map<String, Integer> concurrentNumberMap) {
        if (!concurrentNumberMap.containsKey("concurrentNumber")) {
            log.error("Interface request error, the request don't have the concurrentNumber key");
            return this.responseUtil.failed(ResourceUtil.getString((String)"update.concurrent.number.request.error"), "");
        }
        int currentNumber = concurrentNumberMap.get("concurrentNumber");
        if (currentNumber < 20 || currentNumber > 100) {
            log.error("The current number is {}, less than {} or greater than {}", new Object[]{currentNumber, 20, 100});
            return this.responseUtil.failed(ResourceUtil.getString((String)"update.concurrent.number.restriction.error"), ResourceUtil.getStringWithParams((String)"update.concurrent.number.restriction.suggest", (Object[])new Object[]{20, 100}));
        }
        ThreadPoolExecutor executor = DeployTaskManager.getEXECUTOR();
        int activeCount = executor.getActiveCount();
        if (currentNumber < activeCount) {
            log.error("The current number is {} , less than the number of active threads {}.", (Object)currentNumber, (Object)activeCount);
            return this.responseUtil.failed(ResourceUtil.getStringWithParams((String)"update.concurrent.number.active.error", (Object[])new Object[]{activeCount}), ResourceUtil.getString((String)"update.concurrent.number.active.suggest"));
        }
        executor.setCorePoolSize(currentNumber);
        log.info("Set the concurrent number {} successfully.", (Object)currentNumber);
        return this.responseUtil.success(ResourceUtil.getString((String)"update.concurrent.number.success"));
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

