/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.impl.QueryBmcInfoServiceImpl;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.QueryCpuArchitecture;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.CpuArchitectureParam;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class CpuArchitectureService {
    private static final Logger log = LoggerFactory.getLogger(CpuArchitectureService.class);
    private static final int MAX_AUTH_POOL_SIZE = 20;
    @Fit
    private ResponseUtil responseUtil;
    @Fit(alias="queryServer\u7684\u5b9e\u73b0")
    private QueryServer queryServer;
    @Fit
    private NodeManager nodeManager;
    @Fit
    private QueryBmcInfoServiceImpl queryBmcInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Fitable(generic=QueryCpuArchitecture.class, id="c4443fb04ea64c54afaa58c35c89523c")
    public Response<String> queryCpuArchitecture(CpuArchitectureParam param) {
        ExecutorService pool = ThreadPoolHelper.getFixedNumThreadPool((int)Math.min(param.getUids().size(), 20), (String)"node_ssh_auth_pool");
        try {
            List<DeployNode> deployNodes = this.nodeManager.querySelectNodes(param.getTaskId(), param.getUids());
            String[] split = param.getTaskId().split("_");
            deployNodes.forEach(node -> this.submitCpuArchitectureTask(String.join((CharSequence)"_", split[0], node.getIp()), (DeployNode)node, pool));
            Response<String> response = this.responseUtil.success("");
            return response;
        }
        finally {
            pool.shutdown();
        }
    }

    private void submitCpuArchitectureTask(String uid, DeployNode deployNode, ExecutorService pool) {
        pool.execute(() -> this.queryOneNode(this.queryServer.process(uid), deployNode));
    }

    private void queryOneNode(Server server, DeployNode deployNode) {
        if (Objects.isNull(server)) {
            log.error("No available server information is used.");
            return;
        }
        try {
            String cpuArchitecture = this.queryBmcInfoService.queryCpuArchitecture(deployNode);
            server.setCpuArchitecture(cpuArchitecture);
            deployNode.setCpuArchitecture(cpuArchitecture);
        }
        catch (ToolException e) {
            log.error("An exception occurred when querying the CPU model.", (Throwable)e);
            server.setCpuArchitecture("--");
            deployNode.setCpuArchitecture("--");
        }
    }
}

