/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreatIsoImageForOsInstallUtil {
    private static final Logger log = LoggerFactory.getLogger(CreatIsoImageForOsInstallUtil.class);
    private static final Pattern ISO_NAME = Pattern.compile("([^\\\\/]+)\\.(tgz|iso)$");
    private static final Pattern OS_VERSION = Pattern.compile("SP(\\d+)");
    private static final String X86_COMPRESS_CMD = "\"%s\" as mkisofs -R -J -T -r -l -d -joliet-long -allow-multidot -allow-leading-dots -no-bak -V \"EulerOS-V2.0SP%s-x86_64\" -o \"%s.iso\" -b \"isolinux/isolinux.bin\" -c isolinux/boot.cat -no-emul-boot -boot-load-size 4 -boot-info-table -eltorito-alt-boot -e \"images/efiboot.img\" -no-emul-boot .";
    private static final String ARM_COMPRESS_CMD = "\"%s\" -joliet-long -V \"EulerOS-V2.0SP%s-aarch64\" -o \"%s.iso\" -R -J -T -r -l -d -allow-multidot -allow-leading-dots -b \"images/efiboot.img\" -no-emul-boot .";

    public static String execute(String isoFilePath, String tempPath) {
        String isoPath;
        String decompressIsoResult;
        if (StringUtils.isBlank((CharSequence)isoFilePath)) {
            return "";
        }
        String isoFileName = CreatIsoImageForOsInstallUtil.getIsoFileName(isoFilePath);
        if (isoFileName.isEmpty()) {
            return ResourceUtil.getString((String)"cannot.match.iso.file.name");
        }
        String cacheIsoFilePath = isoFilePath;
        if (!isoFilePath.contains(".iso")) {
            String tgzPath = Paths.get(tempPath, "tgz" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date())).toString();
            String decompressTgzResult = CreatIsoImageForOsInstallUtil.decompressFile(isoFilePath, tgzPath);
            if (!decompressTgzResult.isEmpty()) {
                return decompressTgzResult;
            }
            String tarPath = Paths.get(tempPath, "tar" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date())).toString();
            String tgzFilePath = Paths.get(tgzPath, isoFileName + ".tar").toString();
            String decompressTarResult = CreatIsoImageForOsInstallUtil.decompressFile(tgzFilePath, tarPath);
            if (!decompressTarResult.isEmpty()) {
                return decompressTarResult;
            }
            isoFileName = CreatIsoImageForOsInstallUtil.getIsoFileNameFromTgz(tarPath);
            if (isoFileName.isEmpty()) {
                return ResourceUtil.getString((String)"cannot.match.iso.file.name");
            }
            cacheIsoFilePath = Paths.get(tarPath, isoFileName + ".iso").toString();
        }
        if (!(decompressIsoResult = CreatIsoImageForOsInstallUtil.decompressFile(cacheIsoFilePath, isoPath = Paths.get(tempPath, "iso" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date())).toString())).isEmpty()) {
            return decompressIsoResult;
        }
        String modifyResult = CreatIsoImageForOsInstallUtil.modifyIsoFile(isoFileName, isoPath);
        if (!modifyResult.isEmpty()) {
            return modifyResult;
        }
        String osVersion = CreatIsoImageForOsInstallUtil.getOsVersion(isoFileName);
        if (osVersion.isEmpty()) {
            return ResourceUtil.getString((String)"cannot.match.os.version");
        }
        return CreatIsoImageForOsInstallUtil.compressFile(isoPath, isoFileName, osVersion, tempPath);
    }

    private static String getIsoFileName(String isoFilePath) {
        Matcher matcher = ISO_NAME.matcher(isoFilePath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private static String getIsoFileNameFromTgz(String directoryPath) {
        File[] files;
        File directory = new File(directoryPath);
        for (File file : files = directory.listFiles()) {
            if (CreatIsoImageForOsInstallUtil.getIsoFileName(file.getName()).isEmpty()) continue;
            return CreatIsoImageForOsInstallUtil.getIsoFileName(file.getName());
        }
        return "";
    }

    private static String getOsVersion(String isoFileName) {
        Matcher matcher = OS_VERSION.matcher(isoFileName);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String decompressFile(String filePath, String decompressPath) {
        String cmd = String.format("\"%s\" x \"%s\" -o\"%s\"", Constants.UTIL_7ZEXE_PATH, filePath, decompressPath);
        String result = OSCmdUtils.executeCmd(cmd);
        log.info(String.format("[decompress file]:%s", result));
        if (result.isEmpty() || result.toLowerCase(Locale.ENGLISH).contains("error")) {
            return ResourceUtil.getString((String)"decompress.file.failed");
        }
        return "";
    }

    private static String compressFile(String isoPath, String isoFileName, String osVersion, String tempPath) {
        String result = "";
        File isoFile = Paths.get(isoPath, isoFileName + ".iso").toFile();
        if (isoFileName.contains("x86")) {
            String cmd = String.format(X86_COMPRESS_CMD, Constants.UTIL_XORRISO_PATH, osVersion, isoFileName);
            result = OSCmdUtils.executeCmdOnWindows(cmd, null, isoPath, 60);
        } else if (isoFileName.contains("aarch64")) {
            String cmd = String.format(ARM_COMPRESS_CMD, Constants.UTIL_GENISOIMAGE_PATH, osVersion, isoFileName);
            result = OSCmdUtils.executeCmdOnWindows(cmd, null, isoPath, 60);
        } else {
            return ResourceUtil.getString((String)"cannot.match.cpu.architecture");
        }
        log.info(String.format("[compress iso image]:%s", result));
        if (result.isEmpty() || result.toLowerCase(Locale.ENGLISH).contains("error") || !CreatIsoImageForOsInstallUtil.renameIsoFile(isoFile, tempPath)) {
            return ResourceUtil.getString((String)"compress.file.failed");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean renameIsoFile(File isoFile, String tmpPath) {
        String targetPath = new File(tmpPath).getParent();
        File newIsoFile = new File(targetPath, isoFile.getName());
        try {
            if (!isoFile.renameTo(newIsoFile)) {
                boolean bl = false;
                return bl;
            }
            if (newIsoFile.getName().contains("x86")) {
                Context.INS.setX86IsoPath(newIsoFile.getCanonicalPath());
            } else {
                Context.INS.setArmIsoPath(newIsoFile.getCanonicalPath());
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("rename iso file failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.clearDir((String)tmpPath);
        }
    }

    static String modifyIsoFile(String isoFileName, String isoPath) {
        String grubFilePath = Paths.get(isoPath, "EFI", "BOOT", "grub.cfg").toString();
        String customFilePath = Paths.get(isoPath, "_custom.ks").toString();
        if (isoFileName.contains("x86")) {
            return CreatIsoImageForOsInstallUtil.replaceX86File(grubFilePath, customFilePath);
        }
        if (isoFileName.contains("aarch64")) {
            return CreatIsoImageForOsInstallUtil.replaceArmFile(grubFilePath, customFilePath);
        }
        return ResourceUtil.getString((String)"cannot.match.cpu.architecture");
    }

    static String replaceArmFile(String grubFilePath, String customFilePath) {
        try {
            log.info("[CreatingImage][ModifyingConfigurationFile]Modifying file grub.cfg");
            CreatIsoImageForOsInstallUtil.replaceStringInFile(grubFilePath, "set default=\"2\"", "set default=\"1\"");
            CreatIsoImageForOsInstallUtil.replaceStringInFile(grubFilePath, "set timeout=60", "set timeout=5");
            log.info("[CreatingImage][ModifyingConfigurationFile]Modifying file _custom.ks");
            CreatIsoImageForOsInstallUtil.addRebootAfterInstall(customFilePath);
            return "";
        }
        catch (ToolException e) {
            return e.getErrorId();
        }
    }

    static String replaceX86File(String grubFilePath, String customFilePath) {
        try {
            log.info("[CreatingImage][ModifyingConfigurationFile]Modifying file grub.cfg");
            CreatIsoImageForOsInstallUtil.replaceStringInFile(grubFilePath, "set default=\"1\"", "set default=\"0\"");
            CreatIsoImageForOsInstallUtil.replaceStringInFile(grubFilePath, "EulerOS\\x20V2.0SP5\\x20x86_64", "EulerOS-V2.0SP5-x86_64");
            CreatIsoImageForOsInstallUtil.replaceStringInFile(grubFilePath, "set timeout=60", "set timeout=5");
            String customOldString = "sh /etc/EulerOS_init.sh";
            String customNewString = customOldString + "\nsed -i 's/fsck.mode=auto/fsck.mode=auto console=tty0 console=ttyS0,115200 erst_disable/g' /boot/efi/EFI/euleros/grub.cfg";
            log.info("[CreatingImage][ModifyingConfigurationFile]Modifying file _custom.ks");
            CreatIsoImageForOsInstallUtil.addRebootAfterInstall(customFilePath);
            CreatIsoImageForOsInstallUtil.replaceStringInFile(customFilePath, customOldString, customNewString);
            return "";
        }
        catch (ToolException e) {
            return e.getErrorId();
        }
    }

    private static void addRebootAfterInstall(String customFilePath) throws ToolException {
        String customOldString = "%include /root/part-include\n\n%packages";
        String customNewString = "%include /root/part-include\n\n# after install OS success, auto reboot system\nreboot\n\n%packages";
        CreatIsoImageForOsInstallUtil.replaceStringInFile(customFilePath, customOldString, customNewString);
    }

    public static void replaceStringInFile(String filePath, String oldString, String newString) throws ToolException {
        File file = new File(filePath);
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                fileContent.append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error("[CreatingImage][ModifyingConfigurationFile]Before modifying file, generating a temporary content from original file throws an I/O ERROR.", (Throwable)e);
            throw new ToolException(ResourceUtil.getString((String)"modify.config.file.failed"));
        }
        if (fileContent.toString().contains(newString)) {
            return;
        }
        String newContent = fileContent.toString().replace(oldString, newString);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write(newContent);
            writer.flush();
            if (!file.renameTo(new File(filePath))) {
                log.error(ResourceUtil.getString((String)"convert.file.format.failed"));
                throw new ToolException(ResourceUtil.getString((String)"convert.file.format.failed"));
            }
        }
        catch (IOException e) {
            log.error("[CreatingImage][ModifyingConfigurationFile]After modifying file, replace original file with temporary content throws an I/O ERROR.", (Throwable)e);
            throw new ToolException(ResourceUtil.getString((String)"modify.config.file.failed"));
        }
    }

    private CreatIsoImageForOsInstallUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

