/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.distributeddeploy.entity.User;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ItemCheckResult;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.ism.tool.distributeddeploy.fit.mapper.BmcConfigMapper;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.TaskSumUtil;
import com.huawei.ism.tool.distributeddeploy.logic.config.CustomVersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.PlatformStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.BmcConfigTaskInitService;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.CubeCheckTaskInitService;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.FitDeployTaskInitService;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.SystemInstallationTaskService;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.SubmitMatchCheckTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateSelectNodes;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ClusterParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitBmcConfigTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitConfigBiosInfo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitMultiTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.VersionCheckParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.BiosConfigParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ClusterEvaluationParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ConfigDataParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiTaskParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.TaskParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.RetryItem;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.RetryTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.ModifyItemTaskStatus;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.ItemParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.ModifyItemTaskStatusParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Cluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.system.installationn.storage.distribution.SystemInstall;
import com.huawei.yinglong.river.system.storage.distribution.entity.SystemInstallationParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ExecuteTaskImpl {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTaskImpl.class);
    @Fit
    NodeManager nodeManager;
    @Fit
    TaskContext taskContext;
    @Fit
    ResponseUtil responseUtil;
    @Fit(alias="queryCluster\u7684\u5b9e\u73b0")
    private QueryCluster queryCluster;
    @Fit(alias="queryServer\u7684\u5b9e\u73b0")
    private QueryServer queryServer;
    private final BmcConfigMapper dataMapper = (BmcConfigMapper)Mappers.getMapper(BmcConfigMapper.class);

    private void validate(TaskParams taskParams) throws ToolException {
        ServerUtil.splitTaskIdAndCheck(taskParams.getTaskId());
        this.checkMappingVersion(taskParams.getDeployVersion());
        this.checkStepId(taskParams.getSubTaskIds());
        this.checkDevId(taskParams.getDevIds(), taskParams.getTaskId());
        List selectNodes = this.nodeManager.queryAllRegisteredNodes().stream().filter(deployNode -> taskParams.getDevIds().contains(deployNode.getIp())).collect(Collectors.toList());
        String runningNodes = selectNodes.stream().filter(deployNode -> !deployNode.getDeployTask().isFinish()).map(DeployNode::getIp).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(runningNodes)) {
            throw new ToolException("fit.task.verify.device.running", (Object[])new String[]{runningNodes});
        }
    }

    private void checkDevId(List<String> devIds, String taskId) throws ToolException {
        if (CollectionUtil.isEmpty(devIds)) {
            throw new ToolException("fit.task.verify.device.id.empty");
        }
        String[] split = taskId.split("_");
        List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(split[0], split[1]);
        if (CollectionUtil.isEmpty(deployNodes)) {
            throw new ToolException("fit.task.verify.task.id.empty");
        }
        Set cacheIps = deployNodes.stream().map(DeployNode::getIp).collect(Collectors.toSet());
        String illegalDevs = devIds.stream().filter(devId -> !cacheIps.contains(devId)).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(illegalDevs)) {
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{illegalDevs});
        }
    }

    private void checkStepId(List<String> subTaskIds) throws ToolException {
        if (CollectionUtil.isEmpty(subTaskIds)) {
            throw new ToolException("fit.task.verify.step.id.empty");
        }
        Set<String> stepIds = ProductStrategy.INS.getFitStepIds();
        String illegalSteps = subTaskIds.stream().filter(subTaskId -> !stepIds.contains(subTaskId)).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(illegalSteps)) {
            throw new ToolException("fit.task.verify.step.id.illegal", (Object[])new String[]{illegalSteps});
        }
    }

    private void checkMappingVersion(String deployVersion) throws ToolException {
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(deployVersion)) {
            throw new ToolException("fit.task.verify.version.empty");
        }
        if (!VersionMappingStrategy.INS.getStrategy().containsKey(deployVersion)) {
            throw new ToolException("fit.task.verify.version.illegal");
        }
    }

    @Fitable(generic=SubmitTask.class, id="961fe02efb63450c90824d42edd1d2ff")
    public Response<String> executeTask(TaskParams params) {
        try {
            this.validate(params);
            String[] split = params.getTaskId().split("_");
            this.cacheVersionMapping(split[0], split[1], params.getDeployVersion());
            Optional<ClusterNode> clusterNodeOptional = this.nodeManager.queryClusterNodeById(split[0], split[1]);
            if (!clusterNodeOptional.isPresent()) {
                throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{split[1]});
            }
            List selectIpList = params.getDevIds();
            List<DeployNode> selectNodes = clusterNodeOptional.get().getDeployNodes().stream().filter(deployNode -> selectIpList.contains(deployNode.getId())).filter(DeployNode::isNeedDeploy).collect(Collectors.toList());
            DeployTaskManager deployTaskManager = this.taskContext.getDeployTaskManager(split[0]);
            IUIObserver obs = deployTaskManager.getObs();
            Map<String, Map<String, PlatformStrategy>> strategy = CustomVersionMappingStrategy.getStrategy(split[0]);
            selectNodes.forEach(deployNode -> deployNode.initDeployTask(params.getSubTaskIds(), obs, strategy));
            obs.initDevUIData(split[0], clusterNodeOptional.get(), params.getDevIds());
            deployTaskManager.startDeployTaskByScene(selectNodes);
            this.taskContext.cacheCurrentRunNode(params.getTaskId(), params.getDevIds());
            return this.responseUtil.success(ResourceUtil.getString((String)"fit.task.start.result.succeed"));
        }
        catch (ToolException e) {
            log.error("start deploy task [{}] error:", (Object)params.getTaskId(), (Object)e);
            throw new FitException("start deploy task error.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("unknown error happened when execute task.", (Throwable)e);
            throw new FitException("unknown error happened when execute task.", (Throwable)e);
        }
    }

    private void cacheVersionMapping(String taskId, String clusterId, String deployVersion) {
        Optional<ClusterNode> clusterNodeOptional = this.nodeManager.queryClusterNodeById(taskId, clusterId);
        if (!clusterNodeOptional.isPresent()) {
            return;
        }
        ObserverManager.getInstance().cacheVersionMapping(clusterNodeOptional.get(), deployVersion);
    }

    @FitTrust(generic=SubmitTask.class, position="error", id="ExecuteTaskError")
    public Response<String> deployErrorHandle(TaskParams taskParams, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.start.result.error"));
    }

    @Fitable(generic=RetryItem.class, id="a14ab277702346f297db84e2bf06f32b")
    public Response<String> retryItem(ItemParams params) {
        try {
            ItemCheckResult itemCheckResult = this.validateItemInfo(params.getTaskId(), params.getSubTaskId(), params.getDevId(), params.getItemId());
            String[] split = params.getTaskId().split("_");
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(split[0]);
            deployTaskManager.getObs().resetItemDetail(params);
            itemCheckResult.getItemTask().retryDeploySingle();
            deployTaskManager.startDeployTaskByScene(Collections.singletonList(itemCheckResult.getDeployNode()));
            return this.responseUtil.success(ResourceUtil.getStringWithParams((String)"fit.task.retry.item.success", (Object[])new Object[]{params.getItemId()}));
        }
        catch (ToolException | AbstractMethodError e) {
            log.error("start to retry item [{}] error:", (Object)params.getItemId(), (Object)e);
            throw new FitException("retry item failed.", e);
        }
        catch (Exception e) {
            log.error("unknown error happened when retry item.", (Throwable)e);
            throw new FitException("unknown error happened when retry item.", (Throwable)e);
        }
    }

    private ItemCheckResult validateItemInfo(String taskId, String stepId, String devId, String itemId) throws ToolException {
        String[] split = ServerUtil.splitTaskIdAndCheck(taskId);
        List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(split[0], split[1]);
        DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(split[0]);
        if (CollectionUtil.isEmpty(deployNodes) || deployTaskManager == null) {
            throw new ToolException("fit.task.retry.check.task.not.exist");
        }
        Optional<DeployNode> deployNodeOptional = deployNodes.stream().filter(deployNode -> deployNode.getId().equals(devId)).findFirst();
        if (!deployNodeOptional.isPresent()) {
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{devId});
        }
        DeployNode deployNode2 = deployNodeOptional.get();
        if (!deployNode2.getDeployTask().isFinish()) {
            throw new ToolException("fit.modify.item.check.running.tips");
        }
        if (deployNode2.getDeployTask().getDeployHelperServerObserver() == null) {
            throw new ToolException("fit.task.retry.check.task.not.exist");
        }
        Optional<ItemTask> targetTask = this.findTargetTask(deployNode2, stepId, itemId);
        if (!targetTask.isPresent()) {
            throw new ToolException("fit.task.retry.check.item.not.found", (Object[])new String[]{itemId});
        }
        return ItemCheckResult.builder().deployNode(deployNode2).itemTask(targetTask.get()).build();
    }

    private Optional<ItemTask> findTargetTask(DeployNode deployNode, String stepId, String itemId) {
        return deployNode.getDeployTask().getSubTasks().stream().filter(stepTask -> stepTask.getStepInfo().getId().equals(stepId)).map(StepTask::getSubTasks).flatMap(Collection::stream).filter(itemTask -> itemTask.getId().equals(itemId)).findFirst();
    }

    @FitTrust(generic=RetryItem.class, position="error", id="RetryItemError")
    public Response<String> retryItemErrorHandle(ItemParams params, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getStringWithParams((String)"fit.task.retry.item.error", (Object[])new Object[]{params.getItemId()}));
    }

    @Fitable(generic=RetryTask.class, id="0a9774a98cb04eb6bbb62ad7c5895a33")
    public Response<String> retryTask(TaskParams params) {
        try {
            this.validateRetryParam(params);
            String[] split = params.getTaskId().split("_");
            this.cacheVersionMapping(split[0], split[1], params.getDeployVersion());
            List<DeployNode> retryNodes = this.nodeManager.queryNodesByTaskId(split[0], split[1]).stream().filter(deployNode -> params.getDevIds().contains(deployNode.getId())).collect(Collectors.toList());
            retryNodes.forEach(DeployNode::retryDeployAll);
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(split[0]);
            retryNodes.forEach(deployNode -> deployTaskManager.getObs().resetStepDetail(split[0], split[1], deployNode.getId(), params.getSubTaskIds()));
            deployTaskManager.startDeployTaskByScene(retryNodes);
            return this.responseUtil.success(ResourceUtil.getString((String)"fit.task.retry.task.success"));
        }
        catch (ToolException | AbstractMethodError e) {
            log.error("start to retry task [{}] error:", (Object)params.getTaskId(), (Object)e);
            throw new FitException("retry task failed.", e);
        }
        catch (Exception e) {
            log.error("unknown error happened when retry task.", (Throwable)e);
            throw new FitException("unknown error happened when retry task.", (Throwable)e);
        }
    }

    private void validateRetryParam(TaskParams taskParams) throws ToolException {
        String[] splitValues = ServerUtil.splitTaskIdAndCheck(taskParams.getTaskId());
        if (!taskParams.getSubTaskIds().contains("system_installation") && !taskParams.getSubTaskIds().contains("bios_config")) {
            this.checkMappingVersion(taskParams.getDeployVersion());
            this.checkStepId(taskParams.getSubTaskIds());
        }
        this.checkDevId(taskParams.getDevIds(), taskParams.getTaskId());
        DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(splitValues[0]);
        if (deployTaskManager == null) {
            throw new ToolException("fit.task.retry.check.task.not.exist");
        }
        List devIds = taskParams.getDevIds();
        List retryNodes = this.nodeManager.queryNodesByTaskId(splitValues[0], splitValues[1]).stream().filter(deployNode -> devIds.contains(deployNode.getId())).collect(Collectors.toList());
        String runningNodes = retryNodes.stream().filter(deployNode -> !deployNode.getDeployTask().isFinish()).map(DeployNode::getId).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(runningNodes)) {
            throw new ToolException("fit.task.verify.device.running", (Object[])new String[]{runningNodes});
        }
        String canNotRedeployNodes = retryNodes.stream().filter(deployNode -> !deployNode.canRedeploy()).map(DeployNode::getId).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(canNotRedeployNodes)) {
            throw new ToolException("fit.task.retry.check.node.cannot.redeploy", (Object[])new String[]{canNotRedeployNodes});
        }
    }

    @FitTrust(generic=RetryTask.class, position="error", id="RetryTaskError")
    public Response<String> retryTaskErrorHandle(TaskParams params, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.retry.task.error"));
    }

    @Fitable(generic=ModifyItemTaskStatus.class, id="1a083636b5a249c49292b684dd3e2d96")
    public Response<String> modifyItemTaskStatus(ModifyItemTaskStatusParams params) {
        try {
            Status status = this.validateStatus(params.getStatus());
            ItemCheckResult itemCheckResult = this.validateItemInfo(params.getTaskId(), params.getSubTaskId(), params.getDevId(), params.getItemId());
            if (TaskSumUtil.isConfirm(status)) {
                itemCheckResult.getDeployNode().setIndicatorStatus(status);
                return this.responseUtil.success(ResourceUtil.getString((String)"fit.modify.item.task.success"));
            }
            itemCheckResult.getItemTask().changeResult(status);
            String[] split = params.getTaskId().split("_");
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(split[0]);
            deployTaskManager.startDeployTaskByScene(Collections.singletonList(itemCheckResult.getDeployNode()));
            return this.responseUtil.success(ResourceUtil.getString((String)"fit.modify.item.task.success"));
        }
        catch (ToolException e) {
            log.error("modify item status error", (Throwable)e);
            throw new FitException("modify item status error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("unknown error happened when modify item status.", (Throwable)e);
            throw new FitException("unknown error happened when modify item status.", (Throwable)e);
        }
    }

    private Status validateStatus(String statusStr) throws ToolException {
        if (StringUtils.isNULLStr((String)statusStr)) {
            throw new ToolException("fit.modify.item.check.status.empty");
        }
        return ResultStatus.transferToStatus(statusStr);
    }

    @FitTrust(generic=ModifyItemTaskStatus.class, position="error", id="ModifyItemTaskStatusError")
    public Response<TaskStatistics> modifyStatusErrorHandle(ModifyItemTaskStatusParams params, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.modify.item.task.error"));
    }

    @Fitable(generic=SubmitMultiTask.class, id="a76b6daa5f334bcfbb00c97c784fa2f5")
    public Response<String> submitMultiTask(MultiTaskParam multiTaskParam) {
        try {
            List<ClusterNode> clusterNodes = this.checkClusterAndGetNodes(multiTaskParam);
            this.cacheDeployVersion(multiTaskParam);
            for (ClusterNode clusterNode : clusterNodes) {
                this.startClusterTask(clusterNode, multiTaskParam);
            }
            return this.responseUtil.success(ResourceUtil.getString((String)"fit.task.start.result.succeed"));
        }
        catch (ToolException e) {
            log.error("start deploy task [{}] error:", (Object)multiTaskParam.getTaskId(), (Object)e);
            throw new FitException("start deploy task error.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("unknown error happened when execute multi task.", (Throwable)e);
            throw new FitException("unknown error happened when execute multi task.", (Throwable)e);
        }
    }

    private void startClusterTask(ClusterNode clusterNode, MultiTaskParam params) throws ToolException {
        DeployTaskManager deployTaskManager = this.taskContext.getDeployTaskManager(params.getTaskId());
        IUIObserver obs = deployTaskManager.getObs();
        List<DeployNode> selectNodes = clusterNode.getNeedDeployNodes();
        this.initTask(clusterNode, params, obs, selectNodes);
        obs.initDevUIData(params.getTaskId(), clusterNode, Collections.emptyList());
        deployTaskManager.startDeployTaskByScene(selectNodes);
    }

    private void initTask(ClusterNode clusterNode, MultiTaskParam params, IUIObserver obs, List<DeployNode> selectNodes) throws ToolException {
        if ("FusionCube".equals(clusterNode.getModel())) {
            CubeCheckTaskInitService cubeCheckTaskInitService = new CubeCheckTaskInitService();
            List steps = ProductStrategy.INS.getCubeStepInfos().stream().map(StepInfo::getId).collect(Collectors.toList());
            selectNodes.forEach(deployNode -> this.initCubeTask((DeployNode)deployNode, cubeCheckTaskInitService, steps, obs));
            return;
        }
        List<String> subTaskIds = this.getSubTaskIdsByCluster(params, clusterNode.getId());
        Map<String, Map<String, PlatformStrategy>> strategy = CustomVersionMappingStrategy.getStrategy(params.getTaskId().concat(clusterNode.getIp()));
        selectNodes.forEach(deployNode -> deployNode.initDeployTask(subTaskIds, obs, strategy));
    }

    private void initCubeTask(DeployNode deployNode, CubeCheckTaskInitService taskInitService, List<String> steps, IUIObserver obs) {
        deployNode.updateDeployTask(taskInitService);
        deployNode.initDeployTask(steps, obs);
    }

    private List<String> getSubTaskIdsByCluster(MultiTaskParam params, String clusterIp) throws ToolException {
        Optional<ClusterEvaluationParams> clusterParamOptional = params.getClusterParams().stream().filter(clusterEvaluationParams -> clusterEvaluationParams.getClusterId().equals(clusterIp)).findFirst();
        if (!clusterParamOptional.isPresent()) {
            log.error("not found the cluster in params when start multi deploy task.");
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{clusterIp});
        }
        return clusterParamOptional.get().getSubTaskIds();
    }

    private List<ClusterNode> checkClusterAndGetNodes(MultiTaskParam params) throws ToolException {
        ArrayList<String> devIds = new ArrayList<String>();
        for (ClusterEvaluationParams clusterParams : params.getClusterParams()) {
            this.checkMappingVersion(clusterParams.getMappingVersion());
            this.checkStepId(clusterParams.getSubTaskIds());
            devIds.add(clusterParams.getClusterId());
        }
        if (CollectionUtil.isEmpty(devIds)) {
            throw new ToolException("fit.task.verify.device.id.empty");
        }
        List<ClusterNode> clusterNodes = this.nodeManager.queryClusterNodes(params.getTaskId());
        if (CollectionUtil.isEmpty(clusterNodes)) {
            throw new ToolException("fit.task.verify.task.id.empty");
        }
        Set cacheIps = clusterNodes.stream().map(ClusterNode::getId).collect(Collectors.toSet());
        String illegalDevs = devIds.stream().filter(devId -> !cacheIps.contains(devId)).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(illegalDevs)) {
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{illegalDevs});
        }
        List<ClusterNode> selectClusters = clusterNodes.stream().filter(clusterNode -> devIds.contains(clusterNode.getId())).collect(Collectors.toList());
        List selectNodes = selectClusters.stream().map(ClusterNode::getDeployNodes).flatMap(Collection::stream).collect(Collectors.toList());
        String runningNodes = selectNodes.stream().filter(deployNode -> !deployNode.getDeployTask().isFinish()).map(DeployNode::getIp).collect(Collectors.joining(","));
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(runningNodes)) {
            throw new ToolException("fit.task.verify.device.running", (Object[])new String[]{runningNodes});
        }
        return selectClusters;
    }

    private void cacheDeployVersion(MultiTaskParam params) {
        params.getClusterParams().forEach(clusterParam -> this.cacheVersionMapping(params.getTaskId(), clusterParam.getClusterId(), clusterParam.getMappingVersion()));
    }

    @FitTrust(generic=SubmitMultiTask.class, position="error", id="SubmitMultiTaskError")
    public Response<TaskStatistics> submitMultiTaskHandle(MultiTaskParam multiTaskParam, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.start.result.error"));
    }

    @Fitable(generic=SubmitMatchCheckTask.class, id="3194760fbab94032a0bee28ed10ef25d")
    public Response<String> submitMatchCheckTask(VersionCheckParams params) {
        this.initDevNode(params.getTaskId(), params.getClusterParams());
        MultiTaskParam multiTaskParam = this.buildMultiTaskParam(params);
        return this.submitMultiTask(multiTaskParam);
    }

    private void initDevNode(String taskId, List<ClusterParam> clusterParams) {
        clusterParams.forEach(clusterParam -> {
            ClusterNode clusterNode = new ClusterNode();
            clusterNode.setId(clusterParam.getClusterId());
            clusterNode.setIp(clusterParam.getClusterId());
            clusterNode.setDeployNodes(this.buildDeployNodes((ClusterParam)clusterParam));
            this.updateClusterInfo(clusterNode);
            this.nodeManager.refreshNodesByTaskId(taskId, clusterNode);
        });
    }

    private void updateClusterInfo(ClusterNode clusterNode) {
        Cluster cluster = this.queryCluster.process(clusterNode.getId());
        if (cluster == null) {
            return;
        }
        clusterNode.setModel(cluster.getClusterModel());
        clusterNode.setName(cluster.getClusterName());
        clusterNode.setVersion(cluster.getClusterVersion());
        clusterNode.setSn(cluster.getSn());
        this.removeNullDeployNodes(clusterNode);
    }

    private void removeNullDeployNodes(ClusterNode clusterNode) {
        clusterNode.getDeployNodes().removeIf(deployNode -> com.huawei.ism.tool.base.utils.StringUtils.isNULLStr(deployNode.getIpAddress().getIp()));
    }

    private List<DeployNode> buildDeployNodes(ClusterParam clusterParam) {
        return clusterParam.getDevUids().stream().map(arg_0 -> ((QueryServer)this.queryServer).process(arg_0)).map(this::getDeployNode).collect(Collectors.toList());
    }

    private DeployNode getDeployNode(Server server) {
        DeployNode deployNode = new DeployNode(new FitDeployTaskInitService(), Card.CardScene.MATCH_CHECK);
        deployNode.setIpAddress(this.createIpAddress(server));
        deployNode.setBmcUser(this.buildUserByLoginUser(server.getLoginUser()));
        deployNode.setParentId(server.getClusterId());
        if (Objects.nonNull(server.getOsRootUser())) {
            deployNode.setOsRootUser(this.buildRootUserByLoginUser(server.getOsRootUser()));
            deployNode.setOsUser(this.buildUserByLoginUser(server.getOsUser()));
        } else {
            deployNode.setOsRootUser(this.buildUserByLoginUser(server.getOsUser()));
            deployNode.setOsUser(this.buildUserByLoginUser(null));
        }
        deployNode.setDevType(server.getModel());
        return deployNode;
    }

    private User buildRootUserByLoginUser(LoginUser user) {
        if (user == null) {
            return User.buildEmptyUser();
        }
        String encryptPwd = AESEncrypt.encrypt(Base64EncodeUtils.decode(AESEncrypt.decrypt(user.getPwd())));
        return User.buildWithEncryptedPwd(user.getName(), encryptPwd, encryptPwd);
    }

    private User buildUserByLoginUser(LoginUser loginUser) {
        if (loginUser == null) {
            return User.buildEmptyUser();
        }
        return User.buildWithEncryptedPwd(loginUser.getName(), loginUser.getPwd(), loginUser.getPwd());
    }

    private IpAddress createIpAddress(Server server) {
        IpAddress ipAddress = new IpAddress();
        ipAddress.setIp(server.getBmcIp());
        return ipAddress;
    }

    private MultiTaskParam buildMultiTaskParam(VersionCheckParams params) {
        return MultiTaskParam.builder().taskId(params.getTaskId()).clusterParams(this.mapToClusterParams(params)).build();
    }

    private List<ClusterEvaluationParams> mapToClusterParams(VersionCheckParams params) {
        return params.getClusterParams().stream().map(this::buildClusterEvaluation).collect(Collectors.toList());
    }

    private ClusterEvaluationParams buildClusterEvaluation(ClusterParam clusterParam) {
        return ClusterEvaluationParams.builder().clusterId(clusterParam.getClusterId()).subTaskIds(this.getMatchCheckItemIds()).mappingVersion(clusterParam.getVersion()).build();
    }

    @NotNull
    private List<String> getMatchCheckItemIds() {
        return ProductStrategy.INS.getFitStepIds().stream().filter("version_check"::equals).collect(Collectors.toList());
    }

    @Fitable(generic=SubmitBmcConfigTask.class, id="6dd3797116aa4ad3bec46d0b219f4038")
    public Response<String> submitBmcConfigTask(ConfigDataParam configParam) {
        return this.executeWithParam(configParam.getTaskId(), configParam.getDevUids(), configParam.getSubTaskIds(), this.dataMapper.toVO(configParam));
    }

    private void validateParam(List<String> devUids, String taskId) throws ToolException {
        this.checkDevId(devUids, taskId);
    }

    private void initTask(List<DeployNode> deployNodes, IUIObserver obs, List<String> subTaskIds) {
        for (DeployNode deployNode : deployNodes) {
            deployNode.updateDeployTask(new BmcConfigTaskInitService());
            deployNode.initDeployTask(subTaskIds, obs);
        }
    }

    private void initParams(List<DeployNode> deployNodes, Object configParam) {
        deployNodes.forEach(deployNode -> deployNode.setConfigParam(configParam));
    }

    @Fitable(generic=SubmitConfigBiosInfo.class, id="c00953ccc7154ae1a1bc4aca45f606c8")
    public Response<String> submitConfigBiosInfo(BiosConfigParam configParam) {
        return this.executeWithParam(configParam.getTaskId(), configParam.getDevUids(), configParam.getSubTaskIds(), configParam);
    }

    private Response<String> executeWithParam(String taskId, List<String> devUids, List<String> subTaskId, Object param) {
        try {
            List<DeployNode> deployNodes = this.prepareTask(taskId, devUids, subTaskId);
            this.initParams(deployNodes, param);
            this.taskContext.getDeployTaskManager(taskId.split("_")[0]).startDeployTaskByScene(deployNodes);
            this.taskContext.cacheCurrentRunNode(taskId, devUids);
            return this.responseUtil.success("fit.task.start.result.succeed");
        }
        catch (ToolException toolException) {
            return this.responseUtil.failed(toolException.getDes());
        }
        catch (Exception e) {
            log.error("start task failed", (Throwable)e);
            return this.responseUtil.failed(ResourceUtil.getString((String)"fit.task.start.result.error"));
        }
    }

    private List<DeployNode> prepareTask(String taskId, List<String> devUids, List<String> subTaskIds) throws ToolException {
        this.validateParam(devUids, taskId);
        return this.initTask(taskId, devUids, subTaskIds);
    }

    private List<DeployNode> initTask(String taskId, List<String> devUids, List<String> subTaskIds) throws ToolException {
        ClusterNode clusterNode = this.findClusterNode(taskId, devUids);
        DeployTaskManager deployTaskManager = this.taskContext.getDeployTaskManager(taskId.split("_")[0]);
        List<DeployNode> deployNodes = clusterNode.getDeployNodes().stream().filter(node -> devUids.contains(node.getIp())).peek(node -> node.getBmcUser().setEncryptOriginPassword(this.queryServer.process(taskId.split("_")[0] + "_" + node.getId()).getLoginUser().getPwd())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(deployNodes)) {
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", devUids.toArray());
        }
        this.initTask(deployNodes, deployTaskManager.getObs(), subTaskIds);
        deployTaskManager.getObs().initDevUIData(taskId.split("_")[0], clusterNode, devUids);
        return deployNodes;
    }

    @NotNull
    private ClusterNode findClusterNode(String taskId, List<String> devUids) throws ToolException {
        String[] split = taskId.split("_");
        return this.nodeManager.queryClusterNodeById(split[0], split[1]).orElseThrow(() -> new ToolException("fit.task.modify.bmc.verify.ip.not.found", devUids.toArray()));
    }

    @Fitable(generic=SystemInstall.class, id="30a835e9c784478a929027f09dc0a8a6")
    public Response<String> systemInstall(SystemInstallationParams params) {
        try {
            List<DeployNode> deployNodes = this.prepareSystemInstall(params.getTaskId(), params.getDevIds(), params.getSubTaskIds());
            this.initParams(deployNodes, params);
            this.taskContext.getDeployTaskManager(params.getTaskId().split("_")[0]).startDeployTaskByScene(deployNodes);
            this.taskContext.cacheCurrentRunNode(params.getTaskId(), params.getDevIds());
            return this.responseUtil.success("fit.task.start.result.succeed");
        }
        catch (ToolException toolException) {
            log.error("Tool exception ", (Throwable)toolException);
            return this.responseUtil.failed(toolException.getDes());
        }
        catch (Exception e) {
            log.error("start task failed", (Throwable)e);
            return this.responseUtil.failed(ResourceUtil.getString((String)"fit.task.start.result.error"));
        }
    }

    private List<DeployNode> prepareSystemInstall(String taskId, List<String> devUids, List<String> subTaskIds) throws ToolException {
        this.validateParam(devUids, taskId);
        return this.initSystemInstallTask(taskId, devUids, subTaskIds);
    }

    private List<DeployNode> initSystemInstallTask(String taskId, List<String> devUids, List<String> subTaskIds) throws ToolException {
        ClusterNode clusterNode = this.findClusterNode(taskId, devUids);
        DeployTaskManager deployTaskManager = this.taskContext.getDeployTaskManager(taskId.split("_")[0]);
        List<DeployNode> deployNodes = clusterNode.getDeployNodes().stream().filter(node -> devUids.contains(node.getIp())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(deployNodes)) {
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", devUids.toArray());
        }
        this.init(deployNodes, deployTaskManager.getObs(), subTaskIds);
        deployTaskManager.getObs().initDevUIData(taskId.split("_")[0], clusterNode, devUids);
        return deployNodes;
    }

    private void init(List<DeployNode> deployNodes, IUIObserver obs, List<String> subTaskIds) {
        deployNodes.forEach(deployNode -> {
            deployNode.updateDeployTask(new SystemInstallationTaskService());
            deployNode.initDeployTask(subTaskIds, obs);
        });
    }

    @Fitable(generic=UpdateSelectNodes.class, id="34fa9c7fd37a45f794f794a8b0c7f54d")
    public void updateSelectNodes(TaskParams params) {
        if (!params.getSubTaskIds().contains("bmc_ip_config_by_input")) {
            log.warn("not config bmc ip step, no need to update");
            return;
        }
        String[] split = params.getTaskId().split("_");
        DeployTaskManager deployTaskManager = this.taskContext.getDeployTaskManager(split[0]);
        IUIObserver obs = deployTaskManager.getObs();
        try {
            obs.getTaskRunningDetail(split[0]).getClusterRunningDetail(split[1]).ifPresent(detail -> this.removeNotSelect((ClusterRunningDetail)detail, params));
        }
        catch (ToolException e) {
            log.error("running detail not found", (Throwable)e);
        }
    }

    private void removeNotSelect(ClusterRunningDetail runningDetails, TaskParams params) {
        Map<String, DeployRunningDetail> deployRunningDetailMap = runningDetails.getDeployRunningDetailMap();
        List<String> notSelectIds = deployRunningDetailMap.keySet().stream().filter(devId -> !params.getDevIds().contains(devId)).collect(Collectors.toList());
        notSelectIds.forEach(deployRunningDetailMap::remove);
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }

    public void setQueryCluster(QueryCluster queryCluster) {
        this.queryCluster = queryCluster;
    }

    public void setQueryServer(QueryServer queryServer) {
        this.queryServer = queryServer;
    }
}

