/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.distributeddeploy.fit.service.lld.SceneEnum;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.ui.listener.ExportTemplate;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportLldTemplate;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ExportLldTemplateImpl {
    private static final Logger log = LoggerFactory.getLogger(ExportLldTemplateImpl.class);
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportTemplate.class, id="953b2819bc3a4a979c547257d393a1c4")
    public Response<String> exportTemplate(String targetDir, String scene) {
        try {
            SceneEnum sceneEnum = SceneEnum.ofDefault(scene);
            String templateName = ExportLldTemplateImpl.getTemplateName(sceneEnum);
            ServerUtil.commonDirCheck(targetDir);
            String targetFile = targetDir + File.separator + templateName;
            File file = this.getNoRepeatFile(targetFile);
            boolean isExportSuccess = ExportLldTemplateImpl.export(sceneEnum, file);
            if (isExportSuccess) {
                return this.responseUtil.success(file.getCanonicalPath());
            }
            return this.responseUtil.failed(ResourceUtil.getString((String)"mainFrame.top.export.failed"), "");
        }
        catch (ToolException e) {
            log.error("export template failed", (Throwable)e);
            throw new FitException("export template failed", (Throwable)e);
        }
        catch (IOException e) {
            log.error("get path error", (Throwable)e);
            throw new FitException("get path error", (Throwable)e);
        }
    }

    private static boolean export(SceneEnum sceneEnum, File file) {
        return new ExportTemplate().outputTemPlate(sceneEnum.getTemplatePath(), file);
    }

    @NonNull
    private static String getTemplateName(SceneEnum sceneEnum) {
        return sceneEnum.getExportName();
    }

    @Fitable(generic=ExportLldTemplate.class, id="4fdcf4118234455b8540f6f29d18b8e3")
    public Response<String> exportLldTemplate(String targetDir) {
        try {
            ServerUtil.commonDirCheck(targetDir);
            String targetFile = targetDir + File.separator + "DeployTemplate%s.xlsx";
            File file = this.getNoRepeatFile(targetFile);
            boolean isExportSuccess = new ExportTemplate().outputTemPlate(file);
            if (isExportSuccess) {
                return this.responseUtil.success(file.getCanonicalPath());
            }
            return this.responseUtil.failed(ResourceUtil.getString((String)"mainFrame.top.export.failed"), "");
        }
        catch (ToolException e) {
            log.error("export template failed", (Throwable)e);
            throw new FitException("export template failed", (Throwable)e);
        }
        catch (IOException e) {
            log.error("get path error", (Throwable)e);
            throw new FitException("get path error", (Throwable)e);
        }
    }

    private File getNoRepeatFile(String targetFile) {
        int count = 1;
        File file = new File(String.format(Locale.ROOT, targetFile, ""));
        while (file.exists()) {
            file = new File(String.format(Locale.ROOT, targetFile, String.format(Locale.ROOT, "_%s", count++)));
        }
        return file;
    }

    @FitTrust(generic=ExportLldTemplate.class, position="error", id="ExportLldTemplateError")
    public Response<String> exportLldTemplateErrorHandle(String targetDir, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"mainFrame.top.export.failed"));
    }

    @FitTrust(generic=com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportTemplate.class, position="error", id="ExportTemplateError")
    public Response<String> exportTemplateErrorHandle(String targetDir, String scene, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"mainFrame.top.export.failed"));
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

