/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.base.utils.CallbackPackageSnMappingUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ResourceBoundEnum;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.operation.DeployUserOperationData;
import com.huawei.ism.tool.distributeddeploy.service.report.ReportBuilder;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONArray;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ExportWithScene;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ExportReport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ExportReportImpl {
    private static final Logger log = LoggerFactory.getLogger(ExportReportImpl.class);
    @Fit
    NodeManager nodeManager;
    @Fit
    ResponseUtil responseUtil;
    @Fit
    TaskContext taskContext;

    @Fitable(generic=ExportReport.class, id="3c085898c1e2415eb22987ee90423ddc")
    public Response<String> exportReport(String taskId, String targetDir) {
        try {
            ServerUtil.commonDirCheck(targetDir);
            List<ClusterNode> clusterNodes = this.nodeManager.queryClusterNodes(taskId);
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(taskId);
            if (deployTaskManager == null) {
                return this.responseUtil.failed(ResourceUtil.getString((String)"fit.task.query.detail.not.found"), "");
            }
            String msg = "";
            if (deployTaskManager.getObs().hasRunningDev()) {
                log.info("Export report in running status.");
                msg = ResourceUtil.getString((String)"export.report.running.msg");
            }
            String reportFile = new ReportBuilder().buildClusterReport(clusterNodes, targetDir);
            this.buildUserOpData(clusterNodes, deployTaskManager.getUserOperationData(), reportFile);
            return this.responseUtil.successWithDescription(targetDir, msg);
        }
        catch (ToolException e) {
            log.error("export result fail", (Throwable)e);
            throw new FitException("export result fail", (Throwable)e);
        }
    }

    private void buildUserOpData(List<ClusterNode> clusterNodes, DeployUserOperationData opData, String reportFile) {
        try {
            if (!Context.INS.isFitDeployScene()) {
                return;
            }
            this.setUserOpData(opData, clusterNodes.get(0));
            CallbackPackageSnMappingUtils.recordToolPackageSnMapping("Distributed Deploy", this.buildSnJson(opData).toString(), reportFile);
        }
        catch (Exception e) {
            log.error("user operation count error", (Throwable)e);
        }
    }

    @NotNull
    private JSONArray buildSnJson(DeployUserOperationData opData) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put(opData.getDeviceSn());
        return jsonArray;
    }

    private void setUserOpData(DeployUserOperationData opData, ClusterNode clusterNode) {
        opData.setClusterIpNotEmpty(String.valueOf(StringUtils.isNULLStr((String)clusterNode.getIp())));
        List<DeployNode> deployNodes = clusterNode.getDeployNodes();
        opData.setTotalNodes(deployNodes.size());
        this.countStepResult(opData, deployNodes);
        opData.setDeviceSn(this.collectAllNodeSn(deployNodes));
        opData.setDeviceType(this.collectAllNodeModel(deployNodes));
        opData.setDeviceVersion(ResourceUtil.getString((String)clusterNode.getMappingVersion()));
        opData.setProxyWay("no proxy, sol to os");
        opData.setAuthWay("lld excel");
        opData.setTaskResult(this.getTaskResultStatus(deployNodes));
    }

    private void countStepResult(DeployUserOperationData opData, List<DeployNode> deployNodes) {
        Map<String, List<ItemTask>> countTask = deployNodes.stream().map(DeployNode::getDeployTask).map(DeployTask::getSubTasks).flatMap(Collection::stream).map(StepTask::getSubTasks).flatMap(Collection::stream).collect(Collectors.groupingBy(ItemTask::getId));
        for (String key : countTask.keySet()) {
            opData.getDynamicAttr().put(key, this.buildCountData(countTask, key));
        }
    }

    @NotNull
    private Map<String, Long> buildCountData(Map<String, List<ItemTask>> countTask, String key) {
        HashMap<String, Long> countCache = new HashMap<String, Long>();
        List<ItemTask> itemTasks = countTask.get(key);
        countCache.put(Status.FAILED.toString(), itemTasks.stream().filter(itemTask -> Status.isFailed(itemTask.getStatus())).count());
        countCache.put(Status.WAITING_EXEC.toString(), itemTasks.stream().filter(itemTask -> itemTask.getStatus() == Status.WAITING_EXEC || itemTask.getStatus() == Status.WAITING).count());
        countCache.put(Status.SUCCESSFUL.toString(), itemTasks.stream().filter(itemTask -> Stream.of(Status.PASS, Status.SUCCESSFUL, Status.IGNORED).anyMatch(status -> itemTask.getStatus() == status)).count());
        return countCache;
    }

    private String collectAllNodeModel(List<DeployNode> deployNodes) {
        return deployNodes.stream().map(DeployNode::getDevType).distinct().collect(Collectors.joining(","));
    }

    private String collectAllNodeSn(List<DeployNode> deployNodes) {
        return deployNodes.stream().map(DeployNode::getSn).filter(sn -> !StringUtils.isNULLStr((String)sn)).collect(Collectors.joining(","));
    }

    private UserOpTaskResult getTaskResultStatus(List<DeployNode> deployNodes) {
        return deployNodes.stream().map(DeployNode::getStatus).distinct().anyMatch(Status::isFailed) ? UserOpTaskResult.FAILED : UserOpTaskResult.SUCCESS;
    }

    @FitTrust(generic=ExportReport.class, position="error", id="ExportReportError")
    public Response<String> exportReportErrorHandle(String taskId, String targetDir, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"export.report.common.err"));
    }

    @Fitable(generic=ExportWithScene.class, id="d0101da8e59944248a55a83650c3c3a8")
    public Response<String> exportWithScene(String taskId, String targetDir, String scene) {
        Context.INS.setScene(ResourceBoundEnum.of(scene));
        Response<String> response = this.exportReport(taskId, targetDir);
        Context.INS.setScene(ResourceBoundEnum.of(""));
        return response;
    }
}

