/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ModifyBmcIpParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ModifyBmcIp;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ModifyBmcIpImpl {
    private static final Logger log = LoggerFactory.getLogger(ModifyBmcIpImpl.class);
    @Fit
    TaskContext taskContext;
    @Fit
    NodeManager nodeManager;
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=ModifyBmcIp.class, id="829228cb20134123a1fb40b64a8af4ee")
    public Response<String> modifyBmcIp(ModifyBmcIpParam params) {
        try {
            this.validate(params);
            this.cacheBmcIp(params);
            return this.responseUtil.success(ResourceUtil.getString((String)"fit.task.modify.bmc.result.succeed"));
        }
        catch (ToolException e) {
            log.error("modify bmc ip of {} to {} error:", new Object[]{params.getDevId(), params.getNewBmcIp(), e});
            throw new FitException("modify bmc ip failed.", (Throwable)e);
        }
    }

    private void cacheBmcIp(ModifyBmcIpParam param) {
        String[] splitValues = param.getTaskId().split("_");
        List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(splitValues[0], splitValues[1]);
        deployNodes.stream().filter(deployNode -> deployNode.getId().equals(param.getDevId())).forEach(deployNode -> deployNode.setNowBmcIp(param.getNewBmcIp()));
    }

    private void validate(ModifyBmcIpParam params) throws ToolException {
        String newBmcSourceIp = params.getNewBmcIp();
        if (!StringUtils.isValidIPV4(newBmcSourceIp) && !StringUtils.isIpv6Address(newBmcSourceIp)) {
            throw new ToolException("bmcIpFrame.bmc.now.ip.addresserror");
        }
        String[] splitValues = ServerUtil.splitTaskIdAndCheck(params.getTaskId());
        List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(splitValues[0], splitValues[1]);
        if (CollectionUtil.isEmpty(deployNodes)) {
            throw new ToolException("fit.task.verify.task.id.empty");
        }
        String id = params.getDevId();
        boolean hasIp = deployNodes.stream().anyMatch(deployNode -> deployNode.getIp().equals(id));
        if (!hasIp) {
            throw new ToolException("fit.task.modify.bmc.verify.ip.not.found", (Object[])new String[]{id});
        }
    }

    @FitTrust(generic=ModifyBmcIp.class, position="error", id="ModifyBmcIpError")
    public Response<String> modifyBmcIpErrorHandle(ModifyBmcIpParam params, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.modify.bmc.result.error"));
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

