/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.fit.entity.CpuArchitectureEnum;
import com.huawei.ism.tool.distributeddeploy.fit.service.CreatIsoImageForOsInstallUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.SystemInstallVerify;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.InstallVerifyParam;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class OsInstallVerifyService {
    private static final Logger log = LoggerFactory.getLogger(OsInstallVerifyService.class);
    @Fit(alias="queryServer\u7684\u5b9e\u73b0")
    private QueryServer queryServer;
    @Fit
    private ResponseUtil responseUtil;

    @Fitable(generic=SystemInstallVerify.class, id="2ec7f4ccb5a04e28a5a1d2c877131dc5")
    public Response<String> systemInstallVerify(InstallVerifyParam param) {
        FileUtils.clearDir((String)Paths.get(Constants.TEMP_PATH, "iso" + param.getTaskId()).toString());
        ArrayList<String> errors = new ArrayList<String>();
        if (this.checkOsPath(param, errors)) {
            return this.responseUtil.failed(errors.stream().distinct().collect(Collectors.joining(System.lineSeparator())));
        }
        errors.add(this.cpuArchitectureVerify(param.getDevIds(), param.getTaskId(), param.getIsoX86Path(), param.getIsoArmPath()));
        errors.add(this.checkDiskFreeCapacity(param.getIsoArmPath(), param.getIsoX86Path()));
        errors.add(CreatIsoImageForOsInstallUtil.execute(param.getIsoArmPath(), Paths.get(Constants.TEMP_PATH, "iso" + param.getTaskId(), "ARM").toString()));
        errors.add(CreatIsoImageForOsInstallUtil.execute(param.getIsoX86Path(), Paths.get(Constants.TEMP_PATH, "iso" + param.getTaskId(), "X86").toString()));
        log.info("Pre-installation Check Information {}", (Object)String.join((CharSequence)System.lineSeparator(), errors));
        if (!this.isEmptyErrors(errors)) {
            return this.responseUtil.failed(String.join((CharSequence)System.lineSeparator(), errors));
        }
        return this.responseUtil.success("");
    }

    private boolean checkOsPath(InstallVerifyParam param, List<String> errors) {
        errors.add(this.verifyPath(param.getIsoArmPath()));
        errors.add(this.verifyPath(param.getIsoX86Path()));
        return !this.isEmptyErrors(errors);
    }

    private String cpuArchitectureVerify(List<String> devIds, String taskId, String x86IsoPath, String armIsoPath) {
        List<Server> servers = this.getServers(devIds, taskId);
        if (servers.isEmpty()) {
            return ResourceUtil.getString((String)"no.node.error");
        }
        List<String> notMatchNode = this.getNotMatchIds(x86IsoPath, armIsoPath, servers);
        if (this.isEmptyErrors(notMatchNode)) {
            return "";
        }
        return ResourceUtil.getStringWithParams((String)"cpu.architecture.not.match", (Object[])new Object[]{String.join((CharSequence)",", notMatchNode)});
    }

    public String verifyPath(String osPath) {
        if (ObjectUtils.isEmpty((Object)osPath)) {
            return "";
        }
        File target = new File(osPath);
        String canonicalPath = "";
        try {
            canonicalPath = target.getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            log.error("get getCanonicalPath fail", (Throwable)e);
            return ResourceUtil.getStringWithParams((String)"os.path.check", (Object[])new Object[]{target.getParentFile()});
        }
        if (!this.checkPathIsNormal(canonicalPath)) {
            return ResourceUtil.getStringWithParams((String)"os.path.check", (Object[])new Object[]{canonicalPath});
        }
        return "";
    }

    public boolean checkPathIsNormal(String path) {
        String tempPath = path;
        if (tempPath == null) {
            return false;
        }
        tempPath = tempPath.replaceAll("\\\\", "");
        tempPath = tempPath.replaceAll("/", "");
        tempPath = tempPath.replaceAll(":", "");
        if ((tempPath = tempPath.replaceAll("\\.", "")).contains("  ")) {
            return false;
        }
        return tempPath.matches("[\\u4e00-\\u9fa5\\w -]+");
    }

    private String checkDiskFreeCapacity(String isoArmPath, String isoX86Path) {
        long requiredSpace;
        File disk;
        long freeSpace;
        long isoSize = 0L;
        if (!StringUtils.isNULLStr((String)isoArmPath)) {
            File isoArm = new File(isoArmPath);
            isoSize = isoArm.length();
        }
        if (!StringUtils.isNULLStr((String)isoX86Path)) {
            File isoX86 = new File(isoX86Path);
            isoSize += isoX86.length();
        }
        if ((freeSpace = (disk = new File(Constants.WORK_PATH)).getUsableSpace()) < (requiredSpace = isoSize * 4L)) {
            double requiredSpaceInGB = (double)requiredSpace / 1.073741824E9;
            String requiredSpaceInStr = String.format("%.2f", requiredSpaceInGB) + "GB";
            return ResourceUtil.getStringWithParams((String)"disk.usableSpace.not.enough", (Object[])new Object[]{requiredSpaceInStr});
        }
        return "";
    }

    private List<Server> getServers(List<String> devIds, String taskId) {
        String[] split = taskId.split("_");
        return devIds.stream().map(devId -> String.join((CharSequence)"_", split[0], devId)).map(uid -> this.queryServer.process(uid)).collect(Collectors.toList());
    }

    private List<String> getNotMatchIds(String x86IsoPath, String armIsoPath, List<Server> servers) {
        if (ObjectUtils.isEmpty((Object)x86IsoPath)) {
            return this.notMatchIds(servers, CpuArchitectureEnum.ARM.getKeyOfServer());
        }
        if (ObjectUtils.isEmpty((Object)armIsoPath)) {
            return this.notMatchIds(servers, CpuArchitectureEnum.X86.getKeyOfServer());
        }
        return servers.stream().filter(server -> !CpuArchitectureEnum.isMatchCpuArchitecture(server.getCpuArchitecture())).map(Server::getBmcIp).collect(Collectors.toList());
    }

    private List<String> notMatchIds(List<Server> servers, String cpuArchitecture) {
        return servers.stream().filter(server -> !server.getCpuArchitecture().equalsIgnoreCase(cpuArchitecture)).map(Server::getBmcIp).collect(Collectors.toList());
    }

    private boolean isEmptyErrors(List<String> errors) {
        return CollectionUtils.isEmpty(errors) || errors.stream().allMatch(String::isEmpty);
    }

    public void setQueryServer(QueryServer queryServer) {
        this.queryServer = queryServer;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

