/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class ParseExpansionImpl {
    private static final Logger log = LoggerFactory.getLogger(ParseExpansionImpl.class);

    public List<ExpansionConfig> parseExpansion(Map<String, List<Map<String, Attribute>>> stringListMap) throws ToolException {
        List fileMaps = stringListMap.getOrDefault("addNode", Collections.emptyList());
        List<ExpansionConfig> configs = fileMaps.stream().map(this::buildExpansion).collect(Collectors.toList());
        this.updateHCSOInfo(stringListMap, configs);
        return configs;
    }

    private void updateHCSOInfo(Map<String, List<Map<String, Attribute>>> stringListMap, List<ExpansionConfig> configs) {
        List hcsoFileMaps = stringListMap.getOrDefault("hcsoExternalOm", Collections.emptyList());
        if (hcsoFileMaps.isEmpty()) {
            log.info("HCSO information does not need to be updated.");
            return;
        }
        Map<String, String> bmcToOmIpMap = hcsoFileMaps.stream().collect(Collectors.toMap(map -> this.getMapData((Map<String, Attribute>)map, "bmcIp"), map -> this.getMapData((Map<String, Attribute>)map, "omIp")));
        configs.forEach(expansionConfig -> {
            if (bmcToOmIpMap.containsKey(expansionConfig.getBmcIp())) {
                expansionConfig.setManagerIp((String)bmcToOmIpMap.get(expansionConfig.getBmcIp()));
            }
        });
    }

    private ExpansionConfig buildExpansion(Map<String, Attribute> fileMap) {
        if (fileMap.isEmpty()) {
            log.info("The capacity expansion information does not exist.");
            return ExpansionConfig.builder().build();
        }
        return ExpansionConfig.builder().devType(this.getMapData(fileMap, "devType")).bmcIp(this.getMapData(fileMap, "bmcIp")).sn(this.getMapData(fileMap, "sn")).newNode(this.getMapData(fileMap, "isNewNode")).nodeName(this.getMapData(fileMap, "nodeName")).expansionMode(this.getMapData(fileMap, "expansionMode")).parentStoragePool(this.getMapData(fileMap, "parentStoragePool")).parentDiskPool(this.getMapData(fileMap, "parentDiskPool")).managerIp(this.getMapData(fileMap, "omIp")).mainStorageType(this.getMapData(fileMap, "mainStorageType")).mainStorageConfigure(this.getMapData(fileMap, "mainStorageConfigure")).cacheStorageType(this.getMapData(fileMap, "cacheStorageType")).cacheStorageConfigure(this.getMapData(fileMap, "cacheStorageConfigure")).serviceType(this.getMapData(fileMap, "serviceType")).build();
    }

    private String getMapData(Map<String, Attribute> fileMap, String key) {
        return fileMap.getOrDefault(key, new Attribute(new Attribute.Location("", 0, 0), "--")).getValue();
    }
}

