/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.google.common.collect.ImmutableList;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.service.QueryDeployNodeImpl;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.QueryBmcInfoService;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.drop.entity.storage.entity.StorageNodeDto;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryBmcConfigInfo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryMappingVersion;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MappingVersion;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiMappingVersions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class QueryBmcConfigInfoImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryBmcConfigInfoImpl.class);
    private static final List<String> VERSIONS_WITH_MAPPING_FILE = ImmutableList.of((Object)"8.0.1.block", (Object)"8.1.0.convergence", (Object)"8.1.0.block", (Object)"8.1.1.convergence", (Object)"8.1.1.block", (Object)"8.1.2.convergence", (Object)"8.1.2.block", (Object)"8.1.3.convergence", (Object)"8.1.3.block", (Object)"8.1.5.convergence", (Object)"8.1.5.block", (Object)"8.1.6.convergence", (Object[])new String[]{"8.1.6.block", "8.2.0.convergence", "8.2.0L15Y01.convergence", "8.2.0L15Y01.block", "8.2.0.block", "a310_1.0.0.convergence", "1.0.0.convergence", "nfv.dedicated", "nfv.dedicated.5", "nfv.dedicated.6", "FusionCube 1000H", "FusionCube 1000D"});
    @Fit
    NodeManager nodeManager;
    @Fit
    QueryBmcInfoService queryService;
    @Fit
    QueryDeployNodeImpl queryDeployNode;

    @Fitable(generic=QueryBmcConfigInfo.class, id="32cf25313e55423cbc4571d5a56ff7bb")
    public Response<Object> queryBmcConfigInfo(String taskId, String devIp) {
        try {
            Optional<DeployNode> node = this.nodeManager.queryNodesByTaskId(taskId).stream().filter(deployNode -> deployNode.getIp().equals(devIp)).findFirst();
            if (node.isPresent()) {
                return ResponseUtil.success((Object)this.queryService.query(node.get()));
            }
            return ResponseUtil.failed((Object)ResourceUtil.getString((String)"fit.task.verify.task.id.empty"));
        }
        catch (ToolException toolException) {
            log.error("query bmc info error.", (Throwable)toolException);
            return ResponseUtil.failed((Object)ResourceUtil.getString((String)"fit.query.bmc.info.error"));
        }
    }

    @Fitable(generic=QueryMappingVersion.class, id="32cf25313e55423cbc4571d5a56ff7aa")
    public Response<MultiMappingVersions> queryMappingVersion(String taskId, String floatIp, String devType) {
        Set<String> keys = VersionMappingStrategy.INS.getStrategy().keySet();
        Optional<StorageNodeDto> storageNode = ((MultiStroageNodeDto)this.queryDeployNode.queryDevice(taskId).getData()).getStroageNodeDto().stream().filter(node -> node.getIp().equals(floatIp)).filter(this::isFusionCubeNode).findFirst();
        if (storageNode.isPresent() || "FusionCube".equals(devType)) {
            return this.buildFusionCubeVersion(keys);
        }
        List mappingVersions = keys.stream().filter(key -> !key.contains("nfv.dedicated.3")).filter(key -> !VersionMappingStrategy.INS.getCubeVersion().contains(key)).sorted(Collections.reverseOrder()).map(this::buildMappingVersion).collect(Collectors.toList());
        return ResponseUtil.success((Object)MultiMappingVersions.builder().mappingVersion(mappingVersions).build());
    }

    private Response<MultiMappingVersions> buildFusionCubeVersion(Set<String> keys) {
        return ResponseUtil.success((Object)MultiMappingVersions.builder().mappingVersion(this.buildCubeMappingVersion(keys)).build());
    }

    @NotNull
    private List<MappingVersion> buildCubeMappingVersion(Set<String> keys) {
        return keys.stream().filter(VersionMappingStrategy.INS.getCubeVersion()::contains).sorted().map(this::buildMappingVersion).collect(Collectors.toList());
    }

    private boolean isFusionCubeNode(StorageNodeDto storageNodeDto) {
        return Objects.equals(storageNodeDto.getProductModel(), "FusionCube");
    }

    private MappingVersion buildMappingVersion(String versionKey) {
        String versionDesc = ResourceUtil.getString((String)versionKey);
        String desc = "--".equals(versionDesc) ? versionKey : versionDesc;
        return MappingVersion.builder().version(versionKey).desc(desc).needVersionMapping(!VERSIONS_WITH_MAPPING_FILE.contains(versionKey)).build();
    }
}

