/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.ExpansionManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.drop.entity.storage.entity.StorageNodeDto;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.MultiDeployNodes;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryDeployNode;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.DeployNodeVo;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class QueryDeployNodeImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryDeployNodeImpl.class);
    private static final String EXPANSION = "FsExpansion";
    @Fit(alias="queryDevice\u7684\u5b9e\u73b0")
    com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryDevice queryDevice;
    @Fit
    NodeManager nodeManager;
    @Fit
    ResponseUtil responseUtil;
    @Fit
    TaskContext taskContext;
    @Fit
    ExpansionManager expansionManager;

    @Fitable(generic=QueryDeployNode.class, id="e0014d1a354c4a46922fcf6190dcd44b")
    public Response<MultiDeployNodes> queryDeployNode(String taskId) {
        try {
            String[] splitValues = ServerUtil.splitTaskIdAndCheck(taskId);
            List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(splitValues[0], splitValues[1]);
            List deployNodeVoList = deployNodes.stream().filter(DeployNode::isNeedDeploy).map(deployNode -> this.buildDeployNodeVo(splitValues[0], (DeployNode)deployNode)).collect(Collectors.toList());
            return this.responseUtil.success(MultiDeployNodes.builder().deployNodeVo(deployNodeVoList).build());
        }
        catch (ToolException e) {
            log.error("query deploy nodes error.");
            throw new FitException("query deploy nodes error", (Throwable)e);
        }
    }

    private DeployNodeVo buildDeployNodeVo(String taskId, DeployNode deployNode) {
        DeployRunningDetail deployRunningDetail;
        DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(taskId);
        if (deployTaskManager == null) {
            return ParseLldUtil.buildDeployNodeVo(deployNode);
        }
        try {
            deployRunningDetail = deployTaskManager.getObs().getDeployNodeRunningDetail(taskId, deployNode.getParentId(), deployNode.getId());
        }
        catch (ToolException | AbstractMethodError e) {
            log.warn("query running detail fail, and return origin node info");
            return ParseLldUtil.buildDeployNodeVo(deployNode);
        }
        DeployNodeVo deployNodeVo = ParseLldUtil.buildDeployNodeVo(deployNode);
        deployNodeVo.setStartTime(deployRunningDetail.getRunningMessage().getStartTime());
        deployNodeVo.setEndTime(deployRunningDetail.getRunningMessage().getEndTime());
        return deployNodeVo;
    }

    @FitTrust(generic=QueryDeployNode.class, position="error", id="QueryDeployNodeError")
    public Response<MultiDeployNodes> queryDeployNodeErrorHandle(String taskId, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.verify.task.id.empty"));
    }

    @Fitable(generic=QueryDevice.class, id="b79790e70b0a4144b6bd48cc3f79c9e6")
    public Response<MultiStroageNodeDto> queryDevice(String taskId) {
        List<ClusterNode> clusterNodes = this.nodeManager.queryClusterNodes(taskId);
        Map ipNode = clusterNodes.stream().filter(clusterNode -> !StringUtils.isNULLStr(clusterNode.getIp())).map(clusterNode -> ParseLldUtil.buildStorageNodeDto(this.expansionManager, taskId, clusterNode)).collect(Collectors.toMap(StorageNodeDto::getIp, Function.identity(), (node, repeatNode) -> node));
        if (Context.INS.isExpansionScene()) {
            return this.responseUtil.success(MultiStroageNodeDto.builder().stroageNodeDto(this.getHardwareStorageNode(taskId, clusterNodes)).build());
        }
        return this.responseUtil.success(MultiStroageNodeDto.builder().stroageNodeDto(new ArrayList(ipNode.values())).build());
    }

    private List<StorageNodeDto> getHardwareStorageNode(String taskId, List<ClusterNode> clusterNodes) {
        return clusterNodes.stream().filter(clusterNode -> "default".equals(clusterNode.getId())).map(clusterNode -> ParseLldUtil.buildStorageNodeDto(this.expansionManager, taskId, clusterNode)).peek(storageNodeDto -> storageNodeDto.setStatus(this.expansionManager.hasConfigVersion(String.join((CharSequence)"_", taskId, "default")) ? ResultStatus.CONFIGURED.getKey() : ResultStatus.NOT_CONFIGURED.getKey())).peek(storageNodeDto -> storageNodeDto.setId("default")).collect(Collectors.toList());
    }

    @FitTrust(generic=QueryDevice.class, position="error", id="QueryDeviceError")
    public Response<MultiStroageNodeDto> queryDeviceErrorHandle(String taskId, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.verify.task.id.empty"));
    }

    public void setQueryDevice(com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryDevice queryDevice) {
        this.queryDevice = queryDevice;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setExpansionManager(ExpansionManager expansionManager) {
        this.expansionManager = expansionManager;
    }
}

