/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.fit.common.ExpansionManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.ConfirmExpansionInfo;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryExpansionConfig;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiExpansionConfig;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class QueryExpansionConfigImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryExpansionConfigImpl.class);
    @Fit
    ExpansionManager expansionManager;
    @Fit
    ResponseUtil responseUtil;
    @Fit
    NodeManager nodeManager;

    @Fitable(generic=ConfirmExpansionInfo.class, id="39ae6ec2be52453f93ee814a2c4062e9")
    public Response<String> confirmExpansionInfo(String taskId, String devId) {
        Optional<ClusterNode> clusterNodeOptional = this.nodeManager.queryClusterNodeById(taskId, devId);
        if (!clusterNodeOptional.isPresent() || CollectionUtil.isEmpty(clusterNodeOptional.get().getNeedDeployNodes())) {
            return this.responseUtil.failed(ResourceUtil.getString((String)"fit.importFile.confirmCheck.emptyNode"), "");
        }
        this.expansionManager.updateConfigVersion(String.join((CharSequence)"_", taskId, devId));
        return this.responseUtil.success("");
    }

    @Fitable(generic=QueryExpansionConfig.class, id="9ee834fec27e4801aa6717888a4bed77")
    public Response<MultiExpansionConfig> queryExpansionConfig(String devId) {
        return this.responseUtil.success(MultiExpansionConfig.builder().expansionConfig(this.expansionManager.queryExpansionByDevId(devId)).build());
    }
}

