/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.User;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryExpansionNodes;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionNode;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiExpansionNode;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class QueryExpansionNodesImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryExpansionNodesImpl.class);
    @Fit
    NodeManager nodeManager;
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=QueryExpansionNodes.class, id="c40abbc7163e4dc4becc36da87a49334")
    public Response<MultiExpansionNode> queryExpansionNodes(String taskId, String devId) {
        List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(taskId);
        if (CollectionUtil.isEmpty(deployNodes)) {
            log.error("The task does not exist.");
            return this.responseUtil.failed("The task does not exist.", "");
        }
        List expansionNodes = deployNodes.stream().filter(deployNode -> devId.equals(deployNode.getParentId())).map(this::buildExpansionNode).collect(Collectors.toList());
        if (expansionNodes.isEmpty()) {
            log.error("DevId does not exist");
            return this.responseUtil.failed("DevId does not exist", "");
        }
        return this.responseUtil.success(MultiExpansionNode.builder().expansionNode(expansionNodes).build());
    }

    private ExpansionNode buildExpansionNode(DeployNode deployNode) {
        User bmcUser = this.getUser(deployNode.getBmcUser());
        User osUser = this.getUser(deployNode.getOsUser());
        User rootUser = this.getUser(deployNode.getOsRootUser());
        return ExpansionNode.builder().id(deployNode.getId()).bmcIp(deployNode.getIp()).bmcUserName(bmcUser.getUserName()).bmcUserOriginPassword(bmcUser.getEncrtyptOriginPassword()).bmcUserNewPassword(bmcUser.getEncrtyptNewPassword()).osUserName(osUser.getUserName()).osUserOriginPassword(osUser.getEncrtyptOriginPassword()).osUserNewPassword(osUser.getEncrtyptNewPassword()).rootUserOriginPassword(rootUser.getEncrtyptOriginPassword()).rootUserNewPassword(rootUser.getEncrtyptNewPassword()).build();
    }

    private User getUser(User user) {
        return Optional.ofNullable(user).orElseGet(() -> new User("", "", ""));
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

