/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.ItemInfo;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ItemRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.ism.tool.distributeddeploy.fit.entity.RunningMessage;
import com.huawei.ism.tool.distributeddeploy.fit.entity.StepRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.TaskRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.TaskSumUtil;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.drop.entity.item.entity.ItemConf;
import com.huawei.yinglong.drop.entity.item.entity.ItemDetail;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.DeployNodeVo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.QueryDeployNodeDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.StepTaskDetailVo;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryHardwareEvaluationOverview;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.HardwareEvaluationOverview;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiHardwareEvaluationOverview;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class QueryTaskDetailImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryTaskDetailImpl.class);
    @Fit
    TaskContext taskContext;
    @Fit
    ResponseUtil responseUtil;
    @Fit
    NodeManager nodeManager;

    @Fitable(generic=QueryTaskDetail.class, id="9a147efe7a2d4e818a3c47a0ad2ac30f")
    public Response<MultiDeployTaskDetail> queryTaskDetail(QueryTaskDetailParam param) {
        try {
            String[] splitValues = ServerUtil.splitTaskIdAndCheck(param.getTaskId());
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(splitValues[0]);
            if (deployTaskManager == null) {
                log.warn("Deploy task manager not found by id {}. The task may not be deployed.", (Object)splitValues[0]);
                return this.responseUtil.success(this.buildEmptyTaskDetail());
            }
            TaskRunningDetail taskRunningDetail = deployTaskManager.getObs().getTaskRunningDetail(splitValues[0]);
            if (taskRunningDetail == null) {
                log.warn("Task running detail not found by id {}. The task may not be deployed.", (Object)splitValues[0]);
                return this.responseUtil.success(this.buildEmptyTaskDetail());
            }
            String clusterIp = splitValues[1];
            Optional<ClusterRunningDetail> clusterRunningDetailOptional = taskRunningDetail.getClusterRunningDetail(clusterIp);
            if (!clusterRunningDetailOptional.isPresent()) {
                log.warn("Cluster running detail not found by id {}. The task may not be deployed.", (Object)clusterIp);
                return this.responseUtil.success(this.buildEmptyTaskDetail());
            }
            ClusterRunningDetail clusterRunningDetail = clusterRunningDetailOptional.get();
            List subTaskIds = param.getSubTaskIds();
            this.checkStepIds(param.getTaskId(), clusterRunningDetail, subTaskIds);
            MultiDeployTaskDetail multiTaskDetail = this.buildTaskDetail(clusterRunningDetail, subTaskIds, splitValues[0], clusterIp);
            return this.responseUtil.success(multiTaskDetail);
        }
        catch (ToolException | AbstractMethodError e) {
            log.error("query detail of task [{}] error:", (Object)param.getTaskId(), (Object)e);
            throw new FitException("query task detail failed.", e);
        }
    }

    private void checkStepIds(String taskId, ClusterRunningDetail clusterRunningDetail, List<String> subTaskIds) throws ToolException {
        if (CollectionUtil.isEmpty(subTaskIds)) {
            return;
        }
        List<Object> details = clusterRunningDetail.getDeployRunningDetails().stream().filter(detail -> this.taskContext.nodeStarted(taskId, detail.getNode())).collect(Collectors.toList());
        if (this.isBmcIpConfigSubtaskId(subTaskIds)) {
            details = clusterRunningDetail.getDeployRunningDetails();
        }
        for (DeployRunningDetail detail2 : details) {
            this.checkStepDeployed(detail2, subTaskIds);
        }
    }

    private boolean isBmcIpConfigSubtaskId(List<String> subTaskIds) {
        return subTaskIds.contains("lit_indicator") || subTaskIds.contains("off_indicator") || subTaskIds.contains("config_bmc_ip_by_input_ip") || subTaskIds.contains("bmc_ip_config_by_input");
    }

    private String findClusterIp(String taskId, String clusterId) {
        Optional<ClusterNode> clusterNodeOptional;
        String clusterIp = clusterId;
        if ("default".equals(clusterId) && (clusterNodeOptional = this.nodeManager.queryClusterNodeById(taskId, clusterId)).isPresent()) {
            clusterIp = clusterNodeOptional.get().getIp();
        }
        return clusterIp;
    }

    private MultiDeployTaskDetail buildEmptyTaskDetail() {
        return MultiDeployTaskDetail.builder().deployTaskDetails(Collections.emptyList()).detail(TaskDetail.builder().progress(Double.valueOf(0.0)).status(ResultStatus.NO_CHECK.getKey()).build()).build();
    }

    private MultiDeployTaskDetail buildTaskDetail(ClusterRunningDetail clusterRunningDetail, List<String> stepIds, String taskId, String clusterId) throws ToolException {
        List deployTaskDetailVoList = clusterRunningDetail.getDeployRunningDetails().stream().filter(deployRunningDetail -> this.isBmcIpConfigSubtaskId(stepIds) || this.taskContext.nodeStarted(taskId + "_default", deployRunningDetail.getNode())).map(deployRunningDetail -> this.initDeployTaskDetail((DeployRunningDetail)deployRunningDetail, stepIds, taskId, clusterId)).collect(Collectors.toList());
        return MultiDeployTaskDetail.builder().detail(this.transferMessageToDetail(clusterRunningDetail.getRunningMessage())).deployTaskDetails(deployTaskDetailVoList).build();
    }

    private TaskDetail transferMessageToDetail(RunningMessage runningMessage) {
        return TaskDetail.builder().status(runningMessage.getStatus() == null ? ResultStatus.WAITED.getKey() : ResultStatus.of(runningMessage.getStatus().toString(), ResultStatus.WAITED)).progress(Double.valueOf(runningMessage.getProgress() == null ? 0.0 : Double.valueOf(runningMessage.getProgress().intValue()))).startTime(runningMessage.getStartTime()).endTime(runningMessage.getEndTime()).build();
    }

    private DeployTaskDetailVo initDeployTaskDetail(DeployRunningDetail deployRunningDetail, List<String> stepIds, String taskId, String clusterId) {
        if (CollectionUtil.isEmpty(stepIds)) {
            return this.initDeployTaskDetail(deployRunningDetail, taskId, clusterId);
        }
        List stepTaskDetailVoList = stepIds.stream().map(deployRunningDetail::getStepRunningDetailById).map(this::initStepTaskDetail).collect(Collectors.toList());
        return DeployTaskDetailVo.builder().deployNodeVo(this.buildDeployNodeVo(deployRunningDetail, taskId, clusterId)).stepTaskDetails(stepTaskDetailVoList).build();
    }

    private DeployTaskDetailVo initDeployTaskDetail(DeployRunningDetail deployRunningDetail, String taskId, String clusterId) {
        List stepTaskDetailVoList = deployRunningDetail.getStepRunningDetails().stream().map(this::initStepTaskDetail).collect(Collectors.toList());
        return DeployTaskDetailVo.builder().deployNodeVo(this.buildDeployNodeVo(deployRunningDetail, taskId, clusterId)).stepTaskDetails(stepTaskDetailVoList).build();
    }

    private DeployNodeVo buildDeployNodeVo(DeployRunningDetail deployRunningDetail, String taskId, String clusterId) {
        DeployNode runningDetailNode = deployRunningDetail.getNode();
        List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(taskId, clusterId);
        DeployNode node = deployNodes.stream().filter(deployNode -> deployNode.getId().equals(runningDetailNode.getId())).findFirst().orElseGet(() -> runningDetailNode);
        DeployNodeVo deployNodeVo = ParseLldUtil.buildDeployNodeVo(node);
        deployNodeVo.setCpuArchitecture(node.getCpuArchitecture());
        deployNodeVo.setStartTime(deployRunningDetail.getRunningMessage().getStartTime());
        deployNodeVo.setEndTime(deployRunningDetail.getRunningMessage().getEndTime());
        return deployNodeVo;
    }

    private StepTaskDetailVo initStepTaskDetail(StepRunningDetail stepRunningDetail) {
        List itemDetailList = stepRunningDetail.getItemRunningDetails().stream().map(this::initItemDetail).collect(Collectors.toList());
        return StepTaskDetailVo.builder().stepId(stepRunningDetail.getStepInfo().getId()).stepName(stepRunningDetail.getStepInfo().getName()).detail(this.transferMessageToDetail(stepRunningDetail.getRunningMessage())).itemDetails(itemDetailList).build();
    }

    private ItemDetail initItemDetail(ItemRunningDetail itemRunningDetail) {
        ItemInfo itemInfo = itemRunningDetail.getItemInfo();
        return ItemDetail.builder().itemConf(ItemConf.builder().id(itemInfo.getId()).name(itemInfo.getName()).build()).runningDetail(itemRunningDetail.getRunningDetail()).build();
    }

    @FitTrust(generic=QueryTaskDetail.class, position="error", id="QueryTaskDetailError")
    public Response<MultiDeployTaskDetail> queryTaskDetailErrorHandle(QueryTaskDetailParam param, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.query.detail.error"));
    }

    @Fitable(generic=QueryDeployNodeDetail.class, id="26421332c9274942b311c0a9eee73104")
    public Response<DeployTaskDetailVo> queryDeployNodeDetail(QueryDetailParam param) {
        try {
            String[] splitValues = ServerUtil.splitTaskIdAndCheck(param.getTaskId());
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(splitValues[0]);
            if (deployTaskManager == null) {
                return this.responseUtil.failed(ResourceUtil.getString((String)"fit.task.query.detail.not.found"), "");
            }
            String devId = param.getDevId();
            String clusterIp = splitValues[1];
            DeployRunningDetail deployNodeRunningDetail = deployTaskManager.getObs().getDeployNodeRunningDetail(splitValues[0], clusterIp, devId);
            List subTaskIds = param.getSubTaskIds();
            this.checkStepDeployed(deployNodeRunningDetail, subTaskIds);
            DeployTaskDetailVo deployTaskDetailVo = this.initDeployTaskDetail(deployNodeRunningDetail, subTaskIds, splitValues[0], clusterIp);
            return this.responseUtil.success(deployTaskDetailVo);
        }
        catch (ToolException | AbstractMethodError e) {
            log.error("query detail of device [{}] error:", (Object)param.getTaskId(), (Object)e);
            throw new FitException("query task detail failed.", e);
        }
    }

    private boolean checkStepDeployed(DeployRunningDetail deployRunningDetail, List<String> stepIds) throws ToolException {
        String unDeployedSteps = stepIds.stream().filter(stepId -> !TaskSumUtil.checkStepDeployed(deployRunningDetail, stepId)).collect(Collectors.joining(","));
        if (!StringUtils.isNULLStr((String)unDeployedSteps)) {
            log.error("unDeployedSteps found :{}", (Object)unDeployedSteps);
            throw new ToolException("fit.query.detail.step.not.deploy", (Object[])new String[]{unDeployedSteps});
        }
        return true;
    }

    @FitTrust(generic=QueryDeployNodeDetail.class, position="error", id="QueryDeployNodeDetailError")
    public Response<DeployTaskDetailVo> nodeDetailErrorHandle(QueryDetailParam param, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getStringWithParams((String)"fit.task.query.device.detail.error", (Object[])new Object[]{param.getDevId()}));
    }

    @Fitable(generic=QueryHardwareEvaluationOverview.class, id="cfc07a18049e4d5dbebc1ddb89792a49")
    public Response<MultiHardwareEvaluationOverview> queryHardwareEvaluationOverview(String taskId) {
        try {
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(taskId);
            if (deployTaskManager == null) {
                log.warn("Deploy task manager not found by id {}. The task may not be deployed.", (Object)taskId);
                return this.responseUtil.success(this.buildEmptyOverview());
            }
            TaskRunningDetail taskRunningDetail = deployTaskManager.getObs().getTaskRunningDetail(taskId);
            if (taskRunningDetail == null) {
                log.warn("Task running detail not found by id {}. The task may not be deployed.", (Object)taskId);
                return this.responseUtil.success(this.buildEmptyOverview());
            }
            return this.responseUtil.success(this.buildMultiHardwareEvaluationOverview(taskRunningDetail));
        }
        catch (ToolException e) {
            log.error("query status of task [{}] error:", (Object)taskId, (Object)e);
            throw new FitException("query task detail failed.", (Throwable)e);
        }
    }

    private MultiHardwareEvaluationOverview buildEmptyOverview() {
        return MultiHardwareEvaluationOverview.builder().progress(Double.valueOf(0.0)).status(ResultStatus.WAITED.getKey()).hardwareEvaluationOverview(Collections.emptyList()).build();
    }

    private MultiHardwareEvaluationOverview buildMultiHardwareEvaluationOverview(TaskRunningDetail taskRunningDetail) {
        List hardwareEvaluationOverviews = taskRunningDetail.getClusterRunningDetails().stream().map(this::buildHardwareEvaluationOverview).collect(Collectors.toList());
        RunningMessage runningMessage = taskRunningDetail.getRunningMessage();
        return MultiHardwareEvaluationOverview.builder().progress(Double.valueOf(runningMessage.getProgress() == null ? 0.0 : Double.valueOf(runningMessage.getProgress().intValue()))).status(runningMessage.getStatus() == null ? ResultStatus.WAITED.getKey() : ResultStatus.of(runningMessage.getStatus().toString(), ResultStatus.WAITED)).hardwareEvaluationOverview(hardwareEvaluationOverviews).build();
    }

    private HardwareEvaluationOverview buildHardwareEvaluationOverview(ClusterRunningDetail clusterRunningDetail) {
        RunningMessage runningMessage = clusterRunningDetail.getRunningMessage();
        ClusterNode clusterNode = clusterRunningDetail.getClusterNode();
        return HardwareEvaluationOverview.builder().model(clusterNode.getModel()).hostName(clusterNode.getName()).version(clusterNode.getVersion()).sn(clusterNode.getSn()).ip(clusterNode.getIp()).progress(Double.valueOf(runningMessage.getProgress() == null ? 0.0 : Double.valueOf(runningMessage.getProgress().intValue()))).status(runningMessage.getStatus() == null ? ResultStatus.WAITED.getKey() : ResultStatus.of(runningMessage.getStatus().toString(), ResultStatus.WAITED)).build();
    }

    @FitTrust(generic=QueryHardwareEvaluationOverview.class, position="error", id="QueryMultiClusterStatusError")
    public Response<DeployTaskDetailVo> queryMultiClusterStatusErrorErrorHandle(String taskId, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.query.detail.error"));
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }
}

