/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.RunningMessage;
import com.huawei.ism.tool.distributeddeploy.fit.entity.StepRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.TaskRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.TaskSumUtil;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.Utils;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryTaskStatistics;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class QueryTaskStatisticsImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryTaskStatisticsImpl.class);
    private static final List<String> NOT_STATISTIC_STEP = Arrays.asList("lit_indicator", "off_indicator");
    @Fit
    TaskContext taskContext;
    @Fit
    ResponseUtil responseUtil;
    @Fit
    NodeManager nodeManager;

    @Fitable(generic=QueryTaskStatistics.class, id="57b6df78e96f4bf9bffa2b00e0b5f8ed")
    public Response<TaskStatistics> queryTaskStatistics(String taskId, String subTaskIds) {
        try {
            String clusterId;
            if (!taskId.contains("_")) {
                return this.queryClusterStatistics(taskId, subTaskIds);
            }
            String[] splitValues = ServerUtil.splitTaskIdAndCheck(taskId);
            String flowTaskId = splitValues[0];
            List<DeployNode> deployNodes = this.nodeManager.queryNodesByTaskId(flowTaskId, clusterId = splitValues[1]).stream().filter(DeployNode::isNeedDeploy).filter(node -> this.taskContext.nodeStarted(taskId, (DeployNode)node)).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(deployNodes)) {
                log.warn("not found deployed nodes by id {}", (Object)taskId);
                return this.responseUtil.success(this.buildEmptyStatistics(0));
            }
            DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(flowTaskId);
            if (deployTaskManager == null) {
                log.warn("not found deploy task by id {}", (Object)flowTaskId);
                return this.responseUtil.success(this.buildEmptyStatistics(deployNodes.size()));
            }
            TaskRunningDetail taskRunningDetail = deployTaskManager.getObs().getTaskRunningDetail(flowTaskId);
            Optional<ClusterRunningDetail> clusterRunningDetailOpt = taskRunningDetail.getClusterRunningDetail(clusterId);
            if (!clusterRunningDetailOpt.isPresent()) {
                log.warn("not found cluster task by id {}", (Object)clusterId);
                return this.responseUtil.success(this.buildEmptyStatistics(deployNodes.size()));
            }
            List<String> stepIds = this.validateAndGetStepIds(subTaskIds);
            if (CollectionUtils.containsAll(stepIds, NOT_STATISTIC_STEP)) {
                deployNodes = this.nodeManager.queryNodesByTaskId(flowTaskId, clusterId).stream().filter(DeployNode::isNeedDeploy).collect(Collectors.toList());
            }
            TaskStatistics taskStatistics = this.buildTaskStatistics(deployNodes, clusterRunningDetailOpt.get(), stepIds);
            return this.responseUtil.success(taskStatistics);
        }
        catch (ToolException | AbstractMethodError e) {
            log.error("query statistics of task [{}] error:", (Object)taskId, (Object)e);
            throw new FitException("query task statistics failed.", e);
        }
    }

    private Response<TaskStatistics> queryClusterStatistics(String taskId, String subTaskIds) throws ToolException {
        List<ClusterNode> clusterNodes = this.nodeManager.queryClusterNodes(taskId);
        if (CollectionUtil.isEmpty(clusterNodes)) {
            log.warn("not found deployed clusters by id {}", (Object)taskId);
            return this.responseUtil.success(this.buildEmptyStatistics(0));
        }
        DeployTaskManager deployTaskManager = this.taskContext.queryDeployTaskManager(taskId);
        if (deployTaskManager == null) {
            log.warn("not found deploy task by id {}", (Object)taskId);
            return this.responseUtil.success(this.buildEmptyStatistics(clusterNodes.size()));
        }
        List<String> stepIds = this.validateAndGetStepIds(subTaskIds);
        TaskRunningDetail taskRunningDetail = deployTaskManager.getObs().getTaskRunningDetail(taskId);
        if (taskRunningDetail == null) {
            log.warn("not found deploy task by id {}", (Object)taskId);
            return this.responseUtil.success(this.buildEmptyStatistics(clusterNodes.size()));
        }
        TaskStatistics taskStatistics = this.buildClusterStatistic(clusterNodes, taskRunningDetail, stepIds);
        return this.responseUtil.success(taskStatistics);
    }

    private TaskStatistics buildClusterStatistic(List<ClusterNode> clusterNodes, TaskRunningDetail taskRunningDetail, List<String> stepIds) {
        int successNum = (int)taskRunningDetail.getClusterRunningDetails().stream().filter(clusterRunningDetail -> this.isStepDeployed((ClusterRunningDetail)clusterRunningDetail, stepIds)).filter(clusterRunningDetail -> this.isNormalNode((ClusterRunningDetail)clusterRunningDetail, stepIds)).count();
        int failNum = (int)taskRunningDetail.getClusterRunningDetails().stream().filter(clusterRunningDetail -> this.isStepDeployed((ClusterRunningDetail)clusterRunningDetail, stepIds)).filter(clusterRunningDetail -> this.isAbnormalNode((ClusterRunningDetail)clusterRunningDetail, stepIds)).count();
        int noExecuted = (int)clusterNodes.stream().filter(this::isWaitedClusterNode).count();
        int runningNum = clusterNodes.size() - successNum - failNum - noExecuted;
        return TaskStatistics.builder().successNum(Integer.valueOf(successNum)).failedNum(Integer.valueOf(failNum)).noExecutedNum(Integer.valueOf(noExecuted)).runningNum(Integer.valueOf(runningNum)).build();
    }

    private boolean isStepDeployed(ClusterRunningDetail clusterRunningDetail, List<String> stepIds) {
        return clusterRunningDetail.getDeployRunningDetails().stream().allMatch(deployRunningDetail -> this.isStepDeployed((DeployRunningDetail)deployRunningDetail, stepIds));
    }

    private boolean isNormalNode(ClusterRunningDetail clusterRunningDetail, List<String> stepIds) {
        return clusterRunningDetail.getDeployRunningDetails().stream().allMatch(deployRunningDetail -> this.isNormalNode((DeployRunningDetail)deployRunningDetail, stepIds));
    }

    private boolean isAbnormalNode(ClusterRunningDetail clusterRunningDetail, List<String> stepIds) {
        return clusterRunningDetail.getDeployRunningDetails().stream().anyMatch(deployRunningDetail -> this.isAbnormalSteps((DeployRunningDetail)deployRunningDetail, stepIds));
    }

    private boolean isWaitedClusterNode(ClusterNode clusterNode) {
        return clusterNode.getNeedDeployNodes().stream().allMatch(this::isWaitedNode);
    }

    private List<String> validateAndGetStepIds(String subTaskIds) throws ToolException {
        if (StringUtils.isNULLStr((String)subTaskIds)) {
            throw new ToolException("fit.task.verify.step.id.empty");
        }
        List<String> subTaskIdList = Arrays.stream(subTaskIds.split(",")).map(String::trim).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(subTaskIdList)) {
            throw new ToolException("fit.task.verify.step.id.empty");
        }
        return subTaskIdList;
    }

    private TaskStatistics buildTaskStatistics(List<DeployNode> deployNodes, ClusterRunningDetail clusterRunningDetail, List<String> stepIds) {
        List needCountStep = stepIds.stream().filter(stepId -> !NOT_STATISTIC_STEP.contains(stepId)).collect(Collectors.toList());
        int successNum = (int)clusterRunningDetail.getDeployRunningDetails().stream().filter(deployRunningDetail -> this.isStepDeployed((DeployRunningDetail)deployRunningDetail, (List<String>)needCountStep)).filter(deployNodeRunningDetail -> this.isAllStepFinished((DeployRunningDetail)deployNodeRunningDetail, needCountStep)).filter(deployNodeRunningDetail -> this.isNormalNode((DeployRunningDetail)deployNodeRunningDetail, (List<String>)needCountStep)).filter(deployNodeRunningDetail -> this.isAllHaveEndTime((DeployRunningDetail)deployNodeRunningDetail, needCountStep)).count();
        int failNum = (int)clusterRunningDetail.getDeployRunningDetails().stream().filter(deployRunningDetail -> this.isStepDeployed((DeployRunningDetail)deployRunningDetail, (List<String>)needCountStep)).filter(deployNodeRunningDetail -> this.isDeployFailed(needCountStep, (DeployRunningDetail)deployNodeRunningDetail)).filter(deployNodeRunningDetail -> this.isAbnormalSteps((DeployRunningDetail)deployNodeRunningDetail, needCountStep)).filter(deployNodeRunningDetail -> this.isAllHaveEndTime((DeployRunningDetail)deployNodeRunningDetail, needCountStep)).count();
        int noExecuted = (int)deployNodes.stream().filter(this::isWaitedNode).count();
        int runningNum = deployNodes.size() - successNum - failNum - noExecuted;
        return TaskStatistics.builder().successNum(Integer.valueOf(successNum)).failedNum(Integer.valueOf(failNum)).noExecutedNum(Integer.valueOf(noExecuted)).runningNum(Integer.valueOf(runningNum)).build();
    }

    private boolean isDeployFailed(List<String> stepIds, DeployRunningDetail nodeRunningDetail) {
        return this.isAllStepFinished(nodeRunningDetail, stepIds) || this.isAnyStepPause(nodeRunningDetail, stepIds);
    }

    private boolean isStepDeployed(DeployRunningDetail deployRunningDetail, List<String> stepIds) {
        return stepIds.stream().allMatch(stepId -> TaskSumUtil.checkStepDeployed(deployRunningDetail, stepId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAllHaveEndTime(DeployRunningDetail deployRunningDetail, List<String> stepIds) {
        if (!Optional.ofNullable(deployRunningDetail.getNode()).map(DeployNode::getDeployTask).filter(task -> !task.isTaskInExecuting()).isPresent()) return false;
        if (!stepIds.stream().map(deployRunningDetail::getStepRunningDetailById).map(StepRunningDetail::getRunningMessage).map(RunningMessage::getEndTime).noneMatch(Utils::isNullStr)) return false;
        return true;
    }

    private boolean isNormalNode(DeployRunningDetail deployRunningDetail, List<String> stepIds) {
        return stepIds.stream().map(deployRunningDetail::getStepRunningDetailById).map(StepRunningDetail::getRunningMessage).allMatch(TaskSumUtil::isNormal);
    }

    private boolean isAllStepFinished(DeployRunningDetail deployRunningDetail, List<String> stepIds) {
        return stepIds.stream().map(deployRunningDetail::getStepRunningDetailById).map(StepRunningDetail::getRunningMessage).map(RunningMessage::getStatus).allMatch(TaskSumUtil::isStepTaskFinish);
    }

    private boolean isAnyStepPause(DeployRunningDetail deployRunningDetail, List<String> stepIds) {
        return stepIds.stream().map(deployRunningDetail::getStepRunningDetailById).map(StepRunningDetail::getRunningMessage).map(RunningMessage::getStatus).anyMatch(TaskSumUtil::isPause);
    }

    private boolean isAbnormalSteps(DeployRunningDetail deployRunningDetail, List<String> stepIds) {
        return stepIds.stream().map(deployRunningDetail::getStepRunningDetailById).map(StepRunningDetail::getRunningMessage).anyMatch(TaskSumUtil::isAbnormal);
    }

    private boolean isWaitedNode(DeployNode deployNode) {
        return TaskSumUtil.isWaited(deployNode.getStatus());
    }

    private TaskStatistics buildEmptyStatistics(int noExecuted) {
        return TaskStatistics.builder().successNum(Integer.valueOf(0)).failedNum(Integer.valueOf(0)).noExecutedNum(Integer.valueOf(noExecuted)).runningNum(Integer.valueOf(0)).build();
    }

    @FitTrust(generic=QueryTaskStatistics.class, position="error", id="QueryTaskStatisticsError")
    public Response<TaskStatistics> queryStatisticsHandle(String taskId, String subTaskIds, FitException exception) {
        return this.responseUtil.handleError(exception, ResourceUtil.getString((String)"fit.task.query.detail.error"));
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }
}

