/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.logic.ssdp.SnMappingIpTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.StartSsdpSearch;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.TaskParams;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class SsdpSearchService {
    private static final Logger log = LoggerFactory.getLogger(SsdpSearchService.class);
    SnMappingIpTask instance = SnMappingIpTask.getInstance();
    @Fit
    NodeManager nodeManager;
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=StartSsdpSearch.class, id="963553a871de4ea49b6403b2b9f4acb4")
    public Response<String> startSsdpSearch(TaskParams taskParams) {
        try {
            String[] splitValues = ServerUtil.splitTaskIdAndCheck(taskParams.getTaskId());
            List deployNodes = this.nodeManager.queryNodesByTaskId(splitValues[0], splitValues[1]).stream().filter(deployNode -> taskParams.getDevIds().contains(deployNode.getIp())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(deployNodes)) {
                throw new ToolException("fit.importFile.confirmCheck.no.Node");
            }
            if (this.instance.isSearching()) {
                throw new ToolException("ssdp.searching.error");
            }
            AsyncExcutor.submit(() -> this.startSearch(deployNodes));
            return this.responseUtil.success(taskParams.getTaskId());
        }
        catch (ToolException e) {
            return this.responseUtil.failed(e.getErrorLocaleDescription());
        }
    }

    private void startSearch(List<DeployNode> deployNodes) {
        deployNodes.forEach(node -> node.getSsdpMatchResult().setStatus(Status.TASK_RUNNING));
        AsyncExcutor.submit(this.instance::mapping);
        while (this.instance.isSearching() || this.hasNodeMatching(deployNodes)) {
            SsdpSearchService.sleepSomeTime();
            deployNodes.stream().filter(node -> node.getSsdpMatchResult().getStatus() != Status.SUCCESSFUL).forEach(this::updateSearchBmc);
        }
        this.instance.printNotMatchedSn2Ip(deployNodes.stream().map(DeployNode::getSn).collect(Collectors.toSet()));
    }

    void updateSearchBmc(DeployNode node) {
        if (this.instance.hadSearchIp(node.getSn())) {
            node.setNowBmcIp(this.instance.getSearchedIp(node.getSn()));
            node.getSsdpMatchResult().setStatus(Status.SUCCESSFUL);
            node.getSsdpMatchResult().setDesc(ResourceUtil.getStringWithParams((String)"ssdp.searching.success", (Object[])new Object[]{node.getNowBmcIp()}));
            return;
        }
        if (this.instance.isSearching()) {
            return;
        }
        node.getSsdpMatchResult().setStatus(Status.FAILED);
        node.getSsdpMatchResult().setDesc(ResourceUtil.getString((String)"local.link.ip.discover.error"));
    }

    private boolean hasNodeMatching(List<DeployNode> deployNodes) {
        return deployNodes.stream().anyMatch(node -> node.getSsdpMatchResult().getStatus() == Status.TASK_RUNNING);
    }

    private static void sleepSomeTime() {
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException e) {
            log.warn("ssdp sleep interrupted", (Throwable)e);
        }
    }
}

