/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TimezoneSceneEnum {
    OS_INSTALL("osInstall", "timezone_zh.json", "timezone_en.json"),
    BMC_TIME_CONFIG("iBmcConfig", "ibmc_timezone_zh.json", "ibmc_timezone_en.json");

    private final String scene;
    private final String zhFile;
    private final String enFile;
    static final Map<String, String> ZH_TIMEZONE_CONFIG_MAP;
    static final Map<String, String> EN_TIMEZONE_CONFIG_MAP;

    public static Map<String, String> getTimezoneConfigFile() {
        return LanguageManager.isEnglish() ? EN_TIMEZONE_CONFIG_MAP : ZH_TIMEZONE_CONFIG_MAP;
    }

    private TimezoneSceneEnum(String scene, String zhFile, String enFile) {
        this.scene = scene;
        this.zhFile = zhFile;
        this.enFile = enFile;
    }

    static {
        ZH_TIMEZONE_CONFIG_MAP = Arrays.stream(TimezoneSceneEnum.values()).collect(Collectors.toMap(sceneEnum -> sceneEnum.scene, sceneEnum -> sceneEnum.zhFile));
        EN_TIMEZONE_CONFIG_MAP = Arrays.stream(TimezoneSceneEnum.values()).collect(Collectors.toMap(sceneEnum -> sceneEnum.scene, sceneEnum -> sceneEnum.enFile));
    }
}

