/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.fit.service.TimezoneSceneEnum;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.system.storage.distribution.GetDeployToolsTimeZone;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class TimezoneServer {
    private static final Logger log = LoggerFactory.getLogger(TimezoneServer.class);
    private static final String TIMEZONE_DIR = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "timezone");
    private final Map<String, String> timezoneStrMap = this.initTimezoneStrMap();

    @Fitable(generic=GetDeployToolsTimeZone.class, id="b07d737e0c0d496eb43ff7583140e5b3")
    public Response<String> getDeployToolsTimeZone(String scene) {
        String timezoneStr = this.timezoneStrMap.getOrDefault(scene, "");
        if (StringUtils.isEmpty((CharSequence)timezoneStr)) {
            return ResponseUtil.failed((Object)ResourceUtil.getString((String)"error.timezone.not.found"));
        }
        return ResponseUtil.success((Object)timezoneStr);
    }

    private Map<String, String> initTimezoneStrMap() {
        return TimezoneSceneEnum.getTimezoneConfigFile().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.parseTimezoneConfigFile((String)entry.getValue())));
    }

    private String parseTimezoneConfigFile(String fileName) {
        try {
            String jsonFilePath = String.join((CharSequence)File.separator, TIMEZONE_DIR, fileName);
            File jsonFile = new File(new File(jsonFilePath).getCanonicalPath());
            String timezone = FileUtils.readFileToString((File)jsonFile, (String)StandardCharsets.UTF_8.name());
            log.info("init timezone config files. size={}.", (Object)timezone.length());
            return timezone;
        }
        catch (IOException e) {
            log.error("Failed to read the time zone information.", (Throwable)e);
            return "";
        }
    }
}

