/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.logic.config.CustomVersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.PlatformStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateVersionMapping;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateVersionMappingParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class VersionMappingImpl {
    private static final Logger log = LoggerFactory.getLogger(VersionMappingImpl.class);
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=UpdateVersionMapping.class, id="edff59dd3524495e89f87a6060a62175")
    public Response<ParseDetail> updateVersionMapping(UpdateVersionMappingParam param) {
        try {
            ServerUtil.checkPathValid(param.getFilePath());
            Map<String, Map<String, PlatformStrategy>> strategyMap = CustomVersionMappingStrategy.buildStrategy(param.getFilePath(), param.getSelectVersion());
            String key = StringUtils.isNULLStr(param.getClusterIp()) ? param.getTaskId() : param.getTaskId().concat(param.getClusterIp());
            CustomVersionMappingStrategy.updateStrategy(key, strategyMap);
            return this.responseUtil.success(null);
        }
        catch (ImportFileException e) {
            ParseDetail detail = ParseDetail.builder().errMsgs(ParseLldUtil.transferToErrorVo(e.getErrDatas())).build();
            return this.responseUtil.failed(detail);
        }
        catch (ToolException e) {
            log.error("update version mapping error", (Throwable)e);
            return this.responseUtil.failed(e.getErrorLocaleDescription(), "");
        }
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

