/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service.bmc.impl;

import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.BmcConfigVO;
import com.huawei.ism.tool.distributeddeploy.fit.entity.UserAccountVO;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.QueryBmcInfoService;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.redfish.impl.AlarmLogService;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.redfish.impl.LldpService;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.redfish.impl.TimezoneService;
import com.huawei.ism.tool.distributeddeploy.fit.service.bmc.redfish.impl.UserAccountService;
import com.huawei.ism.tool.distributeddeploy.fit.util.RedfishUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.uMate.common.rest.RedfishConnestion;
import java.util.List;

@FitableSuite
public class QueryBmcInfoServiceImpl
implements QueryBmcInfoService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BmcConfigVO query(DeployNode deployNode) throws ToolException {
        RedfishConnestion redfishConnestion = this.buildRedfishConnection(deployNode);
        try {
            BmcConfigVO bmcConfigVO = new BmcConfigVO();
            bmcConfigVO.setAlarmService(new AlarmLogService().queryBmcData(redfishConnestion));
            bmcConfigVO.setTimezone(new TimezoneService().queryBmcData(redfishConnestion));
            bmcConfigVO.setLldpEnable(new LldpService().queryBmcData(redfishConnestion));
            this.setUserAccounts(redfishConnestion, bmcConfigVO);
            BmcConfigVO bmcConfigVO2 = bmcConfigVO;
            return bmcConfigVO2;
        }
        finally {
            redfishConnestion.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryCpuArchitecture(DeployNode deployNode) throws ToolException {
        RedfishConnestion connection = this.buildRedfishConnection(deployNode);
        try {
            String string = RedfishUtil.getCpuArchitecture(connection);
            return string;
        }
        finally {
            connection.release();
        }
    }

    private void setUserAccounts(RedfishConnestion redfishConnestion, BmcConfigVO bmcConfigVO) {
        UserAccountService userAccountService = new UserAccountService();
        bmcConfigVO.setUserAccounts((List<UserAccountVO>)userAccountService.queryBmcData(redfishConnestion));
        bmcConfigVO.setNeedSetFirstLoginPolicy(userAccountService.isNeedFirstLoginPolicy(redfishConnestion));
    }

    private RedfishConnestion buildRedfishConnection(DeployNode node) throws ToolException {
        RedfishConnestion redfishConnestion = new RedfishConnestion(node.getIp(), null, node.getBmcUser().getUserName(), node.getBmcUser().getOriginPassword());
        if (!redfishConnestion.connect(true)) {
            redfishConnestion = this.tryNewPassword(node);
        }
        return redfishConnestion;
    }

    private RedfishConnestion tryNewPassword(DeployNode node) throws ToolException {
        RedfishConnestion redfishConnestion = new RedfishConnestion(node.getIp(), null, node.getBmcUser().getUserName(), node.getBmcUser().getNewPassword());
        if (!redfishConnestion.connect(true)) {
            throw new ToolException("connection.redfish.failed", true);
        }
        node.getBmcUser().setOriginPassword(node.getBmcUser().getNewPassword());
        return redfishConnestion;
    }
}

