/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service.lld;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.User;
import com.huawei.ism.tool.distributeddeploy.fit.common.ExpansionManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.NodeManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.TaskContext;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParseFactory;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParser;
import com.huawei.ism.tool.distributeddeploy.fit.service.ParseExpansionImpl;
import com.huawei.ism.tool.distributeddeploy.fit.service.lld.SceneEnum;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.DeployFileParseService;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.service.task.DeployTaskManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ParseLldTemplateByType;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseErrorRow;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ParseLldTemplate;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ParseProductInfo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.entity.DeviceInfo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.entity.DeviceInfoData;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.entity.ParseExcelParam;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.AuthStatus;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionConfig;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryDevice;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class LldParserImpl {
    private static final Logger log = LoggerFactory.getLogger(LldParserImpl.class);
    @Fit(alias="cacheServer\u7684\u5b9e\u73b0")
    CacheServer cacheServer;
    @Fit
    NodeManager nodeManager;
    @Fit
    ResponseUtil responseUtil;
    @Fit
    LldParseFactory lldParseFactory;
    @Fit
    TaskContext taskContext;
    @Fit
    ParseExpansionImpl parseExpansion;
    @Fit
    ExpansionManager expansionManager;
    @Fit(alias="queryDevice\u7684\u5b9e\u73b0")
    QueryDevice queryDevice;

    @Fitable(generic=ParseLldTemplate.class, id="4181d30ecc2f440790aad38e7ad9bb68")
    public Response<String> parseLldTemplate(String taskId, String lldFilePath, String scene) {
        try {
            if (!taskId.contains("_")) {
                return this.parseClusterNodes(taskId, lldFilePath, scene);
            }
            this.validator(taskId, lldFilePath, scene);
            ObserverManager.getInstance().setCurrentScene(scene);
            Map<String, List<Map<String, Attribute>>> fileData = DeployFileParseService.doParsing(new File(lldFilePath), "config/wizard/deployFileParseStrategy.xml");
            ClusterNode clusterNode = this.doParse(fileData, scene);
            clusterNode.getDeployNodes().forEach(deployNode -> deployNode.setSn(StringEscapeUtils.escapeHtml4((String)deployNode.getSn())));
            this.updateClusterModel(taskId, scene, clusterNode);
            String[] split = taskId.split("_");
            this.checkClusterIp(clusterNode, split[1]);
            clusterNode.setId(split[1]);
            this.registerDeployNodes(split[0], clusterNode);
            if (ObserverManager.getInstance().isExpansionScene() && "check".equals(scene)) {
                this.parseExpansion(fileData, split[0], clusterNode.getId());
            }
            this.cacheServer(split[0], clusterNode.getDeployNodes(), scene);
            return this.responseUtil.success(clusterNode.getIp());
        }
        catch (ToolException e) {
            log.error("Parse lld file {} in scene {} error.", new Object[]{lldFilePath, scene, e});
            throw new FitException("parse lld file error.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("unknown error happened when parse lld template.", (Throwable)e);
            throw new FitException("parse lld file error.", (Throwable)e);
        }
    }

    @Fitable(generic=ParseLldTemplateByType.class, id="ace3b462e3b64c1d8985cc588015a822")
    public Response<?> parseLldTemplateByType(String taskId, String lldFilePath, String scene, String devType) {
        try {
            Response<String> parseDetailResponse = this.parseLldTemplate(taskId, lldFilePath, scene);
            if ("FusionCube".equals(devType)) {
                if (taskId.contains("_")) {
                    String[] split = taskId.split("_");
                    this.nodeManager.queryClusterNodes(split[0]).forEach(deployNode -> deployNode.setModel(devType));
                } else {
                    this.nodeManager.queryClusterNodes(taskId).forEach(deployNode -> deployNode.setModel(devType));
                }
            }
            return parseDetailResponse;
        }
        catch (FitException e) {
            return this.getParseDetailResponse(e);
        }
    }

    private void updateClusterModel(String taskId, String scene, ClusterNode clusterNode) {
        ((MultiStroageNodeDto)this.queryDevice.process(taskId, scene).getData()).getStroageNodeDto().stream().filter(node -> node.getIp().equals(clusterNode.getIp())).findFirst().ifPresent(node -> clusterNode.setModel(node.getProductModel()));
    }

    private void cacheServer(String taskId, List<DeployNode> deployNodes, String scene) {
        if (!SceneEnum.SCENE_ID_HARDWARE_CONFIG.getScene().equals(scene) && !SceneEnum.isSupportSimplifyScene(scene)) {
            return;
        }
        deployNodes.stream().map(node -> this.buildServer((DeployNode)node, taskId)).forEach(server -> this.cacheServer.process(server));
    }

    private Server buildServer(DeployNode node, String taskId) {
        Server server = Server.builder().loginUser(this.buildLoginUser(node.getBmcUser())).osUser(this.buildLoginUser(node.getOsUser())).osRootUser(this.buildRootLoginUser(node.getOsRootUser())).bmcIp(node.getIp()).osIp(node.getOsIp()).model(node.getDevType()).clusterId(taskId).productName(node.getNodeName()).uid(String.join((CharSequence)"_", taskId, node.getIp())).bmcAuthStatus(AuthStatus.builder().status("unAuth").description("").build()).osAuthStatus(AuthStatus.builder().status("unAuth").description("").build()).sn(node.getSn()).cpuArchitecture("--").build();
        node.setServer(server);
        return server;
    }

    private LoginUser buildRootLoginUser(User user) {
        if (Objects.isNull(user)) {
            return null;
        }
        return LoginUser.builder().name(user.getUserName()).pwd(AESEncrypt.encrypt(Base64EncodeUtils.encode((String)user.getOriginPassword()))).newPwd(AESEncrypt.encrypt(Base64EncodeUtils.encode((String)user.getNewPassword()))).build();
    }

    private LoginUser buildLoginUser(User user) {
        if (Objects.isNull(user)) {
            return null;
        }
        return LoginUser.builder().name(user.getUserName()).pwd(user.getEncrtyptOriginPassword()).newPwd(user.getEncrtyptNewPassword()).build();
    }

    private void parseExpansion(Map<String, List<Map<String, Attribute>>> fileData, String taskId, String clusterId) throws ToolException {
        List<ExpansionConfig> expansionConfigs = this.parseExpansion.parseExpansion(fileData);
        String devId = taskId + "_" + clusterId;
        this.expansionManager.refreshExpansionByDevId(devId, expansionConfigs);
    }

    private ClusterNode doParse(Map<String, List<Map<String, Attribute>>> fileData, String scene) throws ToolException, ImportFileException {
        LldParser lldParser;
        ClusterNode clusterNode;
        List<DeployNode> deployNodes;
        if (!SceneEnum.isSupportSimplifyScene(scene)) {
            String templateScene = ParseLldUtil.parseSceneOfTemplate(fileData);
            ObserverManager.getInstance().setTemplateScene(templateScene);
        }
        if ((deployNodes = LldParserImpl.getDeployNodeByScene(scene, clusterNode = (lldParser = this.lldParseFactory.getLldParser(scene)).buildDevNode(fileData))).isEmpty()) {
            log.error("the import device of {} is empty", (Object)clusterNode.getIp());
            throw new ToolException(this.getNoticeInfo());
        }
        if (deployNodes.size() > ToolConfig.getMaxNodeNum()) {
            log.error("the import device of {} is beyond {}", (Object)clusterNode.getIp(), (Object)ToolConfig.getMaxNodeNum());
            throw new ToolException("importFile.node.num.waring", (Object[])new Integer[]{ToolConfig.getMaxNodeNum(), deployNodes.size()});
        }
        return clusterNode;
    }

    @NotNull
    private String getNoticeInfo() {
        return ObserverManager.getInstance().isExpansionScene() ? "fit.importFile.confirmCheck.emptyNode" : "fit.importFile.confirmCheck.no.Node";
    }

    private static List<DeployNode> getDeployNodeByScene(String scene, ClusterNode clusterNode) {
        if ("full".equals(scene)) {
            return clusterNode.getNeedDeployNodes();
        }
        return clusterNode.getDeployNodes();
    }

    private boolean checkClusterIp(ClusterNode clusterNode, String clusterId) throws ToolException {
        if ("default".equals(clusterId)) {
            return true;
        }
        if (!clusterId.equals(clusterNode.getIp())) {
            log.error("the select device is {} while that of template is {}", (Object)clusterId, (Object)clusterNode.getId());
            throw new ToolException("fit.importfile.verify.cluster.id.not.same");
        }
        return true;
    }

    void validator(String taskId, String lldFilePath, String scene) throws ToolException {
        String[] split = ServerUtil.splitTaskIdAndCheck(taskId);
        ServerUtil.checkPathValid(lldFilePath);
        if (SceneEnum.isSceneNotSupport(scene)) {
            log.error("the scene {} is illegal.", (Object)scene);
            throw new ToolException("fit.importfile.verify.scene.illegal");
        }
        String runningNodes = this.nodeManager.queryNodesByTaskId(split[0], split[1]).stream().filter(deployNode -> !deployNode.getDeployTask().isFinish()).map(DeployNode::getIp).collect(Collectors.joining(","));
        if (!StringUtils.isNULLStr(runningNodes)) {
            log.error("the nodes [{}] of {} is running.", (Object)runningNodes, (Object)split[1]);
            throw new ToolException("fit.task.verify.device.running", (Object[])new String[]{runningNodes});
        }
    }

    private void registerDeployNodes(String taskId, ClusterNode clusterNode) {
        this.nodeManager.refreshNodesByTaskId(taskId, clusterNode);
        DeployTaskManager deployTaskManager = this.taskContext.getDeployTaskManager(taskId);
        deployTaskManager.getObs().resetDevUIData(taskId, clusterNode);
    }

    @FitTrust(generic=ParseLldTemplate.class, position="error", id="LldParserImplError")
    public Response<ParseDetail> errorHandle(String taskId, String lldFilePath, String scene, FitException exception) {
        return this.getParseDetailResponse(exception);
    }

    @FitTrust(generic=ParseProductInfo.class, position="error", id="ParseProductInfoError")
    public Response<ParseDetail> errorHandle(ParseExcelParam parseExcelParam, FitException exception) {
        return this.getParseDetailResponse(exception);
    }

    private Response<ParseDetail> getParseDetailResponse(FitException exception) {
        log.error("start to handle lld parse error:", (Throwable)exception);
        Throwable throwable = exception.getCause();
        if (throwable instanceof ImportFileException) {
            ImportFileException importError = (ImportFileException)throwable;
            ParseDetail detail = ParseDetail.builder().errMsgs(ParseLldUtil.transferToErrorVo(importError.getErrDatas())).build();
            return this.responseUtil.failed(detail);
        }
        if (throwable instanceof ToolException) {
            ToolException toolException = (ToolException)throwable;
            return this.responseUtil.failed(toolException.getErrorLocaleDescription(), "");
        }
        return this.responseUtil.failed(ResourceUtil.getString((String)"importFile.parse.exception"), "");
    }

    private Response<String> parseClusterNodes(String taskId, String lldFilePath, String scene) throws ToolException, ImportFileException {
        ServerUtil.checkPathValid(lldFilePath);
        if (SceneEnum.isSceneNotSupport(scene)) {
            log.error("the scene {} is illegal.", (Object)scene);
            throw new ToolException("fit.importfile.verify.scene.illegal");
        }
        ObserverManager.getInstance().setCurrentScene(scene);
        Map<String, List<Map<String, Attribute>>> fileData = DeployFileParseService.doParsing(new File(lldFilePath), "config/wizard/deployFileParseStrategy.xml");
        ClusterNode clusterNode = this.doParse(fileData, scene);
        if (StringUtils.isNULLStr(clusterNode.getIp())) {
            throw new ToolException("fit.task.verify.cluster.id.not.exist");
        }
        this.whetherContainsRunningNode(taskId, clusterNode.getIp());
        this.registerDeployNodes(taskId, clusterNode);
        if (ObserverManager.getInstance().isExpansionScene() && "check".equals(scene)) {
            this.parseExpansion(fileData, taskId, clusterNode.getIp());
        }
        return this.responseUtil.success(clusterNode.getIp());
    }

    private boolean whetherContainsRunningNode(String taskId, String clusterId) throws ToolException {
        String runningNodes = this.nodeManager.queryNodesByTaskId(taskId, clusterId).stream().filter(deployNode -> !deployNode.getDeployTask().isFinish()).map(DeployNode::getIp).collect(Collectors.joining(","));
        if (!StringUtils.isNULLStr(runningNodes)) {
            log.error("the nodes [{}] of {} is running.", (Object)runningNodes, (Object)clusterId);
            throw new ToolException("fit.task.verify.device.running", (Object[])new String[]{runningNodes});
        }
        return true;
    }

    @Fitable(generic=ParseProductInfo.class, id="a165e48ff8804748bbee2e39ebe8a3bf")
    public Response<DeviceInfoData> parseProductInfo(ParseExcelParam parseExcelParam) {
        try {
            this.validator(parseExcelParam.getTaskId(), parseExcelParam.getFilePath(), parseExcelParam.getScene());
            Map<String, List<Map<String, Attribute>>> excelData = DeployFileParseService.doParsing(new File(parseExcelParam.getFilePath()), "config/wizard/productInfoFileParseStrategy.xml");
            DeviceInfoData result = this.parseDataParam(excelData, parseExcelParam.getDevUids());
            if (Objects.nonNull(result.getParseDetail())) {
                return this.responseUtil.warn(result);
            }
            return this.responseUtil.success(result);
        }
        catch (ToolException e) {
            log.error("Parse lld file {} in scene {} error.", new Object[]{parseExcelParam.getFilePath(), parseExcelParam.getScene(), e});
            throw new FitException("parse lld file error.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("unknown error happened when parse lld template.", (Throwable)e);
            throw new FitException("parse lld file error.", (Throwable)e);
        }
    }

    @NotNull
    private DeviceInfoData parseDataParam(Map<String, List<Map<String, Attribute>>> excelData, List<String> bmcIps) {
        List<Map<String, Attribute>> deviceInfoAttribute = excelData.get("deviceInfo");
        List deviceInfos = deviceInfoAttribute.stream().filter(attribute -> this.isNodeChosen((Map<String, Attribute>)attribute, bmcIps)).map(this::buildDeviceInfo).collect(Collectors.toList());
        DeviceInfoData deviceInfo = DeviceInfoData.builder().deviceInfo(deviceInfos).build();
        List<ParseErrorRow> errorRows = this.buildNotChooseNodeError(bmcIps, deviceInfoAttribute);
        errorRows.addAll(this.buildConfigNodeNotFoundError(bmcIps, deviceInfoAttribute));
        if (CollectionUtils.isNotEmpty(errorRows)) {
            deviceInfo.setParseDetail(ParseDetail.builder().errMsgs(errorRows).build());
        }
        return deviceInfo;
    }

    @NotNull
    private List<ParseErrorRow> buildConfigNodeNotFoundError(List<String> bmcIps, List<Map<String, Attribute>> deviceInfoAttribute) {
        return bmcIps.stream().filter(ip -> !this.isConfigNodeFound((String)ip, deviceInfoAttribute)).map(this::buildNodeNotFoundErrorRow).collect(Collectors.toList());
    }

    private ParseErrorRow buildNodeNotFoundErrorRow(String ip) {
        return ParseErrorRow.builder().position(ResourceUtil.getStringWithParams((String)"choose.node", (Object[])new Object[]{ip})).description(ResourceUtil.getStringWithParams((String)"config.not.found.error", (Object[])new Object[0])).build();
    }

    private boolean isConfigNodeFound(String ip, List<Map<String, Attribute>> deviceInfoAttribute) {
        return deviceInfoAttribute.stream().anyMatch(attribute -> ((Attribute)attribute.get("bmcIp")).getValue().equals(ip));
    }

    @NotNull
    private List<ParseErrorRow> buildNotChooseNodeError(List<String> bmcIps, List<Map<String, Attribute>> deviceInfoAttribute) {
        return deviceInfoAttribute.stream().filter(attribute -> !this.isNodeChosen((Map<String, Attribute>)attribute, bmcIps)).map(this::buildErrorRow).collect(Collectors.toList());
    }

    private ParseErrorRow buildErrorRow(Map<String, Attribute> deviceInfoAttribute) {
        return ParseErrorRow.builder().position(ParseLldUtil.buildPositionMsg(deviceInfoAttribute)).description(ResourceUtil.getStringWithParams((String)"node.not.choose", (Object[])new Object[]{deviceInfoAttribute.get("bmcIp").getValue()})).build();
    }

    private boolean isNodeChosen(Map<String, Attribute> attribute, List<String> bmcIps) {
        return bmcIps.contains(attribute.get("bmcIp").getValue());
    }

    private DeviceInfo buildDeviceInfo(Map<String, Attribute> deviceInfoAttribute) {
        return DeviceInfo.builder().bmcIp(deviceInfoAttribute.get("bmcIp").getValue()).assetTag(deviceInfoAttribute.get("assetTag").getValue()).location(deviceInfoAttribute.get("location").getValue()).build();
    }

    public void setCacheServer(CacheServer cacheServer) {
        this.cacheServer = cacheServer;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }

    public void setLldParseFactory(LldParseFactory lldParseFactory) {
        this.lldParseFactory = lldParseFactory;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setParseExpansion(ParseExpansionImpl parseExpansion) {
        this.parseExpansion = parseExpansion;
    }

    public void setExpansionManager(ExpansionManager expansionManager) {
        this.expansionManager = expansionManager;
    }

    public void setQueryDevice(QueryDevice queryDevice) {
        this.queryDevice = queryDevice;
    }
}

