/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service.lld;

import com.huawei.ism.tool.distributeddeploy.fit.factory.AddServerDriverSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.AddServerFirmwareSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.AddServerSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.BmcIpSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.CheckSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.FullSceneParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.LldParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.SystemInstallParser;
import com.huawei.ism.tool.distributeddeploy.fit.factory.VersionMappingCheckParser;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.util.Arrays;
import java.util.Optional;

public enum SceneEnum {
    CHECK("check", CheckSceneParser.class, "DeployTemplate%s.xlsx", "/config/template/DeployTemplate_%s.xlsx", false),
    VERSION_MAPPING_CHECK("versionMappingCheck", VersionMappingCheckParser.class, "VersionMappingCheckTemplate%s.xlsx", "/config/template/VersionMappingCheckTemplate_%s.xlsx", true),
    SCENE_ID_BMCIP("bmcIp", BmcIpSceneParser.class, "BmcIpConfigTemplate%s.xlsx", "/config/template/BmcIpConfigTemplate_%s.xlsx", true),
    SCENE_ID_FULL("full", FullSceneParser.class, "DeployTemplate%s.xlsx", "/config/template/DeployTemplate_%s.xlsx", false),
    BMC_CONFIG("bmc_config", CheckSceneParser.class, "ServerTemplate%s.xlsx", "/config/template/ServerTemplate_%s.xlsx", false),
    SCENE_ID_HARDWARE_CONFIG("hardware_config", CheckSceneParser.class, "HardwareConfigTemplate%s.xlsx", "/config/template/HardwareSimpleTemplate_%s.xlsx", true),
    ADD_SERVER("addServer", AddServerSceneParser.class, "ServerTemplate%s.xlsx", "/config/template/ServerTemplate_%s.xlsx", true),
    ADD_SERVER_FIRMWARE("addServer_firmware", AddServerFirmwareSceneParser.class, "ServerTemplate%s.xlsx", "/config/template/ServerTemplate_Firmware_%s.xlsx", true),
    ADD_SERVER_DRIVER("addServer_driver", AddServerDriverSceneParser.class, "ServerTemplate%s.xlsx", "/config/template/ServerTemplate_Driver_%s.xlsx", true),
    SYSTEM_INSTALLATION("os_installation", SystemInstallParser.class, "SystemInstallTemplate%s.xlsx", "/config/template/SystemInstallTemplate_%s.xlsx", true),
    EXPANSION_CHECK("expansion_check", CheckSceneParser.class, "ExpansionTemplate%s.xlsx", "/config/template/ExpansionEvaluationTemplate_%s.xlsx", false),
    EXPANSION_CHECK_CUBE("expansion_check_cube", CheckSceneParser.class, "ExpansionTemplate%s.xlsx", "/config/template/CubeExpansionEvaluationTemplate_%s.xlsx", false),
    PRODUCT_INFO_CHECK("product_info_config", CheckSceneParser.class, "DeviceInfoTemplate%s.xlsx", "/config/template/DeviceInfoTemplate_%s.xlsx", false),
    SWITCH_LOGIN("switch_check", CheckSceneParser.class, "SwitchInfoTemplate%s.xlsx", "/config/template/SwitchInfoTemplate_%s.xlsx", false);

    private final String scene;
    private final Class<? extends LldParser> lldParserClass;
    private final String exportName;
    private final String templatePath;
    private final boolean isSupportSimplifyScene;

    public String getTemplatePath() {
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            return String.format(this.templatePath, "en");
        }
        return String.format(this.templatePath, "zh");
    }

    public static boolean isSceneNotSupport(String scene) {
        return Arrays.stream(SceneEnum.values()).noneMatch(sceneEnum -> sceneEnum.getScene().equals(scene));
    }

    public static Optional<SceneEnum> of(String scene) {
        return Arrays.stream(SceneEnum.values()).filter(sceneEnum -> sceneEnum.getScene().equals(scene)).findFirst();
    }

    public static SceneEnum ofDefault(String scene) {
        return SceneEnum.of(scene).orElse(SCENE_ID_FULL);
    }

    public static boolean isSupportSimplifyScene(String scene) {
        return SceneEnum.ofDefault((String)scene).isSupportSimplifyScene;
    }

    private SceneEnum(String scene, Class<? extends LldParser> lldParserClass, String exportName, String templatePath, boolean isSupportSimplifyScene) {
        this.scene = scene;
        this.lldParserClass = lldParserClass;
        this.exportName = exportName;
        this.templatePath = templatePath;
        this.isSupportSimplifyScene = isSupportSimplifyScene;
    }

    public String getScene() {
        return this.scene;
    }

    public Class<? extends LldParser> getLldParserClass() {
        return this.lldParserClass;
    }

    public String getExportName() {
        return this.exportName;
    }

    public boolean isSupportSimplifyScene() {
        return this.isSupportSimplifyScene;
    }
}

