/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.service.lld;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ResponseUtil;
import com.huawei.ism.tool.distributeddeploy.fit.util.ServerUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.DeployFileParseService;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ParseSwitchLoginExcel;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseErrorRow;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchLoginInfo;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchLoginParam;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class SwitchInfoParseImpl {
    private static final Logger log = LoggerFactory.getLogger(SwitchInfoParseImpl.class);
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=ParseSwitchLoginExcel.class, id="47d6906515f14b2586beba7a0ab79df7")
    public Response<SwitchLoginParam> parseSwitchLoginExcel(String taskId, String floatIp, String filePath) {
        try {
            ServerUtil.checkPathValid(filePath);
            Map<String, List<Map<String, Attribute>>> excelData = DeployFileParseService.doParsing(new File(filePath), "config/wizard/switchInfoFileParseStrategy.xml");
            List<SwitchLoginInfo> switchLoginInfos = this.parseLoginInfo(excelData);
            if (CollectionUtil.isEmpty(switchLoginInfos)) {
                return this.responseUtil.failed(ResourceUtil.getString((String)"import.file.empty"), "");
            }
            return this.responseUtil.success(SwitchLoginParam.builder().taskId(taskId).floatIp(floatIp).switchLoginInfos(switchLoginInfos).build());
        }
        catch (ToolException toolException) {
            log.error("valid param failed ", (Throwable)toolException);
            return this.responseUtil.failed(toolException.getDes(), "");
        }
        catch (ImportFileException exception) {
            log.error("import file failed", (Throwable)exception);
            return this.buildImportFailResponse(exception);
        }
    }

    @NotNull
    private List<SwitchLoginInfo> parseLoginInfo(Map<String, List<Map<String, Attribute>>> excelData) {
        if (MapUtils.isEmpty(excelData)) {
            return Collections.emptyList();
        }
        return excelData.getOrDefault("switchInfo", Collections.emptyList()).stream().map(this::buildSwitchInfo).collect(Collectors.toList());
    }

    private SwitchLoginInfo buildSwitchInfo(Map<String, Attribute> switchInfo) {
        return SwitchLoginInfo.builder().ip(switchInfo.get("switchIp").getValue()).username(switchInfo.get("username").getValue()).password(switchInfo.get("password").getValue()).build();
    }

    private Response<SwitchLoginParam> buildImportFailResponse(ImportFileException exception) {
        ParseDetail detail = ParseDetail.builder().errMsgs(ParseLldUtil.transferToErrorVo(exception.getErrDatas())).build();
        return this.responseUtil.failed(detail.getErrMsgs().stream().map(this::buildOneLineMsg).collect(Collectors.joining(System.lineSeparator())), "");
    }

    private String buildOneLineMsg(ParseErrorRow msg) {
        return String.join((CharSequence)"->", msg.getPosition(), msg.getDescription());
    }
}

