/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.util;

import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.fit.common.ExpansionManager;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ResultStatus;
import com.huawei.ism.tool.distributeddeploy.fit.util.TaskSumUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.OsIpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.logic.utils.ExcelUtil;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.drop.entity.storage.entity.StorageNodeDto;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.DeployNodeVo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.IpConfig;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseErrorRow;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.SsdpMatchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParseLldUtil {
    public static final Integer PARSE_ERROR_MSG_LENGTH = 2;
    public static final Integer PARSE_ERROR_POSITION_INDEX = 0;
    public static final Integer PARSE_ERROR_DES_INDEX = 1;
    private static final String YES = "Y";
    private static final String EMPTY = "";

    public static List<ParseErrorRow> transferToErrorVo(List<ArrayList<Object>> errDatas) {
        return errDatas.stream().filter(errData -> errData.size() == PARSE_ERROR_MSG_LENGTH.intValue()).map(errData -> ParseErrorRow.builder().position(errData.get(PARSE_ERROR_POSITION_INDEX).toString()).description(errData.get(PARSE_ERROR_DES_INDEX).toString()).build()).collect(Collectors.toList());
    }

    private static boolean isNewAddNode(Map<String, Attribute> nodeData) {
        Attribute isNew = nodeData.getOrDefault("isNewNode", new Attribute(new Attribute.Location(EMPTY, 0, 0), YES));
        return YES.equals(isNew.getValue());
    }

    public static List<Map<String, Attribute>> integrateNodes(Map<String, List<Map<String, Attribute>>> fileDatas) {
        if (ObserverManager.getInstance().isExpansionScene()) {
            return ParseLldUtil.buildStorageNodes(fileDatas, "addNode", "addNodeDS");
        }
        return ParseLldUtil.buildStorageNodes(fileDatas, "storageNode", "storageNodeDS");
    }

    private static List<Map<String, Attribute>> buildStorageNodes(Map<String, List<Map<String, Attribute>>> fileDatas, String masterSheetName, String dsSheetName) {
        List<Map<String, Attribute>> storageNodes = fileDatas.getOrDefault(masterSheetName, Collections.emptyList());
        List<Map<String, Attribute>> dSInfo = fileDatas.get(dsSheetName);
        if (CollectionUtil.isEmpty(dSInfo)) {
            return storageNodes;
        }
        Map<String, Map> masterBmcInfoMap = storageNodes.stream().collect(Collectors.toMap(node -> ((Attribute)node.get("bmcIp")).getValue(), node -> node));
        dSInfo.forEach(info -> {
            String dSIp = ((Attribute)info.get("bmcIp")).getValue();
            if (masterBmcInfoMap.containsKey(dSIp)) {
                Map masterNodeInfo = (Map)masterBmcInfoMap.get(dSIp);
                masterNodeInfo.putAll(info);
            }
        });
        return storageNodes;
    }

    public static void integrateDataClusterNode(Map<String, Attribute> nodeData, List<Map<String, Attribute>> dsInfo) {
        String sn = nodeData.get("sn").getValue();
        Iterator<Map<String, Attribute>> iterator = dsInfo.iterator();
        while (iterator.hasNext()) {
            Map<String, Attribute> info = iterator.next();
            String dsIndex = ParseLldUtil.buildDataClusterIndex(info);
            if (!sn.equals(dsIndex)) continue;
            nodeData.putAll(info);
            iterator.remove();
            break;
        }
    }

    public static String buildDataClusterIndex(Map<String, Attribute> oneRow) {
        return oneRow.get("sn").getValue().trim() + "-" + oneRow.get("slotId").getValue().trim();
    }

    public static void parseAppendFiles(DeployNode deployNode, Map<String, Attribute> nodeData) {
        deployNode.setCabinetId(nodeData.get("cabinetId").getValue());
        deployNode.setSubrackId(nodeData.get("subrackId").getValue());
        deployNode.setSlotId(nodeData.get("slotId").getValue());
        deployNode.setFrontIp(nodeData.get("frontIp").getValue());
        deployNode.setBackIp(nodeData.get("backIp").getValue());
        deployNode.setNeedDeploy(ParseLldUtil.isNewAddNode(nodeData));
    }

    public static DeployNodeVo buildDeployNodeVo(DeployNode node) {
        DeployNodeVo deployNodeVo = new DeployNodeVo();
        deployNodeVo.setHostName(node.getNodeName());
        deployNodeVo.setModel(node.getDevType());
        deployNodeVo.setSn(node.getSn());
        deployNodeVo.setProgress(Double.valueOf(node.getDeployTask().getProgress()));
        deployNodeVo.setStatus(ResultStatus.of(node.getStatus().toString(), ResultStatus.WAITED));
        deployNodeVo.setIndicatorStatus(ResultStatus.of(node.getIndicatorStatus().toString(), ResultStatus.MANUAL_CONFIRM));
        deployNodeVo.setSsdpMatchResult(SsdpMatchResult.builder().status(node.getSsdpMatchResult().getStatus().toString()).desc(node.getSsdpMatchResult().getDesc()).build());
        ParseLldUtil.transferOsIp(deployNodeVo, node);
        ParseLldUtil.transferBmcIp(deployNodeVo, node);
        ParseLldUtil.transferAppendFields(deployNodeVo, node);
        return deployNodeVo;
    }

    private static boolean isIndicatorTask(DeployNode node) {
        List<StepTask> subTasks = node.getDeployTask().getSubTasks();
        if (CollectionUtil.isEmpty(subTasks)) {
            return false;
        }
        List<ItemTask> itemTasks = subTasks.get(0).getSubTasks();
        if (CollectionUtil.isEmpty(itemTasks)) {
            return false;
        }
        return itemTasks.size() == 1 && TaskSumUtil.isIndicatorTask(itemTasks.get(0));
    }

    private static void transferOsIp(DeployNodeVo deployNodeVo, DeployNode node) {
        if (!StringUtils.isNULLStr((String)node.getOsIp())) {
            deployNodeVo.setOsIp(IpConfig.builder().currentIp(node.getOsIp()).targetIp(node.getOsIp()).userName(node.getOsUser().getUserName()).netMaskOrPrefix("--").build());
            return;
        }
        ParseLldUtil.processIpType(node, deployNodeVo);
    }

    private static void processIpType(DeployNode node, DeployNodeVo deployNodeVo) {
        Optional<ConfigStrategy> configStrategy = node.getOsNetworkStrategys().stream().filter(ParseLldUtil::containsIp).sorted(Comparator.comparing(ConfigStrategy::getPlane)).findFirst();
        if (!configStrategy.isPresent()) {
            return;
        }
        Optional.ofNullable(ParseLldUtil.getIpV4(configStrategy.get())).ifPresent(address -> ParseLldUtil.syncIpConfig(deployNodeVo, node, address));
        Optional.ofNullable(ParseLldUtil.getIpV6(configStrategy.get())).ifPresent(address -> ParseLldUtil.syncIpConfig(deployNodeVo, node, address));
    }

    private static void syncIpConfig(DeployNodeVo deployNodeVo, DeployNode node, OsIpAddress address) {
        IpConfig osIp = new IpConfig();
        osIp.setCurrentIp(address.getIp());
        osIp.setGateway(address.getGateway());
        osIp.setNetMaskOrPrefix(address.getNetMaskOrPrefix());
        osIp.setUserName(node.getOsUser().getUserName());
        if (Objects.isNull(deployNodeVo.getOsIp())) {
            deployNodeVo.setOsIp(osIp);
        } else {
            deployNodeVo.setOsDsIp(osIp);
        }
    }

    private static OsIpAddress getIpV6(ConfigStrategy strategy) {
        return strategy.getIpv6Address();
    }

    private static OsIpAddress getIpV4(ConfigStrategy strategy) {
        return strategy.getIpv4Address();
    }

    private static boolean containsIp(ConfigStrategy strategy) {
        return strategy.containsIpv4() || strategy.containsIpv6();
    }

    public static void transferBmcIp(DeployNodeVo deployNodeVo, DeployNode node) {
        IpConfig bmcIp = new IpConfig();
        bmcIp.setTargetIp(node.getIp());
        bmcIp.setCurrentIp(node.getNowBmcIp());
        bmcIp.setGateway(node.getGateway());
        bmcIp.setNetMaskOrPrefix(node.getMask());
        bmcIp.setUserName(node.getBmcUser().getUserName());
        deployNodeVo.setIbmcIp(bmcIp);
        if (node.getIpAddressDS() != null) {
            IpAddress ipAddressDS = node.getIpAddressDS();
            IpConfig bmcIpDs = new IpConfig();
            bmcIpDs.setTargetIp(ipAddressDS.getIp());
            bmcIpDs.setGateway(ipAddressDS.getGateway());
            bmcIpDs.setNetMaskOrPrefix(ipAddressDS.getNetMaskOrPrefix());
            deployNodeVo.setIbmcDsIp(bmcIpDs);
        }
    }

    private static void transferAppendFields(DeployNodeVo deployNodeVo, DeployNode node) {
        deployNodeVo.setClusterName(node.getClusterName());
        deployNodeVo.setFrontIp(ParseLldUtil.buildIpConfigByIp(node.getFrontIp()));
        deployNodeVo.setBackIp(ParseLldUtil.buildIpConfigByIp(node.getBackIp()));
        deployNodeVo.setCabinetId(node.getCabinetId());
        deployNodeVo.setSubrackId(node.getSubrackId());
        deployNodeVo.setSlotId(node.getSlotId());
    }

    public static ClusterNode parseClusterInfo(Map<String, List<Map<String, Attribute>>> fileDatas, List<DeployNode> deployNodes) {
        ClusterNode clusterNode = new ClusterNode();
        clusterNode.setDeployNodes(deployNodes);
        List<Map<String, Attribute>> clusterInfo = fileDatas.get("clusterInfo");
        if (clusterInfo.isEmpty()) {
            return clusterNode;
        }
        Map<String, Attribute> clusterInfoData = clusterInfo.get(0);
        String clusterIp = clusterInfoData.getOrDefault("clusterIp", new Attribute(new Attribute.Location(EMPTY, 0, 0), EMPTY)).getValue();
        String clusterName = clusterInfoData.getOrDefault("clusterName", new Attribute(new Attribute.Location(EMPTY, 0, 0), EMPTY)).getValue();
        deployNodes.forEach(deployNode -> deployNode.setParentId(clusterIp));
        clusterNode.setIp(clusterIp);
        clusterNode.setId(clusterIp);
        clusterNode.setName(clusterName);
        return clusterNode;
    }

    public static ClusterNode buildEmptyClusterInfo(List<DeployNode> deployNodes) {
        ClusterNode clusterNode = new ClusterNode();
        deployNodes.forEach(deployNode -> deployNode.setParentId(EMPTY));
        clusterNode.setIp(EMPTY);
        clusterNode.setId(EMPTY);
        clusterNode.setDeployNodes(deployNodes);
        return clusterNode;
    }

    private static IpConfig buildIpConfigByIp(String ip) {
        return IpConfig.builder().targetIp(ip).build();
    }

    public static StorageNodeDto buildStorageNodeDto(ExpansionManager expansionManager, String taskId, ClusterNode clusterNode) {
        return StorageNodeDto.builder().ip(clusterNode.getIp()).name(clusterNode.getName()).productVersion(clusterNode.getVersion()).productModel(clusterNode.getModel()).sn(clusterNode.getSn()).status(expansionManager.hasConfigVersion(String.join((CharSequence)"_", taskId, clusterNode.getIp())) ? ResultStatus.CONFIGURED.getKey() : ResultStatus.NOT_CONFIGURED.getKey()).build();
    }

    public static String parseSceneOfTemplate(Map<String, List<Map<String, Attribute>>> fileDatas) {
        List<Map<String, Attribute>> sceneInfos = fileDatas.get("scene");
        if (sceneInfos.isEmpty()) {
            return "Deployment";
        }
        Map<String, Attribute> clusterInfoData = sceneInfos.get(0);
        return clusterInfoData.getOrDefault("scene", new Attribute(new Attribute.Location(EMPTY, 0, 0), "Deployment")).getValue();
    }

    public static String buildPositionMsg(Map<String, Attribute> deviceInfoAttribute) {
        Attribute attribute = deviceInfoAttribute.get("bmcIp");
        return ResourceUtil.getStringWithParams((String)"importFile.position", (Object[])new Object[]{attribute.getSheetName(), attribute.getRowNum(), attribute.getColNum(), ExcelUtil.columnNumToCharacter(attribute.getColNum())});
    }
}

