/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.utils.RedfishUtils;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedfishUtil {
    private static final Logger log = LoggerFactory.getLogger(RedfishUtil.class);
    private static final String ARCH_URL = "/redfish/v1/Systems/%s/Processors/1";

    public static String getResourcePath(RedfishConnestion redfishConnection) throws ToolException {
        return redfishConnection.executeGet("/redfish/v1/Managers/").getResultJSON().getJSONArray("Members").stream().findFirst().map(resource -> JSON.parseObject((String)JSON.toJSONString((Object)resource)).getString("@odata.id")).orElseThrow(() -> new ToolException("redfish.resource.not.found", true));
    }

    public static String getCpuArchitecture(RedfishConnestion conn) {
        String slotId = RedfishUtil.getDeviceSlotId(conn);
        if (StringUtils.isNULLStr(slotId)) {
            log.error("device {} slot id is null", (Object)conn.getDestIp());
            return "--";
        }
        String url = String.format(Locale.ROOT, ARCH_URL, slotId);
        RedfishResult result = conn.executeGet(url);
        if (!result.isSuccess()) {
            log.error("device {} cmd {} send error.", (Object)conn.getDestIp(), (Object)url);
            return "--";
        }
        JSONObject chassisJson = JSON.parseObject((String)result.getResult());
        return chassisJson.getString("ProcessorArchitecture");
    }

    private static String getDeviceSlotId(RedfishConnestion conn) {
        RedfishResult result = conn.executeGet("/redfish/v1/Managers/");
        if (!result.isSuccess()) {
            return "";
        }
        if (RedfishUtils.hasKeyObject((String)result.getResult(), (String[])new String[]{"Members"})) {
            JSONArray members = (JSONArray)RedfishUtils.getObjectAttr((String)result.getResult(), JSONArray.class, (String[])new String[]{"Members"});
            String slotInfo = ObjectUtils.isEmpty((Object)members) ? "" : members.getJSONObject(0).getString("@odata.id");
            String[] split = slotInfo.split("/");
            return split[split.length - 1];
        }
        return "";
    }

    private RedfishUtil() {
    }
}

